/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.mapping;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.treelist.TreeListItem;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import com.sap.ide.webdynpro.service.controllereditor.context.ServicesCreation;
import com.sap.ide.webdynpro.service.controllereditor.context.paste.ServicesRefactoring;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class MappingHelper
extends ContextWizardHelper {
    private ContextWizardData mData;
    private Map mElementsToRename = new HashMap();
    private List mNewElements = new Vector();

    private MappingHelper() {
    }

    public static MappingHelper getInstance() {
        return new MappingHelper();
    }

    public void createAndMapContextTree(ContextWizardData data) {
        TreeListItem child;
        Iterator iter;
        List children;
        this.mData = data;
        TreeListItem rootItem = data.getHelper().get(data.getSourceContextElement());
        if (!data.getIsReverseMappingMode() && !data.getSourceContextElement().getName().equalsIgnoreCase((String)rootItem.getProperties().getValue("Name"))) {
            this.mElementsToRename.put(data.getSourceContextElement(), rootItem.getProperties().getValue("Name"));
        }
        if ((children = rootItem.getChildren()) != null) {
            iter = children.iterator();
            while (iter.hasNext()) {
                child = data.getHelper().get(iter.next());
                this.createAndMapContextSubTree(child, data.getSourceContextElement(), data.getSelectedControllerUsage(), data.getControllerUsages(), data.getIsReverseMappingMode(), data.isMergeMode(), true);
            }
        }
        if (!ServicesRefactoring.renameElements((Map)this.mElementsToRename)) {
            return;
        }
        if (rootItem.isChecked() && rootItem.isEnabled()) {
            this.createMappingOnly(data.getSourceContextElement(), data.getTargetContextElement(), data.getControllerUsages(), data.getSelectedControllerUsage(), data.getIsReverseMappingMode());
        }
        iter = children.iterator();
        while (iter.hasNext()) {
            child = data.getHelper().get(iter.next());
            this.createAndMapContextSubTree(child, data.getSourceContextElement(), data.getSelectedControllerUsage(), data.getControllerUsages(), data.getIsReverseMappingMode(), data.isMergeMode(), false);
        }
    }

    private void createAndMapContextSubTree(TreeListItem item, ContextElement parent, ControllerUsage usage, ControllerUsage[] controllerUsages, boolean isReverseMappingMode, boolean isMergeMode, boolean previewMode) {
        ContextElement newElement = null;
        if (item == null || !(item.getElement() instanceof ContextElement)) {
            return;
        }
        if (((ContextElement)item.getElement()).getMDO() == this.mData.getSourceContextElement().getMDO()) {
            if ((isReverseMappingMode || isMergeMode) && item.isChecked() && item.isEnabled()) {
                if (!previewMode) {
                    this.createMappingOnly((ContextElement)item.getElement(), (ContextElement)item.getProperties().getValue("Mapped element"), controllerUsages, usage, isReverseMappingMode);
                } else {
                    String name = (String)item.getProperties().getValue("Name");
                    if (!name.equalsIgnoreCase(((DevelopmentObject)item.getElement()).getName())) {
                        this.mElementsToRename.put(item.getElement(), name);
                    }
                }
            }
            newElement = (ContextElement)item.getElement();
        } else if (item.isChecked() && item.isEnabled()) {
            newElement = this.createAndMapContextElement((ContextElement)item.getElement(), (String)item.getProperties().getValue("Name"), parent, usage, controllerUsages, isReverseMappingMode, previewMode);
        }
        List children = item.getChildren();
        if (children == null) {
            return;
        }
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            this.createAndMapContextSubTree(this.mData.getHelper().get(iter.next()), newElement, usage, controllerUsages, isReverseMappingMode, isMergeMode, previewMode);
        }
    }

    private ContextElement createAndMapContextElement(ContextElement targetElement, String name, ContextElement parent, ControllerUsage targetUsage, ControllerUsage[] sourceUsages, boolean isReverseMappingMode, boolean previewMode) {
        AbstractContextNode newElement = null;
        if (!(parent instanceof ContextNode)) {
            return null;
        }
        ContextNode parentNode = (ContextNode)parent;
        if (targetElement instanceof ContextValueNode) {
            if (ContextService.isUniqueNodeWithinContext((String)name, (ContextNode)parentNode) != null) {
                newElement = ContextService.findContextNodeByName((String)name, (AbstractContextNode)parentNode);
            }
            if (newElement == null && !isReverseMappingMode && !previewMode) {
                newElement = ServicesCreation.createChildNodeAsContextValueNode((ContextNode)parentNode, (String)name);
                this.mNewElements.add(newElement);
            }
            if (newElement != null && !previewMode) {
                ServicesCreation.createContextValueNodeMapping((ContextValueNode)((ContextValueNode)newElement), (ControllerUsage[])sourceUsages, (ContextValueNode)((ContextValueNode)targetElement), (ControllerUsage)targetUsage, (boolean)isReverseMappingMode);
            }
        } else if (targetElement instanceof ContextModelNode) {
            if (newElement != null && !isReverseMappingMode && !newElement.getName().equalsIgnoreCase(name)) {
                this.mElementsToRename.put(newElement, name);
            }
            if (newElement == null && !isReverseMappingMode && !previewMode) {
                newElement = ServicesCreation.createChildNodeAsContextModelNode((ContextNode)parentNode, (String)name);
                this.mNewElements.add(newElement);
            }
            if (newElement != null && !previewMode) {
                ServicesCreation.createContextModelNodeMapping((ContextModelNode)((ContextModelNode)newElement), (ControllerUsage[])sourceUsages, (ContextModelNode)((ContextModelNode)targetElement), (ControllerUsage)targetUsage, (boolean)isReverseMappingMode);
            }
        } else if (targetElement instanceof ContextValueAttribute) {
            if (parentNode.hasAttribute(name)) {
                newElement = ContextService.findContextAttributeByName((String)name, (ContextNode)parentNode);
            }
            if (newElement == null && !isReverseMappingMode && !previewMode) {
                newElement = ServicesCreation.createAttributeAsContextValueAttribute((ContextNode)parentNode, (String)name);
                this.mNewElements.add(newElement);
            }
            if (newElement != null && !previewMode && this.isValidType((ContextAttribute)newElement, (ContextAttribute)targetElement, isReverseMappingMode)) {
                ServicesCreation.createContextValueAttributeMapping((ContextValueAttribute)((ContextValueAttribute)newElement), (ControllerUsage[])sourceUsages, (ContextValueAttribute)((ContextValueAttribute)targetElement), (ControllerUsage)targetUsage, (boolean)isReverseMappingMode);
            }
        } else if (targetElement instanceof ContextModelAttribute) {
            if (newElement != null && !isReverseMappingMode && !newElement.getName().equalsIgnoreCase(name)) {
                this.mElementsToRename.put(newElement, name);
            }
            if (newElement == null && !isReverseMappingMode && !previewMode) {
                newElement = ServicesCreation.createAttributeAsContextModelAttribute((ContextNode)parentNode, (String)name);
                this.mNewElements.add(newElement);
            }
            if (newElement != null && !previewMode && this.isValidType((ContextAttribute)newElement, (ContextAttribute)targetElement, isReverseMappingMode)) {
                ServicesCreation.createContextModelAttributeMapping((ContextModelAttribute)((ContextModelAttribute)newElement), (ControllerUsage[])sourceUsages, (ContextModelAttribute)((ContextModelAttribute)targetElement), (ControllerUsage)targetUsage, (boolean)isReverseMappingMode);
            }
        }
        return newElement;
    }

    private void createMappingOnly(ContextElement sourceElement, ContextElement targetElement, ControllerUsage[] sourceUsages, ControllerUsage targetUsage, boolean isReverseMappingMode) {
        if (sourceElement == null || targetElement == null || sourceUsages == null || targetUsage == null) {
            return;
        }
        if (sourceElement instanceof ContextValueNode) {
            ServicesCreation.createContextValueNodeMapping((ContextValueNode)((ContextValueNode)sourceElement), (ControllerUsage[])sourceUsages, (ContextValueNode)((ContextValueNode)targetElement), (ControllerUsage)targetUsage, (boolean)isReverseMappingMode);
        } else if (sourceElement instanceof ContextModelNode) {
            ServicesCreation.createContextModelNodeMapping((ContextModelNode)((ContextModelNode)sourceElement), (ControllerUsage[])sourceUsages, (ContextModelNode)((ContextModelNode)targetElement), (ControllerUsage)targetUsage, (boolean)isReverseMappingMode);
        } else if (sourceElement instanceof ContextModelAttribute) {
            ServicesCreation.createContextModelAttributeMapping((ContextModelAttribute)((ContextModelAttribute)sourceElement), (ControllerUsage[])sourceUsages, (ContextModelAttribute)((ContextModelAttribute)targetElement), (ControllerUsage)targetUsage, (boolean)isReverseMappingMode);
        } else if (sourceElement instanceof ContextValueAttribute) {
            ServicesCreation.createContextValueAttributeMapping((ContextValueAttribute)((ContextValueAttribute)sourceElement), (ControllerUsage[])sourceUsages, (ContextValueAttribute)((ContextValueAttribute)targetElement), (ControllerUsage)targetUsage, (boolean)isReverseMappingMode);
        }
    }

    private boolean isValidType(ContextAttribute sourceAttribute, ContextAttribute targetAttribute, boolean isReverseMapping) {
        if (isReverseMapping) {
            DevelopmentObject sourceType = CheckLayerHelper.getType((ContextAttribute)sourceAttribute);
            DevelopmentObject targetType = CheckLayerHelper.getType((ContextAttribute)targetAttribute);
            if (sourceAttribute != null && targetType != null) {
                return CheckLayerHelper.isValidType((DevelopmentObject)sourceType, (DevelopmentObject)targetType) == null;
            }
        }
        return true;
    }

    public static ContextElement findMappingCandidate(ContextElement element, ContextElement sourceElement, ContextElement targetElement) {
        ContextElement candidate = null;
        String name = element.getName();
        ContextValueNode targetContext = ((Controller)targetElement.getMDO()).getContext();
        if (element == sourceElement) {
            candidate = targetElement;
        } else if (element instanceof ContextNode && targetElement instanceof AbstractContextNode) {
            candidate = ContextService.findContextNodeByName((String)name, (AbstractContextNode)((AbstractContextNode)targetElement));
        } else if (element instanceof ContextAttribute) {
            Object targetParent = null;
            targetParent = element.getParent() != null && !element.getParent().isMDO() ? (element.getParent() == sourceElement && targetElement instanceof ContextNode ? (ContextNode)targetElement : (ContextNode)ContextService.findContextNodeByName((String)element.getParent().getName(), (AbstractContextNode)targetContext)) : targetContext;
            if (targetParent != null) {
                candidate = ContextService.findContextAttributeByName((String)name, (ContextNode)targetParent);
            }
        }
        return MappingHelper.checkElementType(element, candidate);
    }

    private static ContextElement checkElementType(ContextElement element, ContextElement candidate) {
        if (candidate != null && element != null && element.getClass().equals(candidate.getClass())) {
            return candidate;
        }
        return null;
    }
}

