/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context.mapping;

import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.context.PageContextSelection;
import com.sap.ide.webdynpro.controllereditor.wizards.context.mapping.MappingHelper;
import com.sap.ide.webdynpro.controllereditor.wizards.context.mapping.PageContextMapping;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ContextMappingWizard
extends Wizard {
    private ContextWizardData mData;
    private PageContextSelection mPageContextSelection;
    private PageContextMapping mPageContextMapping;

    public ContextMappingWizard(String windowTitle, ContextElement sourceElement, ControllerUsage[] controllerUsages, ControllerUsage defaultControllerUsage, boolean isReverseMappingMode) {
        this.setNeedsProgressMonitor(true);
        this.mData = new ContextWizardData();
        this.mData.setSourceContextElement(sourceElement);
        this.mData.setControllerUsages(controllerUsages);
        this.mData.setDefaultControllerUsage(defaultControllerUsage);
        this.mData.setIsReverseMappingMode(isReverseMappingMode);
        this.setWindowTitle(TextPool.getInstance().getText(2307));
        this.setDefaultPageImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.IMG_CONTEXT_MAPPING_BANNER));
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage.equals(this.mPageContextSelection) && !(this.mData.getSourceContextElement() instanceof ContextAttribute)) {
            return false;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        ContextElement target = this.mData.getTargetContextElement();
        if (target != null) {
            if (this.mData.getHelper() == null) {
                this.mPageContextMapping.initializeItems(null);
                this.mData.getHelper().checkEnabledItems(true);
            }
            MappingHelper.getInstance().createAndMapContextTree(this.mData);
        }
        return true;
    }

    public void addPages() {
        this.mPageContextSelection = new PageContextSelection(this.mData);
        this.mPageContextMapping = new PageContextMapping(this.mData);
        this.addPage((IWizardPage)this.mPageContextSelection);
        if (!(this.mData.getSourceContextElement() instanceof ContextAttribute)) {
            this.addPage((IWizardPage)this.mPageContextMapping);
        }
    }
}

