/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.webdynpro.controllereditor.context.ContextListBarViewer;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelBindingValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.ControllerWizardPage;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ISelectionValidator;

public class PageModelSelection
extends ControllerWizardPage {
    private static final String TITLE;
    private static final String PAGE_NAME;
    private ContextListBarViewer mListBarViewer;
    private ContextWizardData mData;
    private ISelectionValidator mValidator;
    private boolean mFirstTime = true;

    public PageModelSelection(ContextWizardData data) {
        super(PAGE_NAME);
        this.setTitle(TITLE);
        this.setDescription(TextPool.getInstance().getText(2506));
        this.mData = data;
        this.mValidator = new ModelBindingValidator(data.getSourceContextElement(), this.mData.getControllerUsages());
        this.setPageComplete(false);
    }

    public boolean canFlipToNextPage() {
        DevelopmentObject target = this.mData.getTargetModelEntity();
        return super.canFlipToNextPage() && !(target instanceof Property);
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout());
        this.setControl((Control)root);
        this.mListBarViewer = new ContextListBarViewer(this.mData.getModels());
        this.mListBarViewer.init(root);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 300;
        data.widthHint = 250;
        this.mListBarViewer.getControl().setLayoutData((Object)data);
        this.mListBarViewer.addSelectionChangedListener(new ContextSelectionChangeListener());
        DevelopmentObject elementToSelect = this.getElementForInitialSelection(this.mData.getSourceContextElement());
        if (elementToSelect != null) {
            this.mListBarViewer.setSelection((ISelection)new StructuredSelection((Object)elementToSelect));
        }
    }

    private DevelopmentObject getElementForInitialSelection(ContextElement sourceElement) {
        DevelopmentObject parentObject;
        if (sourceElement instanceof ContextModelNode) {
            ContextModelNode modelNode = (ContextModelNode)sourceElement;
            ModelClass modelClass = modelNode.getModelClass();
            if (modelClass != null) {
                if (modelNode.hasSupplyingRelationRole()) {
                    return modelNode.getSupplyingRelationRole();
                }
                return modelClass;
            }
        } else if (sourceElement instanceof ContextModelAttribute) {
            return ((ContextModelAttribute)sourceElement).getReferencedProperty();
        }
        if ((parentObject = sourceElement.getParent()) instanceof ContextModelNode || parentObject instanceof ContextModelAttribute) {
            return this.getElementForInitialSelection((ContextElement)parentObject);
        }
        return null;
    }

    static {
        PAGE_NAME = TITLE = TextPool.getInstance().getText(2306);
    }

    private class ContextSelectionChangeListener
    implements ISelectionChangedListener {
        private ContextSelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!event.getSelection().isEmpty()) {
                DevelopmentObject selection = (DevelopmentObject)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selection instanceof DevelopmentObject) {
                    String message = PageModelSelection.this.mValidator.isValid((Object)selection);
                    if (message == null) {
                        PageModelSelection.this.mData.setTargetModelEntity(selection);
                        PageModelSelection.this.setErrorMessage(null);
                        PageModelSelection.this.setPageComplete(true);
                    } else if (!PageModelSelection.this.mFirstTime || !PageModelSelection.this.mListBarViewer.getSelection().isEmpty()) {
                        PageModelSelection.this.setErrorMessage(message);
                    }
                }
            } else {
                PageModelSelection.this.setPageComplete(false);
            }
            PageModelSelection.this.mFirstTime = false;
        }
    }
}

