/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.context;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElementMapping;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.controllereditor.context.ContextElementSelection;
import com.sap.ide.webdynpro.controllereditor.context.ContextListBarViewer;
import com.sap.ide.webdynpro.controllereditor.context.ContextMappingValidator;
import com.sap.ide.webdynpro.controllereditor.wizards.ControllerWizardPage;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardData;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ISelectionValidator;

public class PageContextSelection
extends ControllerWizardPage {
    private static final String TITLE_NAME;
    private static final String PAGE_NAME;
    private ContextListBarViewer mListBarViewer;
    private ContextWizardData mData;
    private ISelectionValidator mValidator;
    private String mMessage;
    private boolean mFirstTime = true;

    public PageContextSelection(ContextWizardData data) {
        super(PAGE_NAME);
        this.setTitle(TITLE_NAME);
        this.setDescription(TextPool.getInstance().getText(2505));
        this.mData = data;
        this.mValidator = new ContextMappingValidator(data.getSourceContextElement(), data.getControllerUsages(), data.getIsReverseMappingMode());
        this.setPageComplete(false);
    }

    public boolean isPageComplete() {
        return super.isPageComplete();
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout());
        this.setControl((Control)root);
        this.mListBarViewer = new ContextListBarViewer(this.mData.getControllerUsages());
        this.mListBarViewer.init(root);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 300;
        data.widthHint = 250;
        this.mListBarViewer.getControl().setLayoutData((Object)data);
        this.mListBarViewer.addSelectionChangedListener(new ContextSelectionChangeListener());
        ISelection selection = this.getInitialSelection(this.mData.getSourceContextElement());
        this.mListBarViewer.setSelection(selection);
    }

    private ISelection getInitialSelection(ContextElement sourceElement) {
        ControllerUsage[] usages = this.mData.getControllerUsages();
        ContextElementMapping mapping = CheckLayerHelper.getMapping((ContextElement)sourceElement, (ControllerUsage[])usages);
        if (mapping != null) {
            return new ContextElementSelection(mapping);
        }
        DevelopmentObject parentObject = sourceElement.getParent();
        if (parentObject instanceof ContextElement) {
            return this.getInitialSelection((ContextElement)parentObject);
        }
        return StructuredSelection.EMPTY;
    }

    static {
        PAGE_NAME = TITLE_NAME = TextPool.getInstance().getText(2305);
    }

    private class ContextSelectionChangeListener
    implements ISelectionChangedListener {
        private ContextSelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (!selection.isEmpty() && selection instanceof ContextElementSelection) {
                ContextElementSelection contextSelection = (ContextElementSelection)selection;
                ContextElement selectedElement = (ContextElement)contextSelection.getFirstElement();
                PageContextSelection.this.mMessage = PageContextSelection.this.mValidator.isValid((Object)selectedElement);
                if (PageContextSelection.this.mMessage == null) {
                    PageContextSelection.this.mData.setTargetContextElement(selectedElement);
                    PageContextSelection.this.mData.setSelectedControllerUsage(contextSelection.getControllerUsage());
                    PageContextSelection.this.setPageComplete(true);
                    PageContextSelection.this.setErrorMessage(null);
                } else if (!PageContextSelection.this.mFirstTime || !PageContextSelection.this.mListBarViewer.getSelection().isEmpty()) {
                    PageContextSelection.this.setErrorMessage(PageContextSelection.this.mMessage);
                }
            } else {
                PageContextSelection.this.setPageComplete(false);
            }
            PageContextSelection.this.mFirstTime = false;
        }
    }
}

