/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.componentusage;

import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterface;
import com.sap.ide.metamodel.webdynpro.enum.ComponentLifecycleEnum;
import com.sap.ide.webdynpro.controllereditor.wizards.componentusage.CreateComponentUsageWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.componentusage.CreateComponentUsageWizardPropertiesPage;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.usage.ComponentUsageService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateComponentUsageWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String TITLE = mTextPool.getText(66);
    private CreateComponentUsageWizardData mData = null;
    private CreateComponentUsageWizardPropertiesPage mPropertiesPage = null;
    private Component mComponent = null;

    public CreateComponentUsageWizard(Component component) {
        this(component, new CreateComponentUsageWizardData());
    }

    public CreateComponentUsageWizard(Component component, CreateComponentUsageWizardData data) {
        this.mData = data;
        this.mComponent = component;
        this.setWindowTitle(mTextPool.getText(596));
    }

    public boolean performFinish() {
        ComponentInterface componentInterface = this.mData.getUsedComponentInterface();
        if (componentInterface == null) {
            this.mPropertiesPage.setErrorMessage("Please enter a Web Dynpro component or component interface definition to use.");
            return false;
        }
        ComponentUsageService.createComponentUsage((Component)this.mComponent, (String)this.mData.getName(), (ComponentInterface)this.mData.getUsedComponentInterface(), (ComponentLifecycleEnum)this.mData.getSelectedComponentLifecycle());
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(TITLE);
    }

    public void addPages() {
        this.mPropertiesPage = new CreateComponentUsageWizardPropertiesPage(this.mData, this.mComponent);
        this.addPage((IWizardPage)this.mPropertiesPage);
    }

    public CreateComponentUsageWizardData getData() {
        return this.mData;
    }
}

