/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.wizards.action;

import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.base.ParameterizedFeature;
import com.sap.ide.metamodel.webdynpro.component.controller.Action;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.navigation.OutboundPlug;
import com.sap.ide.metamodel.webdynpro.framework.FrameworkEvent;
import com.sap.ide.webdynpro.controllereditor.IDialogWithButtonAccess;
import com.sap.ide.webdynpro.controllereditor.wizards.action.CreateActionWizardData;
import com.sap.ide.webdynpro.controllereditor.wizards.action.CreateActionWizardPropertiesPage;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.CreateParametersWizardPage;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.CreateParametersWizardTableModel;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.action.ActionService;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterPlaceholder;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateActionWizard
extends Wizard
implements INewWizard {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String TITLE = mTextPool.getText(66);
    private IDialogWithButtonAccess mDialog = null;
    private CreateActionWizardData mData = null;
    private CreateActionWizardPropertiesPage mPropertiesPage = null;
    private CreateParametersWizardPage mParametersPage = null;
    private Controller mController = null;

    public CreateActionWizard(Controller controller) {
        this(controller, new CreateActionWizardData(controller));
    }

    public CreateActionWizard(Controller controller, FrameworkEvent uiEvent) {
        this(controller, new CreateActionWizardData(controller, uiEvent));
    }

    public CreateActionWizard(Controller controller, CreateActionWizardData data) {
        this.mData = data;
        this.mController = controller;
        this.setWindowTitle(mTextPool.getText(595));
    }

    public void setWizardDialog(IDialogWithButtonAccess dialog) {
        this.mDialog = dialog;
    }

    public boolean performFinish() {
        String message = ActionService.isNewActionNameValid((String)this.mData.getName(), (Controller)this.mController, (this.mData.getSelectedEventHandlerIndex() == -1 ? 1 : 0) != 0);
        if (message != null) {
            this.mPropertiesPage.setErrorMessage(message);
            return false;
        }
        message = ActionService.isEventHandlerValid((EventHandler)this.mController.getEventHandler(this.mData.getSelectedEventHandlerName()), (boolean)this.mData.getBeforeValidation());
        if (message != null) {
            this.mPropertiesPage.setErrorMessage(message);
            return false;
        }
        message = ActionService.createAction((Controller)this.mController, (String)this.mData.getName(), (String)this.mData.getText(), (String)this.mData.getEventHandlerName(), (boolean)this.mData.getBeforeValidation(), (FrameworkEvent)this.mData.getUiEvent(), (boolean)this.mData.getCreateUiEventParameters(), (OutboundPlug)this.mData.getPlugToFire());
        if (message != null) {
            this.mPropertiesPage.setErrorMessage(message);
            return false;
        }
        Action action = this.mController.getAction(this.mData.getName());
        if (action != null && (message = ParameterService.createParameters((ParameterizedFeature)action, (ParameterPlaceholder[])this.mParametersPage.getParameters())) != null) {
            this.mPropertiesPage.setErrorMessage(message);
            return false;
        }
        if (action.hasEventHandler() && this.mParametersPage.getAddParametersAlsoToEventHandler() && (message = ParameterService.createParameters((ParameterizedFeature)action.getEventHandler(), (ParameterPlaceholder[])this.mParametersPage.getParameters())) != null) {
            this.mPropertiesPage.setErrorMessage(message);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(TITLE);
    }

    public void addPages() {
        this.mPropertiesPage = new CreateActionWizardPropertiesPage(this.mData, this.mController, this.mDialog);
        this.addPage((IWizardPage)this.mPropertiesPage);
        CreateParametersWizardTableModel parametersTableModel = new CreateParametersWizardTableModel(this.mController, null, false);
        this.mParametersPage = new CreateParametersWizardPage(parametersTableModel, this.mController, null);
        this.mParametersPage.setShowAddParametersAlsoToEventHandler(true);
        this.addPage((IWizardPage)this.mParametersPage);
    }

    public CreateActionWizardData getData() {
        return this.mData;
    }
}

