/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.plugs;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.base.ParameterizedFeature;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.navigation.InboundPlug;
import com.sap.ide.metamodel.webdynpro.component.navigation.OutboundPlug;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableModel;
import com.sap.ide.webdynpro.controllereditor.parameters.ParameterEditDialog;
import com.sap.ide.webdynpro.controllereditor.parameters.ParametersTableModel;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.CreateParameterWizardDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.plug.CreateInboundPlugParameterWizardDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.plug.RenameInboundPlugParameterWizard;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterService;
import com.sap.ide.webdynpro.service.controllereditor.plug.PlugService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.MessageDialogWithCheckBoxes;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardDialog;
import com.sap.ide.webdynpro.ui.dialog.wizard.WebDynproWizardDialog;
import org.eclipse.ui.PlatformUI;

public class PlugParametersTableModel
extends ParametersTableModel {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final int NUMBER_OF_COLUMNS = 2;
    private static final String[] COLUMN_NAMES = new String[]{AbstractControllerTableModel.mTextPool.getText(62), AbstractControllerTableModel.mTextPool.getText(63)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PlugParametersTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = PlugParametersTableModel.class$("java.lang.String")) : class$java$lang$String};
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_TYPE = 1;
    private int mPlugType = -1;
    private AbstractView mView = null;
    public static final int PLUG_TYPE_INBOUND = 0;
    public static final int PLUG_TYPE_OUTBOUND = 1;
    static /* synthetic */ Class class$java$lang$String;

    public PlugParametersTableModel(Controller controller, AbstractView view) {
        super(controller);
        this.setNumberOfColumns(2);
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.mView = view;
        this.updateDataTable();
        ((MainDevelopmentObject)this.mView).attachChildrenObserver((DevelopmentObjectObserver)this);
    }

    public void setPlugType(int type) {
        this.mPlugType = type;
    }

    protected void doNew() {
        if (this.mSelectedParent == null) {
            return;
        }
        ParameterizedFeature plug = this.mSelectedParent;
        WebDynproWizardDialog dialog = null;
        if (plug instanceof InboundPlug) {
            MMRepositoryObject[] repositoryObjects = PlugService.getRepositoryObjectsAffectedByInboundPlugParameterCreation((InboundPlug)((InboundPlug)plug));
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            dialog = new CreateInboundPlugParameterWizardDialog(plug, this.getController(), null);
        } else {
            MMRepositoryObject[] repositoryObjects = ParameterService.getRepositoryObjectsAffectedByParameterCreation((ParameterizedFeature)plug);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            dialog = new CreateParameterWizardDialog(plug, this.getController(), null);
        }
        dialog.open();
        dialog.close();
    }

    protected void doDelete(int[] indexes) {
        if (this.mSelectedParent == null) {
            return;
        }
        ParameterizedFeature object = this.mSelectedParent;
        if (object instanceof InboundPlug) {
            this.doDelete((InboundPlug)object, indexes);
        } else {
            super.doDelete(indexes);
        }
    }

    protected void doEdit(int[] indexes) {
        if (this.mSelectedParent == null) {
            return;
        }
        ParameterizedFeature object = this.mSelectedParent;
        if (object instanceof InboundPlug) {
            this.doEdit((InboundPlug)object, indexes);
        } else {
            super.doEdit(indexes);
        }
    }

    protected void doRename(int[] indexes) {
        if (this.mSelectedParent instanceof InboundPlug) {
            Parameter[] parameters = this.getIndexesParameters(indexes);
            int i = 0;
            while (i < indexes.length) {
                Parameter parameter = parameters[i];
                MMRepositoryObject[] repositoryObjects = ParameterService.getRepositoryObjectsAffectedByParameterModification((Parameter)parameter);
                if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                    return;
                }
                RenameInboundPlugParameterWizard renameWizard = new RenameInboundPlugParameterWizard((DevelopmentObject)parameter);
                RenameWizardDialog wizardDialog = new RenameWizardDialog((RenameWizard)renameWizard);
                wizardDialog.open();
                wizardDialog.close();
                ++i;
            }
        } else {
            super.doRename(indexes);
        }
    }

    private void doDelete(InboundPlug plug, int[] indexes) {
        Parameter[] parameters = this.getIndexesParameters(indexes);
        boolean userSaidDeleteAll = false;
        int result = -1;
        int i = 0;
        while (i < parameters.length) {
            Parameter parameter = parameters[i];
            MMRepositoryObject[] repositoryObjects = PlugService.getRepositoryObjectsAffectedByInboundPlugParameterDeletion((Parameter)parameter);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            String[] buttons = new String[]{mCoreTextPool.getText(150), mCoreTextPool.getText(164), mCoreTextPool.getText(151)};
            String[] questions = new String[]{};
            boolean[] questionsDefaultValues = new boolean[]{};
            if (!this.getController().getType().equals(ControllerTypeEnum.INTERFACE_VIEW)) {
                questions = new String[]{AbstractControllerTableModel.mTextPool.getText(171)};
                questionsDefaultValues = new boolean[]{true};
            }
            MessageDialogWithCheckBoxes dialog = new MessageDialogWithCheckBoxes(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), mCoreTextPool.getText(400, (Object)AbstractControllerTableModel.mTextPool.getText(18)), null, mCoreTextPool.getText(401, (Object)AbstractControllerTableModel.mTextPool.getText(18), (Object)parameter.getName()), 3, buttons, 2, questions, questionsDefaultValues);
            if (!userSaidDeleteAll) {
                result = dialog.open();
                dialog.close();
                if (result == 1) {
                    userSaidDeleteAll = true;
                    result = 0;
                }
            }
            if (result == 0) {
                boolean deleteEventHandlerParameter = true;
                if (questions.length > 0) {
                    deleteEventHandlerParameter = dialog.getAnswers()[0];
                }
                PlugService.deleteInboundPlugParameter((InboundPlug)plug, (Parameter)parameter, (boolean)deleteEventHandlerParameter);
            }
            ++i;
        }
    }

    private void doEdit(InboundPlug plug, int[] indexes) {
        Parameter[] parameters = this.getIndexesParameters(indexes);
        int i = 0;
        while (i < parameters.length) {
            ParameterEditDialog dialog;
            Parameter parameter = parameters[i];
            MMRepositoryObject[] repositoryObjects = PlugService.getRepositoryObjectsAffectedByInboundPlugParameterModification((Parameter)parameter);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            String objectToAdapt = null;
            if (!this.getController().getType().equals(ControllerTypeEnum.INTERFACE_VIEW)) {
                objectToAdapt = AbstractControllerTableModel.mTextPool.getText(169);
            }
            if ((dialog = new ParameterEditDialog(parameter, this.getController(), 1, objectToAdapt, true)).open() == 0) {
                PlugService.editInboundPlugParameter((InboundPlug)plug, (Parameter)parameter, (DevelopmentObject)dialog.getNewParameterType(), (MetamodelServices.CompoundType)dialog.getNewParameterTypeAsCompoundType(), (boolean)dialog.isAdaptSubObject());
            }
            ++i;
        }
    }

    public void tableModelDisposed() {
        super.tableModelDisposed();
        ((MainDevelopmentObject)this.mView).detachChildrenObserver((DevelopmentObjectObserver)this);
    }

    protected boolean isReadOnly() {
        if (this.mPlugType == 0) {
            return this.getController().originatesInArchive() || this.mView.originatesInArchive() || !this.isModifiedParentObjectRelevant((DevelopmentObject)this.mSelectedParent);
        }
        return this.mView.originatesInArchive() || !this.isModifiedParentObjectRelevant((DevelopmentObject)this.mSelectedParent);
    }

    protected boolean isModifiedParentObjectRelevant(DevelopmentObject object) {
        return object instanceof InboundPlug || object instanceof OutboundPlug;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

