/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.plugs;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.navigation.OutboundPlug;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.enum.OutboundPlugTypeEnum;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableModel;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.plugs.OutboundPlugEditDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.plug.CreateOutboundPlugWizardDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.plug.RenameOutboundPlugWizard;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesDeletion;
import com.sap.ide.webdynpro.service.controllereditor.ControllerPasteManager;
import com.sap.ide.webdynpro.service.controllereditor.plug.PlugService;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectNameComparator;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardDialog;
import java.util.Arrays;

public class OutboundPlugsTableModel
extends AbstractControllerTableModel {
    private static final int NUMBER_OF_COLUMNS_VIEW = 1;
    private static final int NUMBER_OF_COLUMNS_INTERFACE_VIEW_IMPL = 2;
    private static final int NUMBER_OF_COLUMNS_INTERFACE_VIEW_DEF = 1;
    private static final String[] COLUMN_NAMES = new String[]{AbstractControllerTableModel.mTextPool.getText(64), AbstractControllerTableModel.mTextPool.getText(156)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = OutboundPlugsTableModel.class$("java.lang.String")) : class$java$lang$String, class$org$eclipse$swt$widgets$Button == null ? (class$org$eclipse$swt$widgets$Button = OutboundPlugsTableModel.class$("org.eclipse.swt.widgets.Button")) : class$org$eclipse$swt$widgets$Button};
    private static final int[] COLUMN_WIDTHS = new int[]{Integer.MAX_VALUE, 16};
    private static final int COLUMN_NAME = 0;
    public static final int COLUMN_EXIT_PLUG = 1;
    protected AbstractView mView = null;
    protected OutboundPlug[] mOutboundPlugs = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$eclipse$swt$widgets$Button;

    public OutboundPlugsTableModel(Controller controller, AbstractView view) {
        super(controller);
        if (controller.getType().equals(ControllerTypeEnum.INTERFACE_VIEW)) {
            if (controller.getParent() instanceof ComponentInterfaceDefinition) {
                this.setNumberOfColumns(1);
            } else {
                this.setNumberOfColumns(2);
            }
        } else {
            this.setNumberOfColumns(1);
        }
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.mView = view;
        this.updateDataTable();
        this.mView.attachObserver((DevelopmentObjectObserver)this);
        if (this.mView instanceof MainDevelopmentObject) {
            ((MainDevelopmentObject)this.mView).attachChildrenObserver((DevelopmentObjectObserver)this);
        } else {
            Plugin.internalError(this.getClass(), "InboundPlugsTableModel(Controller, AbstractView", "mView is no MDO", new Exception(), false);
        }
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 | index > this.mOutboundPlugs.length) {
            return null;
        }
        return this.mOutboundPlugs[index];
    }

    protected void masterObjectChanged(DevelopmentObject newMasterObject) {
        super.masterObjectChanged(newMasterObject);
    }

    protected void updateDataTable() {
        if (this.mView != null) {
            this.mOutboundPlugs = this.mView.getOutboundPlugs();
            Arrays.sort(this.mOutboundPlugs, new DevelopmentObjectNameComparator());
        }
    }

    public int getRowCount() {
        if (this.mOutboundPlugs == null) {
            return 0;
        }
        return this.mOutboundPlugs.length;
    }

    public int[] getColumnWidths() {
        return COLUMN_WIDTHS;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mOutboundPlugs == null || this.mOutboundPlugs.length <= rowIndex) {
            return AbstractControllerTableModel.ERROR;
        }
        OutboundPlug plug = this.mOutboundPlugs[rowIndex];
        if (plug == null) {
            return AbstractControllerTableModel.ERROR;
        }
        switch (columnIndex) {
            case 0: {
                return plug.getName();
            }
            case 1: {
                return new Boolean(plug.getType().equals(OutboundPlugTypeEnum.EXIT));
            }
        }
        return AbstractControllerTableModel.ERROR;
    }

    protected void doCopy(MetamodelClipboard clipboard, int[] indexes) {
        OutboundPlug[] plugs = this.getIndexesPlugs(indexes);
        clipboard.copy((DevelopmentObject[])plugs);
    }

    protected void doPaste(MetamodelClipboard clipboard) {
        MMRepositoryObject[] repositoryObjects = PlugService.getRepositoryObjectsAffectedByOutboundPlugCreation((AbstractView)this.mView);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        ControllerPasteManager controllerPasteManager = new ControllerPasteManager();
        controllerPasteManager.paste(clipboard, (MetamodelObject)this.mView);
    }

    protected boolean canPaste(MetamodelClipboard clipboard) {
        DevelopmentObjectEnum[] objects = clipboard.getContentTypes();
        int i = 0;
        while (i < objects.length) {
            if (!objects[i].equals(WebDynproDevelopmentObjectEnum.OUTBOUNDPLUG)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void doRename(int[] indexes) {
        OutboundPlug[] plugs = this.getIndexesPlugs(indexes);
        int i = 0;
        while (i < plugs.length) {
            OutboundPlug plug = plugs[i];
            MMRepositoryObject[] repositoryObjects = PlugService.getRepositoryObjectsAffectedByOutboundPlugModification((OutboundPlug)plug);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            RenameOutboundPlugWizard renameWizard = new RenameOutboundPlugWizard((DevelopmentObject)plug);
            RenameWizardDialog wizardDialog = new RenameWizardDialog((RenameWizard)renameWizard);
            wizardDialog.open();
            wizardDialog.close();
            ++i;
        }
    }

    protected void doDelete(int[] indexes) {
        OutboundPlug[] plugs = this.getIndexesPlugs(indexes);
        boolean userSaidDeleteAll = false;
        int result = -1;
        int i = 0;
        while (i < plugs.length) {
            OutboundPlug outboundPlug = plugs[i];
            MMRepositoryObject[] repositoryObjects = PlugService.getRepositoryObjectsAffectedByOutboundPlugDeletion((OutboundPlug)outboundPlug);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            if (!userSaidDeleteAll && (result = UIHelper.askUserToDeleteAll((String)outboundPlug.getName(), (String)AbstractControllerTableModel.mTextPool.getText(17))) == 1) {
                userSaidDeleteAll = true;
                result = 0;
            }
            if (result == 0) {
                ServicesDeletion.deleteOutboundPlug((OutboundPlug)outboundPlug, (boolean)false);
            }
            ++i;
        }
    }

    protected void doEdit(int[] indexes) {
        OutboundPlug[] plugs = this.getIndexesPlugs(indexes);
        int i = 0;
        while (i < plugs.length) {
            OutboundPlug outboundPlug = plugs[i];
            MMRepositoryObject[] repositoryObjects = PlugService.getRepositoryObjectsAffectedByOutboundPlugModification((OutboundPlug)outboundPlug);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            OutboundPlugEditDialog dialog = new OutboundPlugEditDialog(outboundPlug, 1);
            if (dialog.open() == 0) {
                PlugService.editOutboundPlug((OutboundPlug)outboundPlug, (boolean)dialog.getNewExitPlug());
            }
            ++i;
        }
    }

    protected void doNew() {
        MMRepositoryObject[] repositoryObjects = PlugService.getRepositoryObjectsAffectedByOutboundPlugCreation((AbstractView)this.mView);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        CreateOutboundPlugWizardDialog dialog = new CreateOutboundPlugWizardDialog(this.mView);
        dialog.open();
        dialog.close();
    }

    public boolean isEditable(int[] indexes) {
        return this.getController().getType().equals(ControllerTypeEnum.INTERFACE_VIEW);
    }

    public boolean isPasteable() {
        MetamodelClipboard clipboard = Metamodel.getClipboard();
        return !this.isReadOnly() && clipboard.isPasteAllowed((MetamodelObject)this.mView) && this.canPaste(clipboard);
    }

    public void tableModelDisposed() {
        super.tableModelDisposed();
        this.mView.detachObserver((DevelopmentObjectObserver)this);
        ((MainDevelopmentObject)this.mView).detachChildrenObserver((DevelopmentObjectObserver)this);
    }

    protected boolean isReadOnly() {
        return this.mView.originatesInArchive();
    }

    protected boolean isEventRelevant(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof OutboundPlug) {
            switch (event.getEventId()) {
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 64: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private OutboundPlug[] getIndexesPlugs(int[] indexes) {
        OutboundPlug[] plugs = new OutboundPlug[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            plugs[i] = this.mOutboundPlugs[indexes[i]];
            ++i;
        }
        return plugs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

