/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.plugs;

import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.webdynpro.controllereditor.EditUI;
import com.sap.ide.webdynpro.controllereditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.controllereditor.wizards.plug.CreateOutboundPlugWizardData;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.plug.PlugService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

public class OutboundPlugEditUI
extends EditUI {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    private AbstractView mView = null;
    private Controller mController = null;
    private CreateOutboundPlugWizardData mData = null;
    private int mMode;
    private Text mNameField = null;
    private Button mExitPlugField = null;

    public OutboundPlugEditUI(CreateOutboundPlugWizardData data, int mode, AbstractView view, IDisplayErrorListener displayErrorListener) {
        super(displayErrorListener);
        this.mData = data;
        this.mMode = mode;
        this.mView = view;
        this.mController = view.getViewController();
    }

    public void initUI(IGridLayoutPane glp) {
        glp.addTextLabel(mTextPool.getText(127));
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, false);
        this.mNameField = glp.addTextField(this.mData.getName(), this.mMode == 1, gd);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        this.mNameField.setFocus();
        if (this.mView.getViewController().getType().equals(ControllerTypeEnum.INTERFACE_VIEW)) {
            if (!(this.mController.getParent() instanceof ComponentInterfaceDefinition)) {
                glp.addTextLabel(mTextPool.getText(157));
                gd = glp.createGridLayoutData(4, 4, true, false);
                this.mExitPlugField = glp.addCheckBox("", this.mData.getExitPlug(), gd);
                this.mExitPlugField.addSelectionListener((SelectionListener)new ExitPlugSelectionListener());
            } else {
                this.mData.setExitPlug(false);
            }
        }
        this.getDisplayErrorListener().setErrorMessage("");
    }

    private boolean validatePage() {
        String error = null;
        if (this.mMode != 1) {
            error = PlugService.isNewOutboundPlugNameValid((String)this.mNameField.getText(), (AbstractView)this.mView);
            this.getDisplayErrorListener().setErrorMessage(error);
            if (error != null) {
                return false;
            }
        }
        return true;
    }

    public void setVisible(boolean visible) {
        this.mNameField.setFocus();
    }

    private class ExitPlugSelectionListener
    implements SelectionListener {
        private ExitPlugSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            OutboundPlugEditUI.this.mData.setExitPlug(OutboundPlugEditUI.this.mExitPlugField.getSelection());
        }
    }

    private class NameModifyListener
    implements ModifyListener {
        private NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            OutboundPlugEditUI.this.validatePage();
            OutboundPlugEditUI.this.mData.setName(OutboundPlugEditUI.this.mNameField.getText());
        }
    }
}

