/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.plugs;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectRefactoredEvent;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.navigation.InboundPlug;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.enum.InboundPlugTypeEnum;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableModel;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.plugs.InboundPlugEditDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.plug.CreateInboundPlugWizardDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.plug.RenameInboundPlugWizard;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesDeletion;
import com.sap.ide.webdynpro.service.controllereditor.ControllerPasteManager;
import com.sap.ide.webdynpro.service.controllereditor.plug.PlugService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectNameComparator;
import com.sap.ide.webdynpro.service.core.MessageDialogWithCheckBoxes;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardDialog;
import java.util.Arrays;
import org.eclipse.ui.PlatformUI;

public class InboundPlugsTableModel
extends AbstractControllerTableModel {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final int NUMBER_OF_COLUMNS_VIEW = 2;
    private static final int NUMBER_OF_COLUMNS_INTERFACE_VIEW_IMPL = 3;
    private static final int NUMBER_OF_COLUMNS_INTERFACE_VIEW_DEF = 1;
    private static final String[] COLUMN_NAMES = new String[]{AbstractControllerTableModel.mTextPool.getText(64), AbstractControllerTableModel.mTextPool.getText(65), AbstractControllerTableModel.mTextPool.getText(158)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = InboundPlugsTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = InboundPlugsTableModel.class$("java.lang.String")) : class$java$lang$String, class$org$eclipse$swt$widgets$Button == null ? (class$org$eclipse$swt$widgets$Button = InboundPlugsTableModel.class$("org.eclipse.swt.widgets.Button")) : class$org$eclipse$swt$widgets$Button};
    private static final int[] COLUMN_WIDTHS = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, 16};
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_EVENTHANDLER = 1;
    public static final int COLUMN_STARTUP = 2;
    private AbstractView mView = null;
    private InboundPlug[] mInboundPlugs = null;
    RefactoringObserver mRefactoringObserver = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$eclipse$swt$widgets$Button;

    public InboundPlugsTableModel(Controller controller, AbstractView view) {
        super(controller);
        if (controller.getType().equals(ControllerTypeEnum.INTERFACE_VIEW)) {
            if (controller.getParent() instanceof ComponentInterfaceDefinition) {
                this.setNumberOfColumns(1);
            } else {
                this.setNumberOfColumns(3);
            }
        } else {
            this.setNumberOfColumns(2);
        }
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.mView = view;
        this.updateDataTable();
        this.getController().attachChildrenObserver((DevelopmentObjectObserver)this);
        if (this.mView instanceof MainDevelopmentObject) {
            ((MainDevelopmentObject)this.mView).attachChildrenObserver((DevelopmentObjectObserver)this);
        } else {
            Plugin.internalError(this.getClass(), "InboundPlugsTableModel(Controller, AbstractView", "mView is no MDO", new Exception(), false);
        }
        this.mRefactoringObserver = new RefactoringObserver();
        this.getController().attachChildrenObserver((DevelopmentObjectObserver)this.mRefactoringObserver);
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 | index > this.mInboundPlugs.length) {
            return null;
        }
        return this.mInboundPlugs[index];
    }

    protected void masterObjectChanged(DevelopmentObject newMasterObject) {
        super.masterObjectChanged(newMasterObject);
    }

    protected void updateDataTable() {
        if (this.mView != null) {
            this.mInboundPlugs = this.mView.getInboundPlugs();
            Arrays.sort(this.mInboundPlugs, new DevelopmentObjectNameComparator());
        }
    }

    public int getRowCount() {
        if (this.mInboundPlugs == null) {
            return 0;
        }
        return this.mInboundPlugs.length;
    }

    public int[] getColumnWidths() {
        return COLUMN_WIDTHS;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mInboundPlugs == null || this.mInboundPlugs.length <= rowIndex) {
            return AbstractControllerTableModel.ERROR;
        }
        InboundPlug plug = this.mInboundPlugs[rowIndex];
        if (plug == null) {
            return AbstractControllerTableModel.ERROR;
        }
        switch (columnIndex) {
            case 0: {
                return plug.getName();
            }
            case 1: {
                if (plug.getEventHandler() == null) {
                    return "";
                }
                return plug.getEventHandler().getName();
            }
            case 2: {
                return new Boolean(plug.getType().equals(InboundPlugTypeEnum.STARTUP));
            }
        }
        return AbstractControllerTableModel.ERROR;
    }

    protected void doCopy(MetamodelClipboard clipboard, int[] indexes) {
        InboundPlug[] plugs = this.getIndexesPlugs(indexes);
        clipboard.copy((DevelopmentObject[])plugs);
    }

    protected void doPaste(MetamodelClipboard clipboard) {
        MMRepositoryObject[] repositoryObjects = PlugService.getRepositoryObjectsAffectedByInboundPlugCreation((AbstractView)this.mView);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        ControllerPasteManager controllerPasteManager = new ControllerPasteManager();
        controllerPasteManager.paste(clipboard, (MetamodelObject)this.mView);
    }

    protected boolean canPaste(MetamodelClipboard clipboard) {
        DevelopmentObjectEnum[] objects = clipboard.getContentTypes();
        int i = 0;
        while (i < objects.length) {
            if (!objects[i].equals(WebDynproDevelopmentObjectEnum.INBOUNDPLUG)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void doRename(int[] indexes) {
        InboundPlug[] plugs = this.getIndexesPlugs(indexes);
        int i = 0;
        while (i < plugs.length) {
            InboundPlug plug = plugs[i];
            MMRepositoryObject[] repositoryObjects = PlugService.getRepositoryObjectsAffectedByInboundPlugModification((InboundPlug)plug);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            RenameInboundPlugWizard renameWizard = new RenameInboundPlugWizard((DevelopmentObject)plug);
            RenameWizardDialog wizardDialog = new RenameWizardDialog((RenameWizard)renameWizard);
            wizardDialog.open();
            wizardDialog.close();
            ++i;
        }
    }

    protected void doDelete(int[] indexes) {
        InboundPlug[] plugs = this.getIndexesPlugs(indexes);
        boolean userSaidDeleteAll = false;
        int result = -1;
        boolean deleteEventHandler = false;
        int i = 0;
        while (i < plugs.length) {
            InboundPlug inboundPlug = plugs[i];
            MMRepositoryObject[] repositoryObjects = PlugService.getRepositoryObjectsAffectedByInboundPlugDeletion((InboundPlug)inboundPlug);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            if (!userSaidDeleteAll) {
                String[] buttons = new String[]{mCoreTextPool.getText(150), mCoreTextPool.getText(164), mCoreTextPool.getText(151)};
                String[] questions = new String[]{};
                boolean[] questionsDefaultValues = new boolean[]{};
                if (!this.getController().getType().equals(ControllerTypeEnum.INTERFACE_VIEW)) {
                    questions = new String[]{AbstractControllerTableModel.mTextPool.getText(170)};
                    questionsDefaultValues = new boolean[]{true};
                } else {
                    questions = new String[]{};
                }
                MessageDialogWithCheckBoxes dialog = new MessageDialogWithCheckBoxes(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), mCoreTextPool.getText(400, (Object)AbstractControllerTableModel.mTextPool.getText(16)), null, mCoreTextPool.getText(401, (Object)AbstractControllerTableModel.mTextPool.getText(16), (Object)inboundPlug.getName()), 3, buttons, 2, questions, questionsDefaultValues);
                result = dialog.open();
                dialog.close();
                if (result == 1) {
                    userSaidDeleteAll = true;
                    result = 0;
                }
                deleteEventHandler = !this.getController().getType().equals(ControllerTypeEnum.INTERFACE_VIEW) ? dialog.getAnswers()[0] : true;
            }
            if (result == 0) {
                ServicesDeletion.deleteInboundPlug((InboundPlug)inboundPlug, (boolean)false, (boolean)deleteEventHandler);
            }
            ++i;
        }
    }

    protected void doEdit(int[] indexes) {
        InboundPlug[] plugs = this.getIndexesPlugs(indexes);
        int i = 0;
        while (i < plugs.length) {
            InboundPlug inboundPlug = plugs[i];
            MMRepositoryObject[] repositoryObjects = PlugService.getRepositoryObjectsAffectedByInboundPlugModification((InboundPlug)inboundPlug);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            InboundPlugEditDialog dialog = new InboundPlugEditDialog(inboundPlug, 1, this.getController());
            if (dialog.open() == 0) {
                PlugService.editInboundPlug((InboundPlug)inboundPlug, (String)dialog.getNewEventHandlerName(), (boolean)dialog.getNewStartup());
            }
            ++i;
        }
    }

    protected void doNew() {
        MMRepositoryObject[] repositoryObjects = PlugService.getRepositoryObjectsAffectedByInboundPlugCreation((AbstractView)this.mView);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        CreateInboundPlugWizardDialog dialog = new CreateInboundPlugWizardDialog(this.getController(), this.mView);
        dialog.open();
        dialog.close();
    }

    public void tableModelDisposed() {
        super.tableModelDisposed();
        ((MainDevelopmentObject)this.mView).detachChildrenObserver((DevelopmentObjectObserver)this);
        this.getController().detachChildrenObserver((DevelopmentObjectObserver)this);
        this.getController().detachChildrenObserver((DevelopmentObjectObserver)this.mRefactoringObserver);
    }

    protected boolean isReadOnly() {
        return this.getController().originatesInArchive() || this.mView.originatesInArchive();
    }

    public boolean isCutable(int[] indexes) {
        return false;
    }

    public boolean isPasteable(int[] indexes) {
        MetamodelClipboard clipboard = Metamodel.getClipboard();
        return !this.isReadOnly() && clipboard.isPasteAllowed((MetamodelObject)this.mView) && this.canPaste(clipboard);
    }

    protected boolean isEventRelevant(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof InboundPlug || event.getModifiedObject() instanceof EventHandler) {
            switch (event.getEventId()) {
                case 1: 
                case 2: 
                case 4: 
                case 64: 
                case 128: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private InboundPlug[] getIndexesPlugs(int[] indexes) {
        InboundPlug[] plugs = new InboundPlug[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            plugs[i] = this.mInboundPlugs[indexes[i]];
            ++i;
        }
        return plugs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RefactoringObserver
    implements DevelopmentObjectObserver {
        private RefactoringObserver() {
        }

        public void update(MetamodelEvent event) {
            MetamodelEvent[] events = new MetamodelEvent[]{event};
            this.update(events);
        }

        public void update(MetamodelEvent[] events) {
            int i = 0;
            while (i < events.length) {
                if (events[i] instanceof ReferencedObjectRefactoredEvent) {
                    InboundPlugsTableModel.this.fireTableDataChanged();
                    break;
                }
                ++i;
            }
        }
    }
}

