/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.plugs;

import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.webdynpro.controllereditor.EditUI;
import com.sap.ide.webdynpro.controllereditor.IDialogWithButtonAccess;
import com.sap.ide.webdynpro.controllereditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.controllereditor.eventhandlers.EventHandlerSubObjectEditUI;
import com.sap.ide.webdynpro.controllereditor.wizards.plug.CreateInboundPlugWizardData;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.plug.PlugService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

public class InboundPlugEditUI
extends EditUI {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    private IDialogWithButtonAccess mDialog = null;
    private AbstractView mView = null;
    private Controller mController = null;
    private CreateInboundPlugWizardData mData = null;
    private int mMode;
    private Text mNameField = null;
    private Text mEventHandlerNameField = null;
    private Button mStartupField = null;
    private EventHandlerSubObjectEditUI mSubUI = null;

    public InboundPlugEditUI(CreateInboundPlugWizardData data, int mode, AbstractView view, Controller controller, IDisplayErrorListener displayErrorListener, IDialogWithButtonAccess dialog) {
        super(displayErrorListener);
        this.mData = data;
        this.mMode = mode;
        this.mView = view;
        this.mController = controller;
        this.mDialog = dialog;
    }

    public void initUI(IGridLayoutPane glp) {
        glp.addTextLabel(mTextPool.getText(125));
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, false);
        this.mNameField = glp.addTextField(this.mData.getName(), this.mMode == 1, gd);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        this.mNameField.setFocus();
        if (this.mView.getViewController().getType().equals(ControllerTypeEnum.INTERFACE_VIEW)) {
            if (!(this.mController.getParent() instanceof ComponentInterfaceDefinition)) {
                glp.addTextLabel(mTextPool.getText(159));
                gd = glp.createGridLayoutData(4, 4, true, false);
                this.mStartupField = glp.addCheckBox("", this.mData.getStartup(), gd);
                this.mStartupField.addSelectionListener((SelectionListener)new StartupFieldSelectionListener());
            } else {
                this.mData.setStartup(false);
            }
        }
        if (!(this.mController.getParent() instanceof ComponentInterfaceDefinition)) {
            this.mSubUI = new EventHandlerSubObjectEditUI(this.mController, this.mData, this.mMode, this.getDisplayErrorListener(), this.mDialog);
            this.mSubUI.initUI(glp, 2);
        } else {
            this.mData.setSelectionType(2);
        }
        this.getDisplayErrorListener().setErrorMessage("");
    }

    private boolean validatePage() {
        String error = null;
        if (this.mMode != 1) {
            error = PlugService.isNewInboundPlugNameValid((String)this.mNameField.getText(), (AbstractView)this.mView, (Controller)this.mView.getViewController());
            this.getDisplayErrorListener().setErrorMessage(error);
            if (error != null) {
                return false;
            }
        }
        return true;
    }

    public void setVisible(boolean visible) {
        this.mNameField.setFocus();
    }

    private class StartupFieldSelectionListener
    implements SelectionListener {
        private StartupFieldSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            InboundPlugEditUI.this.mData.setStartup(InboundPlugEditUI.this.mStartupField.getSelection());
        }
    }

    private class NameModifyListener
    implements ModifyListener {
        private NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            InboundPlugEditUI.this.validatePage();
            InboundPlugEditUI.this.mData.setName(InboundPlugEditUI.this.mNameField.getText());
            if (InboundPlugEditUI.this.mSubUI != null) {
                String eventHandlerName = "onPlug" + InboundPlugEditUI.this.mData.getName();
                InboundPlugEditUI.this.mSubUI.setDefaultEventHandlerName(eventHandlerName);
            }
        }
    }
}

