/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.parameters;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.event.ObjectDeletedEvent;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.base.ParameterizedFeature;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableModel;
import com.sap.ide.webdynpro.controllereditor.parameters.ParameterEditDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.RenameParameterWizard;
import com.sap.ide.webdynpro.service.controllereditor.ControllerPasteManager;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterService;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardDialog;

public abstract class ParametersTableModel
extends AbstractControllerTableModel {
    private static final int NUMBER_OF_COLUMNS = 2;
    private static final String[] COLUMN_NAMES = new String[]{AbstractControllerTableModel.mTextPool.getText(62), AbstractControllerTableModel.mTextPool.getText(63)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ParametersTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ParametersTableModel.class$("java.lang.String")) : class$java$lang$String};
    protected static final int COLUMN_NAME = 0;
    protected static final int COLUMN_TYPE = 1;
    protected Parameter[] mParameters = null;
    protected ParameterizedFeature mSelectedParent = null;
    static /* synthetic */ Class class$java$lang$String;

    public ParametersTableModel(Controller controller) {
        super(controller);
        this.setNumberOfColumns(2);
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.updateDataTable();
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 || index >= this.mParameters.length) {
            return null;
        }
        return this.mParameters[index];
    }

    protected void masterObjectChanged(DevelopmentObject newMasterObject) {
        if (newMasterObject instanceof ParameterizedFeature) {
            this.mSelectedParent = (ParameterizedFeature)newMasterObject;
            this.mSelectionIndexes = new int[0];
        } else {
            this.mSelectedParent = null;
            this.mSelectionIndexes = new int[0];
        }
        super.masterObjectChanged(newMasterObject);
    }

    protected void updateDataTable() {
        if (this.mSelectedParent == null || !this.mSelectedParent.isValid()) {
            this.mParameters = new Parameter[0];
        } else {
            this.mSelectionIndexes = new int[0];
            ParameterizedFeature parameterizedFeature = this.mSelectedParent;
            if (parameterizedFeature == null) {
                this.mParameters = new Parameter[0];
            } else {
                if (!parameterizedFeature.isValid()) {
                    this.mParameters = new Parameter[0];
                }
                this.mParameters = parameterizedFeature.getParameters();
            }
        }
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        if (this.mParameters == null) {
            return 0;
        }
        return this.mParameters.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mParameters == null) {
            return AbstractControllerTableModel.ERROR;
        }
        if (rowIndex >= this.mParameters.length) {
            return AbstractControllerTableModel.ERROR;
        }
        Parameter parameter = this.mParameters[rowIndex];
        if (parameter == null) {
            return AbstractControllerTableModel.ERROR;
        }
        switch (columnIndex) {
            case 0: {
                return parameter.getName();
            }
            case 1: {
                if (parameter.getType() != null) {
                    MetamodelServices.CompoundType type = new MetamodelServices.CompoundType(parameter.getType());
                    if (type.isJavaNativeType()) {
                        return this.addDimensionString(type.getQualifiedName(), type.getJavaNativeType().getArrayDimensions());
                    }
                    return type.getName();
                }
                return AbstractControllerTableModel.ERROR;
            }
        }
        return AbstractControllerTableModel.ERROR;
    }

    protected void doEdit(int[] indexes) {
        Parameter[] parameters = this.getIndexesParameters(indexes);
        int i = 0;
        while (i < indexes.length) {
            Parameter parameter = parameters[i];
            MMRepositoryObject[] repositoryObjects = ParameterService.getRepositoryObjectsAffectedByParameterModification((Parameter)parameter);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            ParameterEditDialog dialog = new ParameterEditDialog(parameter, this.getController(), 1, null, true);
            if (dialog.open() == 0) {
                ParameterService.editParameter((Parameter)parameter, (DevelopmentObject)dialog.getNewParameterType(), (MetamodelServices.CompoundType)dialog.getNewParameterTypeAsCompoundType(), (int)dialog.getNewParameterTypeArrayDimension());
            }
            ++i;
        }
    }

    protected void doCopy(MetamodelClipboard clipboard, int[] indexes) {
        Parameter[] parameters = this.getIndexesParameters(indexes);
        clipboard.copy((DevelopmentObject[])parameters);
    }

    protected void doPaste(MetamodelClipboard clipboard) {
        MMRepositoryObject[] repositoryObjects = ParameterService.getRepositoryObjectsAffectedByParameterCreation((ParameterizedFeature)this.mSelectedParent);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        ControllerPasteManager controllerPasteManager = new ControllerPasteManager();
        controllerPasteManager.paste(clipboard, (MetamodelObject)this.mSelectedParent);
    }

    protected boolean canPaste(MetamodelClipboard clipboard) {
        DevelopmentObjectEnum[] objects = clipboard.getContentTypes();
        int i = 0;
        while (i < objects.length) {
            if (!objects[i].equals(WebDynproDevelopmentObjectEnum.PARAMETER)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void doRename(int[] indexes) {
        Parameter[] parameters = this.getIndexesParameters(indexes);
        int i = 0;
        while (i < indexes.length) {
            Parameter parameter = parameters[i];
            MMRepositoryObject[] repositoryObjects = ParameterService.getRepositoryObjectsAffectedByParameterModification((Parameter)parameter);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            RenameParameterWizard renameWizard = new RenameParameterWizard((DevelopmentObject)parameter);
            RenameWizardDialog wizardDialog = new RenameWizardDialog((RenameWizard)renameWizard);
            wizardDialog.open();
            wizardDialog.close();
            ++i;
        }
    }

    protected void doDelete(int[] indexes) {
        Parameter[] parameters = this.getIndexesParameters(indexes);
        boolean userSaidDeleteAll = false;
        int result = -1;
        int i = 0;
        while (i < indexes.length) {
            Parameter parameter = parameters[i];
            MMRepositoryObject[] repositoryObjects = ParameterService.getRepositoryObjectsAffectedByParameterDeletion((Parameter)parameter);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            if (!userSaidDeleteAll && (result = UIHelper.askUserToDeleteAll((String)parameter.getName(), (String)AbstractControllerTableModel.mTextPool.getText(19))) == 1) {
                userSaidDeleteAll = true;
                result = 0;
            }
            if (result == 0) {
                ParameterService.deleteParameter((Parameter)parameter);
            }
            ++i;
        }
    }

    protected boolean isEventRelevant(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof Parameter || this.isModifiedParentObjectRelevant(event.getModifiedObject())) {
            switch (event.getEventId()) {
                case 1: {
                    return true;
                }
                case 2: {
                    ObjectDeletedEvent objectDeletedEvent = (ObjectDeletedEvent)event;
                    return this.isModifiedParentObjectRelevant(objectDeletedEvent.getParent());
                }
                case 4: {
                    return true;
                }
                case 128: {
                    return true;
                }
                case 32: {
                    return true;
                }
                case 64: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected abstract boolean isModifiedParentObjectRelevant(DevelopmentObject var1);

    public void doUp(int index) {
        Parameter parameter = this.mParameters[index];
        MMRepositoryObject[] repositoryObjects = ParameterService.getRepositoryObjectsAffectedByParameterModification((Parameter)parameter);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        ParameterizedFeature parent = (ParameterizedFeature)parameter.getParent();
        parent.moveParameter(index, index - 1);
    }

    public void doDown(int index) {
        Parameter parameter = this.mParameters[index];
        MMRepositoryObject[] repositoryObjects = ParameterService.getRepositoryObjectsAffectedByParameterModification((Parameter)parameter);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        ParameterizedFeature parent = (ParameterizedFeature)parameter.getParent();
        parent.moveParameter(index, index + 1);
    }

    public boolean isPasteable() {
        MetamodelClipboard clipboard = Metamodel.getClipboard();
        return !this.isReadOnly() && clipboard.isPasteAllowed((MetamodelObject)this.mSelectedParent) && this.canPaste(clipboard);
    }

    protected Parameter[] getIndexesParameters(int[] indexes) {
        Parameter[] parameters = new Parameter[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            parameters[i] = this.mParameters[indexes[i]];
            ++i;
        }
        return parameters;
    }

    protected String addDimensionString(String typeName, int dimension) {
        String result = typeName;
        int i = 0;
        while (i < dimension) {
            result = result + "[]";
            ++i;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

