/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.parameters;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.plugin.DictionaryRootManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.ParameterizedFeature;
import com.sap.ide.webdynpro.controllereditor.EditUI;
import com.sap.ide.webdynpro.controllereditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.controllereditor.wizards.parameter.CreateParameterWizardData;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterPlaceholder;
import com.sap.ide.webdynpro.service.controllereditor.parameter.ParameterService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class ParameterEditUI
extends EditUI {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    private ParameterizedFeature mObject = null;
    private DevelopmentObject mParent = null;
    private CreateParameterWizardData mData = null;
    private int mMode;
    private String mAdaptSubObjectText = null;
    private ParameterPlaceholder[] mAdditionalParameters = null;
    private boolean mSupportsArrays = false;
    private Text mNameField = null;
    private Combo mTypeField = null;
    private Button mTypeButton = null;
    private Button mArrayButton = null;
    private Text mArrayDimensionField = null;
    private Button mAlsoSubObject = null;

    public ParameterEditUI(CreateParameterWizardData data, int mode, ParameterizedFeature object, DevelopmentObject parent, String adaptSubObjectText, IDisplayErrorListener displayErrorListener, ParameterPlaceholder[] additionalParameters, boolean supportsArrays) {
        super(displayErrorListener);
        this.mData = data;
        this.mMode = mode;
        this.mObject = object;
        this.mParent = parent;
        this.mAdaptSubObjectText = adaptSubObjectText;
        this.mAdditionalParameters = additionalParameters;
        this.mSupportsArrays = supportsArrays;
    }

    public void initUI(IGridLayoutPane glp) {
        glp.addTextLabel(mTextPool.getText(58));
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, false);
        this.mNameField = glp.addTextField(this.mData.getName(), this.mMode == 1, gd);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        this.mNameField.setFocus();
        gd = glp.createGridLayoutData(4, 4, false, false);
        glp.addPlaceholder(gd);
        glp.addTextLabel(mTextPool.getText(59));
        gd = glp.createGridLayoutData(4, 4, true, false);
        String[] items = this.mData.getTypeNames();
        String defaultItem = this.mData.getSelectedTypeName();
        this.mTypeField = glp.addComboBox(items, defaultItem, true, gd);
        TypeModifyListener modifyListener = new TypeModifyListener();
        this.mTypeField.addModifyListener((ModifyListener)modifyListener);
        gd = glp.createGridLayoutData(4, 4, false, false);
        this.mTypeButton = glp.addPushButton("...", gd);
        this.mTypeButton.addSelectionListener((SelectionListener)new TypeSelectionButtonListener(modifyListener));
        if (this.mSupportsArrays) {
            gd = glp.createGridLayoutData(4, 4, true, false, 2, 1);
            this.mArrayButton = glp.addCheckBox(mTextPool.getText(581), this.mData.isArray(), gd);
            if (!this.isArrayPossible()) {
                this.mArrayButton.setEnabled(false);
                this.mArrayButton.setSelection(false);
                this.mData.setArray(false);
            }
            this.mArrayButton.addSelectionListener((SelectionListener)new ArrayButtonSelectionListener());
            glp.addPlaceholder();
            glp.addTextLabel(mTextPool.getText(582));
            gd = glp.createGridLayoutData(1, 4, false, false);
            this.mArrayDimensionField = glp.addTextField(this.mData.getArrayDimensionString(), gd);
            if (!this.mData.isArray()) {
                this.mArrayDimensionField.setEnabled(false);
            }
            this.mArrayDimensionField.addModifyListener((ModifyListener)new ArrayDimensionModifyListener());
        }
        if (this.mAdaptSubObjectText != null) {
            gd = glp.createGridLayoutData(4, 4, true, false, 2, 1);
            this.mAlsoSubObject = glp.addCheckBox(this.mAdaptSubObjectText, false, gd);
            this.mAlsoSubObject.setSelection(this.mData.isAdaptSubObject());
            this.mAlsoSubObject.addSelectionListener((SelectionListener)new AdaptSubObjectButtonSelectionListener());
            gd = glp.createGridLayoutData(4, 4, false, false);
            glp.addPlaceholder(gd);
        }
        this.getDisplayErrorListener().setErrorMessage("");
    }

    private boolean validatePage() {
        String error = null;
        if (this.mMode != 1) {
            error = ParameterService.isNewParameterNameValid((String)this.mNameField.getText(), (ParameterizedFeature)this.mObject, (ParameterPlaceholder[])this.mAdditionalParameters);
            this.getDisplayErrorListener().setErrorMessage(error);
            if (error != null) {
                return false;
            }
        }
        error = ParameterService.isNewTypeNameValid((String)this.mTypeField.getText());
        this.getDisplayErrorListener().setErrorMessage(error);
        return error == null;
    }

    public void setVisible(boolean visible) {
        this.mNameField.setFocus();
    }

    private boolean isArrayPossible() {
        boolean isJavaType = false;
        if (this.mData.getSelectedTypeAsCompoundType() != null && this.mData.getSelectedTypeAsCompoundType().isJavaNativeType()) {
            isJavaType = true;
        }
        return isJavaType;
    }

    private class ArrayDimensionModifyListener
    implements ModifyListener {
        private ArrayDimensionModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ParameterEditUI.this.mData.isArray()) {
                int value = -1;
                try {
                    value = Integer.parseInt(ParameterEditUI.this.mArrayDimensionField.getText());
                }
                catch (NumberFormatException e1) {
                    ParameterEditUI.super.getDisplayErrorListener().setErrorMessage(mTextPool.getText(1045));
                    return;
                }
                if (value < 1) {
                    ParameterEditUI.super.getDisplayErrorListener().setErrorMessage(mTextPool.getText(1045));
                    return;
                }
                ParameterEditUI.this.mData.setArrayDimension(value);
            }
            ParameterEditUI.this.validatePage();
        }
    }

    private class ArrayButtonSelectionListener
    implements SelectionListener {
        private ArrayButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            boolean isArray = ParameterEditUI.this.mArrayButton.getSelection();
            ParameterEditUI.this.mData.setArray(isArray);
            ParameterEditUI.this.mArrayDimensionField.setEditable(isArray);
            ParameterEditUI.this.mArrayDimensionField.setEnabled(true);
            ParameterEditUI.this.mArrayDimensionField.setText(ParameterEditUI.this.mData.getArrayDimensionString());
        }
    }

    private class AdaptSubObjectButtonSelectionListener
    implements SelectionListener {
        private AdaptSubObjectButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Button) {
                Button button = (Button)e.widget;
                ParameterEditUI.this.mData.setAdaptSubObject(button.getSelection());
            }
        }
    }

    private class TypeSelectionButtonListener
    implements SelectionListener {
        private ModifyListener mModifyListener = null;

        public TypeSelectionButtonListener(ModifyListener modifyListener) {
            this.mModifyListener = modifyListener;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            DtDictionaryRoot ddicRoot = DictionaryRootManager.getDictionaryRoot((Metamodel)ParameterEditUI.this.mParent.getRoot().getMetamodel());
            MetamodelServices.CompoundType type = UIHelper.selectType((DtDictionaryRoot)ddicRoot, (DevelopmentObject)ParameterEditUI.this.mData.getSelectedType());
            if (type != null) {
                ParameterEditUI.this.mData.setSelectedType(type);
                ParameterEditUI.this.mTypeField.setItems(ParameterEditUI.this.mData.getTypeNames());
                ParameterEditUI.this.mTypeField.removeModifyListener(this.mModifyListener);
                ParameterEditUI.this.mTypeField.select(ParameterEditUI.this.mData.getSelectedTypeIndex());
                ParameterEditUI.this.mTypeField.addModifyListener(this.mModifyListener);
                if (ParameterEditUI.this.mArrayButton != null) {
                    if (!ParameterEditUI.this.isArrayPossible()) {
                        ParameterEditUI.this.mData.setArray(false);
                        ParameterEditUI.this.mArrayButton.setSelection(false);
                        ParameterEditUI.this.mArrayButton.setEnabled(false);
                        ParameterEditUI.this.mArrayDimensionField.setText(ParameterEditUI.this.mData.getArrayDimensionString());
                        ParameterEditUI.this.mArrayDimensionField.setEditable(false);
                    } else {
                        ParameterEditUI.this.mArrayButton.setEnabled(true);
                        ParameterEditUI.this.mArrayDimensionField.setText(ParameterEditUI.this.mData.getArrayDimensionString());
                        ParameterEditUI.this.mArrayDimensionField.setEditable(true);
                    }
                }
            }
        }
    }

    private class TypeModifyListener
    implements ModifyListener {
        private TypeModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ParameterEditUI.this.validatePage();
            ParameterEditUI.this.mData.setSelectedTypeIndex(ParameterEditUI.this.mTypeField.getSelectionIndex());
            ParameterEditUI.this.mTypeField.removeModifyListener((ModifyListener)this);
            ParameterEditUI.this.mTypeField.setItems(ParameterEditUI.this.mData.getTypeNames());
            ParameterEditUI.this.mTypeField.select(ParameterEditUI.this.mData.getSelectedTypeIndex());
            ParameterEditUI.this.mTypeField.addModifyListener((ModifyListener)this);
            if (!ParameterEditUI.this.isArrayPossible()) {
                ParameterEditUI.this.mData.setArray(false);
                if (ParameterEditUI.this.mArrayButton != null) {
                    ParameterEditUI.this.mArrayButton.setSelection(false);
                    ParameterEditUI.this.mArrayButton.setEnabled(false);
                }
                if (ParameterEditUI.this.mArrayDimensionField != null) {
                    ParameterEditUI.this.mArrayDimensionField.setText(ParameterEditUI.this.mData.getArrayDimensionString());
                    ParameterEditUI.this.mArrayDimensionField.setEditable(false);
                }
            } else if (ParameterEditUI.this.mArrayButton != null && ParameterEditUI.this.mArrayDimensionField != null) {
                ParameterEditUI.this.mArrayButton.setEnabled(true);
                ParameterEditUI.this.mArrayDimensionField.setText(ParameterEditUI.this.mData.getArrayDimensionString());
                ParameterEditUI.this.mArrayDimensionField.setEditable(true);
            }
        }
    }

    private class NameModifyListener
    implements ModifyListener {
        private NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ParameterEditUI.this.validatePage();
            ParameterEditUI.this.mData.setName(ParameterEditUI.this.mNameField.getText());
        }
    }
}

