/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.overview;

import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.metamodel.webdynpro.enum.ViewLifespanEnum;
import com.sap.ide.webdynpro.controllereditor.overview.ViewPropertiesSection;

public class ViewPropertiesSectionData
implements DevelopmentObjectObserver {
    private AbstractView mView = null;
    private ViewPropertiesSection mSection = null;
    private int mSelectedLifespan = -1;
    private ViewLifespanEnum[] mLifespans = null;

    public ViewPropertiesSectionData(AbstractView view, ViewPropertiesSection section) {
        this.mView = view;
        this.mSection = section;
        this.mView.attachObserver((DevelopmentObjectObserver)this);
        this.initializeLifespan();
    }

    public void dispose() {
        this.mView.detachObserver((DevelopmentObjectObserver)this);
    }

    private void initializeLifespan() {
        this.mLifespans = new ViewLifespanEnum[ViewLifespanEnum.getValues().size()];
        this.mLifespans = ViewLifespanEnum.getValues().toArray(this.mLifespans);
        this.updateLifespan();
    }

    private void updateLifespan() {
        if (this.mView.getLifespan() != null) {
            int i = 0;
            while (i < this.mLifespans.length) {
                if (this.mView.getLifespan().equals(this.mLifespans[i])) {
                    this.mSelectedLifespan = i;
                    this.mSection.update();
                    break;
                }
                ++i;
            }
        } else {
            this.mSelectedLifespan = -1;
        }
    }

    public String getSelectedLifespanText() {
        if (this.mSelectedLifespan == -1) {
            return "";
        }
        return this.mLifespans[this.mSelectedLifespan].getDescriptiveText();
    }

    public int getSelectedLifespanIndex() {
        return this.mSelectedLifespan;
    }

    public ViewLifespanEnum getSelectedLifespan() {
        if (this.mSelectedLifespan == -1) {
            return null;
        }
        return this.mLifespans[this.mSelectedLifespan];
    }

    public String[] getLifespanTexts() {
        String[] names = new String[this.mLifespans.length];
        int i = 0;
        while (i < names.length) {
            names[i] = this.mLifespans[i].getDescriptiveText();
            ++i;
        }
        return names;
    }

    public void setSelectedLifespan(int index) {
        this.mSelectedLifespan = index;
    }

    public void update(MetamodelEvent arg0) {
        if (this.mView == null || !this.mView.isValid()) {
            return;
        }
        this.updateLifespan();
        this.mSection.update();
    }

    public void update(MetamodelEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.update(events[i]);
            ++i;
        }
    }

    public boolean isReadOnly() {
        return this.mView.isReadOnly();
    }
}

