/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.overview;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.webdynpro.controllereditor.overview.ViewPropertiesSectionData;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.controller.ControllerService;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import com.tssap.util.ui.glpc.section.AbstractSection;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;

public class ViewPropertiesSection
extends AbstractSection
implements DisposeListener {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String[] EMPTY_STRING_ARRAY = new String[]{""};
    private AbstractView mView = null;
    private ViewPropertiesSectionData mData = null;
    private Combo mLifespanField = null;

    public ViewPropertiesSection(AbstractView view) {
        super(ServiceCorePlugin.WIDGET_FACTORY, 2, mTextPool.getText(49), mTextPool.getText(50));
        this.mView = view;
        this.mData = new ViewPropertiesSectionData(this.mView, this);
    }

    public void initSection(IGridLayoutPane glp) {
        glp.addTextLabel(mTextPool.getText(161));
        IGridLayoutData gd = glp.createGridLayoutData(4, 1, true, false);
        this.mLifespanField = glp.addComboBox(this.mData.getLifespanTexts(), this.mData.getSelectedLifespanText(), true, gd);
        this.mLifespanField.addSelectionListener((SelectionListener)new LifespanSelectionListener());
        this.getUserAreaGridLayoutPane().addDisposeListener((DisposeListener)this);
    }

    public void update() {
        if (this.mLifespanField != null) {
            this.mLifespanField.select(this.mData.getSelectedLifespanIndex());
            this.mLifespanField.setEnabled(!this.mData.isReadOnly());
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.mData.dispose();
    }

    private class LifespanSelectionListener
    implements SelectionListener {
        private LifespanSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int index = ViewPropertiesSection.this.mLifespanField.getSelectionIndex();
            if (index != ViewPropertiesSection.this.mData.getSelectedLifespanIndex()) {
                MMRepositoryObject[] repositoryObjects = ControllerService.getRepositoryObjectsAffectedByViewControllerModification((Controller)ViewPropertiesSection.this.mView.getViewController());
                if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                    ViewPropertiesSection.this.mLifespanField.select(ViewPropertiesSection.this.mData.getSelectedLifespanIndex());
                    return;
                }
                ViewPropertiesSection.this.mData.setSelectedLifespan(index);
                ViewPropertiesSection.this.mView.setLifespan(ViewPropertiesSection.this.mData.getSelectedLifespan());
            }
        }
    }
}

