/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.overview;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.event.ObjectDeletedEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectAddedEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectRemovedEvent;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableModel;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.usage.ModelUsageService;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectNameComparator;
import com.sap.ide.webdynpro.service.core.UIHelper;
import java.util.Arrays;

public class UsedModelsTableModel
extends AbstractControllerTableModel {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final int NUMBER_OF_COLUMNS = 1;
    private static final String[] COLUMN_NAMES = new String[]{mTextPool.getText(540)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = UsedModelsTableModel.class$("java.lang.String")) : class$java$lang$String};
    private static final int COLUMN_NAME = 0;
    private Component mComponent = null;
    private ComponentInterfaceDefinition mComponentInterfaceDefinition = null;
    private Model[] mUsedModels = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$model$Model;

    public UsedModelsTableModel(Controller controller, Component component) {
        super(controller);
        this.mComponent = component;
        this.initialize();
        this.mComponent.attachObserver((DevelopmentObjectObserver)this);
        this.mComponent.getRoot().attachClassObserver(class$com$sap$ide$metamodel$webdynpro$model$Model == null ? (class$com$sap$ide$metamodel$webdynpro$model$Model = UsedModelsTableModel.class$("com.sap.ide.metamodel.webdynpro.model.Model")) : class$com$sap$ide$metamodel$webdynpro$model$Model, (DevelopmentObjectObserver)this);
    }

    public UsedModelsTableModel(Controller controller, ComponentInterfaceDefinition componentInterfaceDefinition) {
        super(controller);
        this.mComponentInterfaceDefinition = componentInterfaceDefinition;
        this.initialize();
        this.mComponentInterfaceDefinition.attachObserver((DevelopmentObjectObserver)this);
        this.mComponentInterfaceDefinition.getRoot().attachClassObserver(class$com$sap$ide$metamodel$webdynpro$model$Model == null ? (class$com$sap$ide$metamodel$webdynpro$model$Model = UsedModelsTableModel.class$("com.sap.ide.metamodel.webdynpro.model.Model")) : class$com$sap$ide$metamodel$webdynpro$model$Model, (DevelopmentObjectObserver)this);
    }

    private void initialize() {
        this.setNumberOfColumns(1);
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.updateDataTable();
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 | index > this.mUsedModels.length) {
            return null;
        }
        return this.mUsedModels[index];
    }

    protected void masterObjectChanged(DevelopmentObject newMasterObject) {
        super.masterObjectChanged(newMasterObject);
    }

    protected void updateDataTable() {
        if (this.mComponent != null) {
            this.mUsedModels = this.mComponent.getUsedModels();
        } else if (this.mComponentInterfaceDefinition != null) {
            this.mUsedModels = this.mComponentInterfaceDefinition.getUsedModels();
        }
        Arrays.sort(this.mUsedModels, new DevelopmentObjectNameComparator());
    }

    public int getRowCount() {
        if (this.mUsedModels == null) {
            return 0;
        }
        return this.mUsedModels.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mUsedModels.length <= rowIndex) {
            return AbstractControllerTableModel.ERROR;
        }
        Model model = this.mUsedModels[rowIndex];
        if (model == null) {
            return AbstractControllerTableModel.ERROR;
        }
        switch (columnIndex) {
            case 0: {
                return model.getName() + " - " + model.getPackage();
            }
        }
        return AbstractControllerTableModel.ERROR;
    }

    protected void doCopy(MetamodelClipboard clipboard, int[] indexes) {
    }

    protected void doPaste(MetamodelClipboard clipboard) {
    }

    protected boolean canPaste(MetamodelClipboard clipboard) {
        return false;
    }

    protected void doRename(int[] indexes) {
    }

    protected void doDelete(int[] indexes) {
        Model[] usages = this.getIndexesUsages(indexes);
        boolean userSaidDeleteAll = false;
        int result = -1;
        int i = 0;
        while (i < usages.length) {
            MMRepositoryObject[] repositoryObjects = null;
            if (this.mComponent != null) {
                repositoryObjects = ModelUsageService.getRepositoryObjectsAffectedByModelUsageDeletion((Component)this.mComponent);
            } else if (this.mComponentInterfaceDefinition != null) {
                repositoryObjects = ModelUsageService.getRepositoryObjectsAffectedByModelUsageDeletion((ComponentInterfaceDefinition)this.mComponentInterfaceDefinition);
            } else {
                return;
            }
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            Model model = usages[i];
            if (!userSaidDeleteAll && (result = UIHelper.askUserToDeleteAll((String)model.getName(), (String)mTextPool.getText(906))) == 1) {
                userSaidDeleteAll = true;
                result = 0;
            }
            if (result == 0) {
                if (this.mComponent != null) {
                    ModelUsageService.deleteModelUsage((Component)this.mComponent, (Model)model);
                } else if (this.mComponentInterfaceDefinition != null) {
                    ModelUsageService.deleteModelUsage((ComponentInterfaceDefinition)this.mComponentInterfaceDefinition, (Model)model);
                }
            }
            ++i;
        }
    }

    protected void doEdit(int[] indexes) {
    }

    protected void doNew() {
        MMRepositoryObject[] repositoryObjects = null;
        if (this.mComponent != null) {
            repositoryObjects = ModelUsageService.getRepositoryObjectsAffectedByModelUsageCreation((Component)this.mComponent);
        } else if (this.mComponentInterfaceDefinition != null) {
            repositoryObjects = ModelUsageService.getRepositoryObjectsAffectedByModelUsageCreation((ComponentInterfaceDefinition)this.mComponentInterfaceDefinition);
        } else {
            return;
        }
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        if (this.mComponent != null) {
            ModelUsageService.createModelUsage((Component)this.mComponent, null, (Model[])this.mComponent.getUsedModels());
        } else if (this.mComponentInterfaceDefinition != null) {
            ModelUsageService.createModelUsage(null, (ComponentInterfaceDefinition)this.mComponentInterfaceDefinition, (Model[])this.mComponentInterfaceDefinition.getUsedModels());
        }
    }

    public boolean isCopyable(int[] indexes) {
        return false;
    }

    public boolean isEditable(int[] indexes) {
        return false;
    }

    public void tableModelDisposed() {
        super.tableModelDisposed();
        if (this.mComponent != null) {
            this.mComponent.detachObserver((DevelopmentObjectObserver)this);
            this.mComponent.getRoot().detachClassObserver(class$com$sap$ide$metamodel$webdynpro$model$Model == null ? (class$com$sap$ide$metamodel$webdynpro$model$Model = UsedModelsTableModel.class$("com.sap.ide.metamodel.webdynpro.model.Model")) : class$com$sap$ide$metamodel$webdynpro$model$Model, (DevelopmentObjectObserver)this);
        }
        if (this.mComponentInterfaceDefinition != null) {
            this.mComponentInterfaceDefinition.detachObserver((DevelopmentObjectObserver)this);
            this.mComponentInterfaceDefinition.getRoot().detachClassObserver(class$com$sap$ide$metamodel$webdynpro$model$Model == null ? (class$com$sap$ide$metamodel$webdynpro$model$Model = UsedModelsTableModel.class$("com.sap.ide.metamodel.webdynpro.model.Model")) : class$com$sap$ide$metamodel$webdynpro$model$Model, (DevelopmentObjectObserver)this);
        }
    }

    protected boolean isReadOnly() {
        if (this.mComponent != null) {
            return this.mComponent.originatesInArchive();
        }
        if (this.mComponentInterfaceDefinition != null) {
            return this.mComponentInterfaceDefinition.originatesInArchive();
        }
        return true;
    }

    protected boolean isEventRelevant(MetamodelEvent event) {
        switch (event.getEventId()) {
            case 256: {
                ReferencedObjectAddedEvent referencedObjectAddedEvent = (ReferencedObjectAddedEvent)event;
                return referencedObjectAddedEvent.getReferencedObject() instanceof Model;
            }
            case 512: {
                ReferencedObjectRemovedEvent referencedObjectRemovedEvent = (ReferencedObjectRemovedEvent)event;
                return referencedObjectRemovedEvent.getReferencedObject() instanceof Model;
            }
            case 2: {
                ObjectDeletedEvent objectDeletedEvent = (ObjectDeletedEvent)event;
                if (objectDeletedEvent.getModifiedObject() instanceof Model) {
                    Model model = (Model)objectDeletedEvent.getModifiedObject();
                    int i = 0;
                    while (i < this.mUsedModels.length) {
                        if (model.equals(this.mUsedModels[i])) {
                            this.mComponent.removeUsedModel(model);
                        }
                        ++i;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private Model[] getIndexesUsages(int[] indexes) {
        Model[] usages = new Model[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            usages[i] = this.mUsedModels[indexes[i]];
            ++i;
        }
        return usages;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

