/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.overview;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableModel;
import com.sap.ide.webdynpro.controllereditor.wizards.componentusage.CreateComponentUsageWizardDialog;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.usage.ComponentUsageService;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectNameComparator;
import com.sap.ide.webdynpro.service.core.UIHelper;
import java.util.Arrays;

public class UsedComponentsTableModel
extends AbstractControllerTableModel {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final int NUMBER_OF_COLUMNS = 2;
    private static final String[] COLUMN_NAMES = new String[]{mTextPool.getText(548), mTextPool.getText(544)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = UsedComponentsTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = UsedComponentsTableModel.class$("java.lang.String")) : class$java$lang$String};
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_USED_COMPONENT_NAME = 1;
    private Component mComponent = null;
    private ComponentUsage[] mComponentUsages = null;
    static /* synthetic */ Class class$java$lang$String;

    public UsedComponentsTableModel(Controller controller, Component component) {
        super(controller);
        this.mComponent = component;
        this.setNumberOfColumns(2);
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.updateDataTable();
        this.mComponent.attachObserver((DevelopmentObjectObserver)this);
        this.mComponent.attachChildrenObserver((DevelopmentObjectObserver)this);
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 | index > this.mComponentUsages.length) {
            return null;
        }
        return this.mComponentUsages[index];
    }

    protected void masterObjectChanged(DevelopmentObject newMasterObject) {
        super.masterObjectChanged(newMasterObject);
    }

    protected void updateDataTable() {
        if (this.mComponent != null) {
            this.mComponentUsages = this.mComponent.getComponentUsages();
            Arrays.sort(this.mComponentUsages, new DevelopmentObjectNameComparator());
        }
    }

    public int getRowCount() {
        if (this.mComponentUsages == null) {
            return 0;
        }
        return this.mComponentUsages.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mComponentUsages.length <= rowIndex) {
            return AbstractControllerTableModel.ERROR;
        }
        ComponentUsage componentUsage = this.mComponentUsages[rowIndex];
        if (componentUsage == null) {
            return AbstractControllerTableModel.ERROR;
        }
        switch (columnIndex) {
            case 1: {
                if (componentUsage.hasUsedComponent()) {
                    if (componentUsage.getUsedComponent() instanceof ComponentInterfaceImplementation) {
                        if (componentUsage.getUsedComponent().getParent() == null) {
                            return AbstractControllerTableModel.ERROR;
                        }
                        return componentUsage.getUsedComponent().getParent().getName() + " - " + ((MainDevelopmentObject)componentUsage.getUsedComponent().getParent()).getPackage();
                    }
                    if (componentUsage.getUsedComponent() instanceof ComponentInterfaceDefinition) {
                        return componentUsage.getUsedComponent().getName() + " - " + ((MainDevelopmentObject)componentUsage.getUsedComponent()).getPackage();
                    }
                    return AbstractControllerTableModel.ERROR;
                }
                return AbstractControllerTableModel.ERROR;
            }
            case 0: {
                return componentUsage.getName();
            }
        }
        return AbstractControllerTableModel.ERROR;
    }

    protected void doCopy(MetamodelClipboard clipboard, int[] indexes) {
    }

    protected void doRename(int[] indexes) {
    }

    protected void doDelete(int[] indexes) {
        ComponentUsage[] usages = this.getIndexesUsages(indexes);
        int i = 0;
        while (i < usages.length) {
            ComponentUsage componentUsage = usages[i];
            MMRepositoryObject[] repositoryObjects = ComponentUsageService.getRepositoryObjectsAffectedByComponentUsageDeletion((ComponentUsage)componentUsage);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            if (UIHelper.askUserToDelete((String)componentUsage.getName(), (String)mTextPool.getText(907))) {
                ComponentUsageService.deleteComponentUsage((ComponentUsage)componentUsage);
            }
            ++i;
        }
    }

    protected void doPaste(MetamodelClipboard clipboard) {
    }

    protected boolean canPaste(MetamodelClipboard clipboard) {
        return false;
    }

    protected void doEdit(int[] indexes) {
    }

    protected void doNew() {
        MMRepositoryObject[] repositoryObjects = ComponentUsageService.getRepositoryObjectsAffectedByComponentUsageCreation((Component)this.mComponent);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        CreateComponentUsageWizardDialog dialog = new CreateComponentUsageWizardDialog(this.mComponent);
        dialog.open();
        dialog.close();
    }

    public boolean isCopyable(int[] indexes) {
        return false;
    }

    public boolean isEditable(int[] indexes) {
        return false;
    }

    public void tableModelDisposed() {
        super.tableModelDisposed();
        this.mComponent.detachObserver((DevelopmentObjectObserver)this);
        this.mComponent.detachChildrenObserver((DevelopmentObjectObserver)this);
    }

    protected boolean isReadOnly() {
        return this.mComponent.originatesInArchive();
    }

    protected boolean isEventRelevant(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof ComponentUsage) {
            switch (event.getEventId()) {
                case 2: 
                case 128: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private ComponentUsage[] getIndexesUsages(int[] indexes) {
        ComponentUsage[] usages = new ComponentUsage[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            usages[i] = this.mComponentUsages[indexes[i]];
            ++i;
        }
        return usages;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

