/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.overview;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.event.ObjectDeletedEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectAddedEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectRemovedEvent;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableModel;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.usage.ImplementedComponentInterfaceDefinitionUsageService;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectNameComparator;
import com.sap.ide.webdynpro.service.core.UIHelper;
import java.util.Arrays;

public class ImplementedComponentInterfaceDefinitionsTableModel
extends AbstractControllerTableModel {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final int NUMBER_OF_COLUMNS = 1;
    private static final String[] COLUMN_NAMES = new String[]{mTextPool.getText(172)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ImplementedComponentInterfaceDefinitionsTableModel.class$("java.lang.String")) : class$java$lang$String};
    private static final int COLUMN_COMPONENT_INTERFACE_DEFINITION_NAME = 0;
    private ComponentInterfaceImplementation mComponentInterfaceImplementation = null;
    private ComponentInterfaceDefinition[] mComponentInterfaceDefinitions = null;
    static /* synthetic */ Class class$java$lang$String;

    public ImplementedComponentInterfaceDefinitionsTableModel(Controller controller, ComponentInterfaceImplementation componentInterfaceImplementation) {
        super(controller);
        this.mComponentInterfaceImplementation = componentInterfaceImplementation;
        this.setNumberOfColumns(1);
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.updateDataTable();
        this.mComponentInterfaceImplementation.attachObserver((DevelopmentObjectObserver)this);
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 | index > this.mComponentInterfaceDefinitions.length) {
            return null;
        }
        return this.mComponentInterfaceDefinitions[index];
    }

    protected void masterObjectChanged(DevelopmentObject newMasterObject) {
        super.masterObjectChanged(newMasterObject);
    }

    protected void updateDataTable() {
        if (this.mComponentInterfaceImplementation != null) {
            this.mComponentInterfaceDefinitions = this.mComponentInterfaceImplementation.getImplementedInterfaces();
            Arrays.sort(this.mComponentInterfaceDefinitions, new DevelopmentObjectNameComparator());
        }
    }

    public int getRowCount() {
        if (this.mComponentInterfaceDefinitions == null) {
            return 0;
        }
        return this.mComponentInterfaceDefinitions.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mComponentInterfaceDefinitions.length <= rowIndex) {
            return AbstractControllerTableModel.ERROR;
        }
        ComponentInterfaceDefinition componentInterfaceDefinition = this.mComponentInterfaceDefinitions[rowIndex];
        if (componentInterfaceDefinition == null) {
            return AbstractControllerTableModel.ERROR;
        }
        switch (columnIndex) {
            case 0: {
                if (componentInterfaceDefinition == null) {
                    return AbstractControllerTableModel.ERROR;
                }
                return componentInterfaceDefinition.getName();
            }
        }
        return AbstractControllerTableModel.ERROR;
    }

    protected void doCopy(MetamodelClipboard clipboard, int[] indexes) {
    }

    protected void doPaste(MetamodelClipboard clipboard) {
    }

    protected boolean canPaste(MetamodelClipboard clipboard) {
        return false;
    }

    protected void doRename(int[] indexes) {
    }

    protected void doDelete(int[] indexes) {
        ComponentInterfaceDefinition[] definitions = this.getIndexesDefinitions(indexes);
        boolean userSaidDeleteAll = false;
        int result = -1;
        int i = 0;
        while (i < definitions.length) {
            MMRepositoryObject[] repositoryObjects = ImplementedComponentInterfaceDefinitionUsageService.getRepositoryObjectsAffectedByImplementedComponentInterfaceDefintionUsageDeletion((ComponentInterfaceImplementation)this.mComponentInterfaceImplementation);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            ComponentInterfaceDefinition componentInterfaceDefinition = definitions[i];
            if (!userSaidDeleteAll && (result = UIHelper.askUserToDeleteAll((String)componentInterfaceDefinition.getName(), (String)mTextPool.getText(173))) == 1) {
                userSaidDeleteAll = true;
                result = 0;
            }
            if (result == 0) {
                ImplementedComponentInterfaceDefinitionUsageService.deleteComponentInterfaceDefinitionUsage((ComponentInterfaceImplementation)this.mComponentInterfaceImplementation, (ComponentInterfaceDefinition)componentInterfaceDefinition);
            }
            ++i;
        }
    }

    protected void doEdit(int[] indexes) {
    }

    protected void doNew() {
        MMRepositoryObject[] repositoryObjects = ImplementedComponentInterfaceDefinitionUsageService.getRepositoryObjectsAffectedByImplementedComponentInterfaceDefintionUsageCreation((ComponentInterfaceImplementation)this.mComponentInterfaceImplementation);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        ImplementedComponentInterfaceDefinitionUsageService.createComponentInterfaceDefinitionUsages((ComponentInterfaceImplementation)this.mComponentInterfaceImplementation);
    }

    public boolean isCopyable(int[] indexes) {
        return false;
    }

    public boolean isEditable(int[] indexes) {
        return false;
    }

    public void tableModelDisposed() {
        super.tableModelDisposed();
        this.mComponentInterfaceImplementation.detachObserver((DevelopmentObjectObserver)this);
    }

    protected boolean isReadOnly() {
        return this.mComponentInterfaceImplementation.originatesInArchive();
    }

    protected boolean isEventRelevant(MetamodelEvent event) {
        switch (event.getEventId()) {
            case 256: {
                ReferencedObjectAddedEvent referencedObjectAddedEvent = (ReferencedObjectAddedEvent)event;
                return referencedObjectAddedEvent.getReferencedObject() instanceof ComponentInterfaceDefinition;
            }
            case 512: {
                ReferencedObjectRemovedEvent referencedObjectRemovedEvent = (ReferencedObjectRemovedEvent)event;
                return referencedObjectRemovedEvent.getReferencedObject() instanceof ComponentInterfaceDefinition;
            }
            case 2: {
                ObjectDeletedEvent objectDeletedEvent = (ObjectDeletedEvent)event;
                if (objectDeletedEvent.getModifiedObject() instanceof ComponentInterfaceDefinition) {
                    ComponentInterfaceDefinition componentInterfaceDefinition = (ComponentInterfaceDefinition)objectDeletedEvent.getModifiedObject();
                    int i = 0;
                    while (i < this.mComponentInterfaceDefinitions.length) {
                        if (componentInterfaceDefinition.equals(this.mComponentInterfaceDefinitions[i])) {
                            this.mComponentInterfaceImplementation.removeImplementedInterface(componentInterfaceDefinition);
                        }
                        ++i;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private ComponentInterfaceDefinition[] getIndexesDefinitions(int[] indexes) {
        ComponentInterfaceDefinition[] definitions = new ComponentInterfaceDefinition[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            definitions[i] = this.mComponentInterfaceDefinitions[indexes[i]];
            ++i;
        }
        return definitions;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

