/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.overview;

import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import com.tssap.util.ui.glpc.section.AbstractSection;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Text;

public class ControllerPropertiesSection
extends AbstractSection {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String TYPE_COMPONENT = mCoreTextPool.getText(102);
    private static final String TYPE_COMPONENT_INTERFACE = mCoreTextPool.getText(122);
    private static final String TYPE_COMPONENT_CONFIGURATION = mCoreTextPool.getText(124);
    private static final String TYPE_INTERFACE_VIEW = mCoreTextPool.getText(125);
    private static final String TYPE_VIEW = mCoreTextPool.getText(103);
    private static final String TYPE_CUSTOM = mCoreTextPool.getText(101);
    private static final String TYPE_UNDEFINED = mTextPool.getText(999);
    private Controller mController = null;
    Text mNameField = null;
    ControllerRefactorObserver mControllerRefactorObserver = null;

    public ControllerPropertiesSection(Controller controller, Component application) {
        super(ServiceCorePlugin.WIDGET_FACTORY, 2, mTextPool.getText(51), mTextPool.getText(52));
        this.mController = controller;
        this.mControllerRefactorObserver = new ControllerRefactorObserver();
        this.mController.attachObserver((DevelopmentObjectObserver)this.mControllerRefactorObserver, 8256);
    }

    public void initSection(IGridLayoutPane glp) {
        this.getUserAreaGridLayoutPane().addDisposeListener((DisposeListener)new SectionDisposeListener());
        glp.addTextLabel(mTextPool.getText(162));
        IGridLayoutData gd = glp.createGridLayoutData(4, 1, true, false);
        this.mNameField = glp.addTextField(this.mController.getQualifiedName(), true, gd);
        glp.addTextLabel(mTextPool.getText(54));
        gd = glp.createGridLayoutData(4, 1, true, false);
        glp.addTextField(this.getControllerTypeString(this.mController.getType()), true, gd);
    }

    private String getControllerTypeString(ControllerTypeEnum type) {
        if (type == ControllerTypeEnum.COMPONENT) {
            return TYPE_COMPONENT;
        }
        if (type == ControllerTypeEnum.COMPONENT_INTERFACE) {
            return TYPE_COMPONENT_INTERFACE;
        }
        if (type == ControllerTypeEnum.COMPONENT_CONFIGURATION) {
            return TYPE_COMPONENT_CONFIGURATION;
        }
        if (type == ControllerTypeEnum.INTERFACE_VIEW) {
            return TYPE_INTERFACE_VIEW;
        }
        if (type == ControllerTypeEnum.VIEW) {
            return TYPE_VIEW;
        }
        if (type == ControllerTypeEnum.CUSTOM) {
            return TYPE_CUSTOM;
        }
        return TYPE_UNDEFINED;
    }

    private class ControllerRefactorObserver
    implements DevelopmentObjectObserver {
        private ControllerRefactorObserver() {
        }

        public void update(MetamodelEvent event) {
            MetamodelEvent[] events = new MetamodelEvent[]{event};
            this.update(events);
        }

        public void update(MetamodelEvent[] events) {
            ControllerPropertiesSection.this.mNameField.setText(ControllerPropertiesSection.this.mController.getQualifiedName());
        }
    }

    private class SectionDisposeListener
    implements DisposeListener {
        private SectionDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            ControllerPropertiesSection.this.mController.detachObserver((DevelopmentObjectObserver)ControllerPropertiesSection.this.mControllerRefactorObserver);
        }
    }
}

