/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.overview;

import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.enum.ComponentLifecycleEnum;
import com.sap.ide.webdynpro.controllereditor.EditUI;
import com.sap.ide.webdynpro.controllereditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.wizards.componentusage.CreateComponentUsageWizardData;
import com.sap.ide.webdynpro.service.controllereditor.ServiceControllerEditorPlugin;
import com.sap.ide.webdynpro.service.controllereditor.ServiceWithUI;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.component.ComponentService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectFilter;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class ComponentUsageEditUI
extends EditUI {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    private Component mComponent = null;
    private CreateComponentUsageWizardData mData = null;
    private int mMode;
    private Text mNameField = null;
    private Text mUsedComponentNameField = null;
    private Button mUsedComponentNameButton = null;
    private Combo mComponentLifecycleField = null;

    public ComponentUsageEditUI(CreateComponentUsageWizardData data, int mode, Component component, IDisplayErrorListener displayErrorListener) {
        super(displayErrorListener);
        this.mData = data;
        this.mMode = mode;
        this.mComponent = component;
    }

    public void initUI(IGridLayoutPane glp) {
        glp.addTextLabel(mTextPool.getText(551));
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, false);
        this.mNameField = glp.addTextField(this.mData.getName(), this.mMode == 1, gd);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        this.mNameField.setFocus();
        glp.addPlaceholder();
        glp.addTextLabel(mTextPool.getText(556));
        gd = glp.createGridLayoutData(4, 4, true, false);
        this.mUsedComponentNameField = glp.addTextField(this.mData.getUsedComponentName(), this.mComponent.isReadOnly(), gd);
        gd = glp.createGridLayoutData(4, 4, false, false);
        this.mUsedComponentNameButton = glp.addPushButton(mTextPool.getText(75), gd);
        this.mUsedComponentNameButton.setEnabled(!this.mComponent.isReadOnly());
        glp.addTextLabel(mTextPool.getText(580));
        gd = glp.createGridLayoutData(4, 4, true, false);
        this.mComponentLifecycleField = glp.addComboBox(this.mData.getComponentLifecycleTexts(), this.mData.getSelectedComponentLifecycleText(), true, gd);
        this.mComponentLifecycleField.setEnabled(this.mData.getUsedComponentInterface() instanceof ComponentInterfaceImplementation);
        this.mUsedComponentNameField.addModifyListener((ModifyListener)new UsedComponentNameModifyListener());
        this.mUsedComponentNameButton.addSelectionListener((SelectionListener)new UsedComponentButtonSelectionListener());
        this.mComponentLifecycleField.addSelectionListener((SelectionListener)new ComponentLifecycleSelectionListener());
        this.getDisplayErrorListener().setErrorMessage("");
    }

    private boolean validatePage() {
        String error = null;
        if (this.mMode != 1) {
            error = ComponentService.isNewComponentUsageNameValid((String)this.mNameField.getText(), (Component)this.mComponent);
            this.getDisplayErrorListener().setErrorMessage(error);
            if (error != null) {
                return false;
            }
        }
        WebDynproRoot root = (WebDynproRoot)this.mComponent.getRoot();
        String packageName = "";
        String componentName = "";
        int index = this.mUsedComponentNameField.getText().lastIndexOf(".");
        if (index != -1) {
            packageName = this.mUsedComponentNameField.getText().substring(0, index);
            componentName = this.mUsedComponentNameField.getText().substring(index + 1);
        }
        Component usedComponent = null;
        try {
            usedComponent = root.getComponent(packageName, componentName);
        }
        catch (LoadException le) {
            ServiceControllerEditorPlugin.internalError(this.getClass(), (String)"validatePage()", (String)le.getMessage(), (Throwable)le, (boolean)false);
        }
        ComponentInterfaceDefinition usedInterfaceDefinition = null;
        if (usedComponent == null) {
            try {
                usedInterfaceDefinition = root.getComponentInterfaceDefinition(packageName, componentName);
            }
            catch (LoadException le) {
                ServiceControllerEditorPlugin.internalError(this.getClass(), (String)"validatePage()", (String)le.getMessage(), (Throwable)le, (boolean)false);
            }
        }
        if (usedComponent != null) {
            this.getDisplayErrorListener().setErrorMessage(null);
            this.mData.setUsedComponent(usedComponent);
            this.mComponentLifecycleField.setEnabled(true);
        } else if (usedInterfaceDefinition != null) {
            this.getDisplayErrorListener().setErrorMessage(null);
            this.mData.setUsedComponentInterfaceDefinition(usedInterfaceDefinition);
            this.mData.setSelectedComponentLifecycle(ComponentLifecycleEnum.MANUAL);
            this.mComponentLifecycleField.select(this.mData.getSelectedComponentLifecycleIndex());
            this.mComponentLifecycleField.setEnabled(false);
        } else {
            this.getDisplayErrorListener().setErrorMessage(mTextPool.getText(1042, (Object)this.mUsedComponentNameField.getText()));
            this.mData.setUsedComponent(null);
            return false;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        this.mNameField.setFocus();
    }

    private class ComponentLifecycleSelectionListener
    implements SelectionListener {
        private ComponentLifecycleSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int index = ComponentUsageEditUI.this.mComponentLifecycleField.getSelectionIndex();
            if (index != ComponentUsageEditUI.this.mData.getSelectedComponentLifecycleIndex()) {
                ComponentUsageEditUI.this.mData.setSelectedComponentLifecycle(index);
            }
        }
    }

    private class ComponentFilter
    implements DevelopmentObjectFilter {
        private Component mComponent = null;
        private ComponentUsage[] mComponentUsages = null;

        public ComponentFilter(Component component) {
            this.mComponent = component;
            this.mComponentUsages = component.getComponentUsages();
        }

        public boolean isValidObject(DevelopmentObject object) {
            if (object instanceof Component) {
                Component component = (Component)object;
                if (this.mComponent.equals(component)) {
                    return false;
                }
                return component.getComponentInterface() != null;
            }
            return object instanceof ComponentInterfaceDefinition;
        }
    }

    class UsedComponentButtonSelectionListener
    implements SelectionListener {
        UsedComponentButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            DevelopmentObject developmentObject = ServiceWithUI.selectComponentInterface((DevelopmentObjectFilter)new ComponentFilter(ComponentUsageEditUI.this.mComponent), (String)ServicesEclipse.getEclipseProject((DevelopmentObject)ComponentUsageEditUI.this.mComponent).getName());
            if (developmentObject != null) {
                if (developmentObject instanceof Component) {
                    ComponentUsageEditUI.this.mData.setUsedComponent((Component)developmentObject);
                    ComponentUsageEditUI.this.mData.setSelectedComponentLifecycle(ComponentLifecycleEnum.CREATEONDEMAND);
                    ComponentUsageEditUI.this.mComponentLifecycleField.select(ComponentUsageEditUI.this.mData.getSelectedComponentLifecycleIndex());
                    ComponentUsageEditUI.this.mComponentLifecycleField.setEnabled(true);
                } else if (developmentObject instanceof ComponentInterfaceDefinition) {
                    ComponentUsageEditUI.this.mData.setUsedComponentInterfaceDefinition((ComponentInterfaceDefinition)developmentObject);
                    ComponentUsageEditUI.this.mData.setSelectedComponentLifecycle(ComponentLifecycleEnum.MANUAL);
                    ComponentUsageEditUI.this.mComponentLifecycleField.select(ComponentUsageEditUI.this.mData.getSelectedComponentLifecycleIndex());
                    ComponentUsageEditUI.this.mComponentLifecycleField.setEnabled(false);
                } else {
                    Plugin.internalError(this.getClass(), "widgetSelected(SelectionEvent)", "Selected object is neither a component nor a component interface definition", new Exception(), false);
                    return;
                }
                ComponentUsageEditUI.this.mUsedComponentNameField.setText(((MainDevelopmentObject)developmentObject).getQualifiedName());
            }
        }
    }

    class UsedComponentNameModifyListener
    implements ModifyListener {
        UsedComponentNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ComponentUsageEditUI.this.validatePage();
        }
    }

    class NameModifyListener
    implements ModifyListener {
        NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ComponentUsageEditUI.this.validatePage();
            ComponentUsageEditUI.this.mData.setName(ComponentUsageEditUI.this.mNameField.getText());
        }
    }
}

