/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.methods;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.event.ReferencedObjectRefactoredEvent;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.base.ErrorHandler;
import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.base.Method;
import com.sap.ide.metamodel.webdynpro.base.Procedure;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.controller.CalculatedAttributeMethod;
import com.sap.ide.metamodel.webdynpro.component.controller.CalculatedAttributeProvider;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerEventHandler;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.SupplyFunction;
import com.sap.ide.metamodel.webdynpro.enum.VisibilityEnum;
import com.sap.ide.metamodel.webdynpro.event.Event;
import com.sap.ide.metamodel.webdynpro.event.EventSource;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableModel;
import com.sap.ide.webdynpro.controllereditor.methods.MethodEditDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.method.CreateMethodWizardDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.method.RenameMethodWizard;
import com.sap.ide.webdynpro.service.controllereditor.ControllerPasteManager;
import com.sap.ide.webdynpro.service.controllereditor.event.EventService;
import com.sap.ide.webdynpro.service.controllereditor.method.MethodService;
import com.sap.ide.webdynpro.service.controllereditor.usage.ControllerUsageService;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectNameComparator;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardDialog;
import java.util.ArrayList;
import java.util.Arrays;

public class MethodsTableModel
extends AbstractControllerTableModel {
    private static final int NUMBER_OF_COLUMNS = 5;
    private static final String[] COLUMN_NAMES = new String[]{AbstractControllerTableModel.mTextPool.getText(509), AbstractControllerTableModel.mTextPool.getText(510), AbstractControllerTableModel.mTextPool.getText(515), AbstractControllerTableModel.mTextPool.getText(517), AbstractControllerTableModel.mTextPool.getText(518)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$com$sap$ide$metamodel$webdynpro$base$Procedure == null ? (class$com$sap$ide$metamodel$webdynpro$base$Procedure = MethodsTableModel.class$("com.sap.ide.metamodel.webdynpro.base.Procedure")) : class$com$sap$ide$metamodel$webdynpro$base$Procedure, class$java$lang$String == null ? (class$java$lang$String = MethodsTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = MethodsTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = MethodsTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = MethodsTableModel.class$("java.lang.String")) : class$java$lang$String};
    private static final int[] COLUMN_WIDTHS = new int[]{18, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
    public static final int COLUMN_TYPE = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_RETURN_VALUE = 2;
    private static final int COLUMN_EVENT_SOURCE = 3;
    private static final int COLUMN_SUBSCRIBED_EVENT = 4;
    private Procedure[] mProcedures = null;
    ControllerRefactorObserver mControllerRefactorObserver = null;
    RefactoringObserver mRefactoringObserver = null;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$base$Procedure;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$Controller;

    public MethodsTableModel(Controller controller) {
        super(controller);
        this.setNumberOfColumns(5);
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.updateDataTable();
        this.mControllerRefactorObserver = new ControllerRefactorObserver();
        this.getController().getRoot().attachClassObserver(class$com$sap$ide$metamodel$webdynpro$component$controller$Controller == null ? (class$com$sap$ide$metamodel$webdynpro$component$controller$Controller = MethodsTableModel.class$("com.sap.ide.metamodel.webdynpro.component.controller.Controller")) : class$com$sap$ide$metamodel$webdynpro$component$controller$Controller, (DevelopmentObjectObserver)this.mControllerRefactorObserver, 8256);
        this.mRefactoringObserver = new RefactoringObserver();
        this.getController().attachChildrenObserver((DevelopmentObjectObserver)this.mRefactoringObserver);
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 | index > this.mProcedures.length) {
            return null;
        }
        return this.mProcedures[index];
    }

    protected void masterObjectChanged(DevelopmentObject newMasterObject) {
        super.masterObjectChanged(newMasterObject);
    }

    protected void updateDataTable() {
        if (this.getController() != null) {
            EventHandler[] eventHandlers = this.getController().getEventHandlers();
            Arrays.sort(eventHandlers, new DevelopmentObjectNameComparator());
            ErrorHandler[] errorHandlers = this.getController().getErrorHandlers();
            Arrays.sort(errorHandlers, new DevelopmentObjectNameComparator());
            SupplyFunction[] supplyFunctions = this.getController().getSupplyFunctions();
            Arrays.sort(supplyFunctions, new DevelopmentObjectNameComparator());
            CalculatedAttributeProvider[] providers = this.getController().getCalculatedAttributeProviders();
            Arrays.sort(providers, new DevelopmentObjectNameComparator());
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < providers.length) {
                CalculatedAttributeMethod cam = providers[i].getAccessor();
                if (cam != null) {
                    list.add(cam);
                }
                if ((cam = providers[i].getMutator()) != null) {
                    list.add(cam);
                }
                ++i;
            }
            CalculatedAttributeMethod[] cams = new CalculatedAttributeMethod[list.size()];
            cams = list.toArray(cams);
            Method[] methods = this.getController().getMethods();
            Arrays.sort(methods, new DevelopmentObjectNameComparator());
            list = new ArrayList();
            int i2 = 0;
            while (i2 < eventHandlers.length) {
                list.add(eventHandlers[i2]);
                ++i2;
            }
            int i3 = 0;
            while (i3 < errorHandlers.length) {
                list.add(errorHandlers[i3]);
                ++i3;
            }
            int i4 = 0;
            while (i4 < supplyFunctions.length) {
                list.add(supplyFunctions[i4]);
                ++i4;
            }
            int i5 = 0;
            while (i5 < cams.length) {
                list.add(cams[i5]);
                ++i5;
            }
            int i6 = 0;
            while (i6 < methods.length) {
                list.add(methods[i6]);
                ++i6;
            }
            this.mProcedures = new Procedure[list.size()];
            this.mProcedures = list.toArray(this.mProcedures);
        }
    }

    public int getRowCount() {
        if (this.mProcedures == null) {
            return 0;
        }
        return this.mProcedures.length;
    }

    public int[] getColumnWidths() {
        return COLUMN_WIDTHS;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mProcedures == null || this.mProcedures.length <= rowIndex) {
            return AbstractControllerTableModel.ERROR;
        }
        Procedure procedure = this.mProcedures[rowIndex];
        if (procedure == null) {
            return AbstractControllerTableModel.ERROR;
        }
        EventHandler eventHandler = null;
        switch (columnIndex) {
            case 0: {
                return procedure;
            }
            case 1: {
                return procedure.getName();
            }
            case 2: {
                if (procedure.getReturnType() != null) {
                    MetamodelServices.CompoundType type = new MetamodelServices.CompoundType(procedure.getReturnType());
                    if (type.isJavaNativeType()) {
                        return this.addDimensionString(type.getQualifiedName(), type.getJavaNativeType().getArrayDimensions());
                    }
                    return type.getName();
                }
                return "void";
            }
            case 3: {
                if (!(procedure instanceof EventHandler)) {
                    return "";
                }
                eventHandler = (EventHandler)procedure;
                if (eventHandler.getEventSource() == null | !(eventHandler.getEventSource() instanceof ControllerUsage)) {
                    return "";
                }
                ControllerUsage usage = (ControllerUsage)eventHandler.getEventSource();
                return ControllerUsageService.getComponentUsageDisplayName((ControllerUsage)usage);
            }
            case 4: {
                if (!(procedure instanceof EventHandler)) {
                    return "";
                }
                eventHandler = (EventHandler)procedure;
                if (eventHandler.getSubscribedEvent() == null) {
                    return "";
                }
                return EventService.getExternalEventName((Event)eventHandler.getSubscribedEvent());
            }
        }
        return AbstractControllerTableModel.ERROR;
    }

    protected void doCopy(MetamodelClipboard clipboard, int[] indexes) {
        Procedure[] procedures = this.getIndexesMethods(indexes);
        clipboard.copy((DevelopmentObject[])procedures);
    }

    protected void doPaste(MetamodelClipboard clipboard) {
        MMRepositoryObject[] repositoryObjects = MethodService.getRepositoryObjectsAffectedByMethodCreation((Controller)this.getController());
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        ControllerPasteManager controllerPasteManager = new ControllerPasteManager();
        controllerPasteManager.paste(clipboard, (MetamodelObject)this.getController());
    }

    protected boolean canPaste(MetamodelClipboard clipboard) {
        DevelopmentObjectEnum[] objects = clipboard.getContentTypes();
        int i = 0;
        while (i < objects.length) {
            if (!objects[i].equals(WebDynproDevelopmentObjectEnum.CONTROLLEREVENTHANDLER) && !objects[i].equals(WebDynproDevelopmentObjectEnum.CONTROLLERMETHOD)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void doRename(int[] indexes) {
        Procedure[] procedures = this.getIndexesMethods(indexes);
        int i = 0;
        while (i < procedures.length) {
            Procedure procedure = procedures[i];
            MMRepositoryObject[] repositoryObjects = MethodService.getRepositoryObjectsAffectedByMethodModification((Procedure)procedure);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            RenameMethodWizard renameWizard = new RenameMethodWizard((DevelopmentObject)procedure);
            RenameWizardDialog wizardDialog = new RenameWizardDialog((RenameWizard)renameWizard);
            wizardDialog.open();
            wizardDialog.close();
            ++i;
        }
    }

    protected void doDelete(int[] indexes) {
        Procedure[] procedures = this.getIndexesMethods(indexes);
        boolean userSaidDeleteAll = false;
        int result = -1;
        int i = 0;
        while (i < procedures.length) {
            Procedure procedure = procedures[i];
            MMRepositoryObject[] repositoryObjects = MethodService.getRepositoryObjectsAffectedByMethodDeletion((Procedure)procedure);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            String typeName = null;
            if (procedure instanceof EventHandler) {
                typeName = AbstractControllerTableModel.mTextPool.getText(900);
            } else if (procedure instanceof ErrorHandler) {
                typeName = AbstractControllerTableModel.mTextPool.getText(903);
            } else if (procedure instanceof SupplyFunction) {
                typeName = AbstractControllerTableModel.mTextPool.getText(905);
                SupplyFunction supplyFunction = (SupplyFunction)procedure;
                if (supplyFunction.hasSuppliedNode()) {
                    supplyFunction.getSuppliedNode().setSupplyFunction(null);
                }
            } else if (procedure instanceof CalculatedAttributeMethod) {
                CalculatedAttributeMethod cam = (CalculatedAttributeMethod)procedure;
                DevelopmentObject object = cam.getParent();
                if (object instanceof CalculatedAttributeProvider) {
                    CalculatedAttributeProvider cap = (CalculatedAttributeProvider)object;
                    typeName = cap.getAccessor().equals(cam) ? AbstractControllerTableModel.mTextPool.getText(910) : (cap.getAccessor().equals(cam) ? AbstractControllerTableModel.mTextPool.getText(911) : AbstractControllerTableModel.ERROR);
                }
            } else {
                typeName = AbstractControllerTableModel.mTextPool.getText(902);
            }
            if (!userSaidDeleteAll && (result = UIHelper.askUserToDeleteAll((String)procedure.getName(), (String)typeName)) == 1) {
                userSaidDeleteAll = true;
                result = 0;
            }
            if (result == 0) {
                MethodService.deleteProcedure((Procedure)procedure);
            }
            ++i;
        }
    }

    protected void doEdit(int[] indexes) {
        Procedure[] procedures = this.getIndexesMethods(indexes);
        int i = 0;
        while (i < procedures.length) {
            Procedure procedure = procedures[i];
            MMRepositoryObject[] repositoryObjects = MethodService.getRepositoryObjectsAffectedByMethodModification((Procedure)procedure);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            MethodEditDialog dialog = new MethodEditDialog(procedure, 1);
            if (dialog.open() == 0) {
                MetamodelServices.CompoundType compoundType = null;
                compoundType = dialog.getNewCompoundReturnType() != null ? dialog.getNewCompoundReturnType() : dialog.getNewReturnTypeAsCompoundType();
                if (procedure instanceof EventHandler) {
                    MethodService.editEventHandler((EventHandler)((EventHandler)procedure), (VisibilityEnum)dialog.getNewVisibility(), (DevelopmentObject)dialog.getNewReturnType(), (EventSource)dialog.getNewEventSource(), (Event)dialog.getNewSubscribedEvent(), (boolean)dialog.isCreateParameters(), (MetamodelServices.CompoundType)compoundType);
                } else {
                    MethodService.editProcedure((Procedure)procedure, (VisibilityEnum)dialog.getNewVisibility(), (DevelopmentObject)dialog.getNewReturnType(), (MetamodelServices.CompoundType)compoundType, (boolean)true, (int)dialog.getNewReturnTypeArrayDimension());
                }
            }
            ++i;
        }
    }

    protected void doNew() {
        MMRepositoryObject[] repositoryObjects = MethodService.getRepositoryObjectsAffectedByMethodCreation((Controller)this.getController());
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        CreateMethodWizardDialog dialog = new CreateMethodWizardDialog(this.getController());
        if (this.getController().getParent() instanceof ComponentInterfaceDefinition) {
            dialog.setMethodType(3);
        }
        dialog.open();
        dialog.close();
    }

    public boolean isCopyable(int[] indexes) {
        return this.isObjectSelected() && !this.isSupplyFunctionSelected(indexes) && !this.isCalculatedAttributeMethodSelected(indexes) && super.isCopyable(indexes);
    }

    public boolean isCutable(int[] indexes) {
        return false;
    }

    public boolean isEditable(int[] indexes) {
        return this.isObjectSelected() && !this.isSupplyFunctionSelected(indexes) && !this.isCalculatedAttributeMethodSelected(indexes) && super.isEditable(indexes);
    }

    public boolean isRenameable(int[] indexes) {
        return this.isObjectSelected() && !this.isSupplyFunctionSelected(indexes) && !this.isCalculatedAttributeMethodSelected(indexes) && super.isRenameable(indexes);
    }

    public boolean isDeletable(int[] indexes) {
        return this.isObjectSelected() && !this.isCalculatedAttributeMethodSelected(indexes) && super.isDeletable(indexes);
    }

    public boolean isSupplyFunctionSelected(int[] indexes) {
        boolean result = false;
        Procedure[] procedures = this.getIndexesMethods(indexes);
        int i = 0;
        while (i < procedures.length) {
            if (procedures[i] instanceof SupplyFunction) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public boolean isCalculatedAttributeMethodSelected(int[] indexes) {
        boolean result = false;
        Procedure[] procedures = this.getIndexesMethods(indexes);
        int i = 0;
        while (i < procedures.length) {
            if (procedures[i] instanceof CalculatedAttributeMethod) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    protected boolean isReadOnly() {
        return this.getController().originatesInArchive();
    }

    protected boolean isEventRelevant(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof Procedure) {
            switch (event.getEventId()) {
                case 1: 
                case 2: 
                case 4: 
                case 64: 
                case 128: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void tableModelDisposed() {
        super.tableModelDisposed();
        this.getController().getRoot().detachClassObserver(class$com$sap$ide$metamodel$webdynpro$component$controller$Controller == null ? (class$com$sap$ide$metamodel$webdynpro$component$controller$Controller = MethodsTableModel.class$("com.sap.ide.metamodel.webdynpro.component.controller.Controller")) : class$com$sap$ide$metamodel$webdynpro$component$controller$Controller, (DevelopmentObjectObserver)this.mControllerRefactorObserver);
        this.getController().detachChildrenObserver((DevelopmentObjectObserver)this.mRefactoringObserver);
    }

    protected String addDimensionString(String typeName, int dimension) {
        String result = typeName;
        int i = 0;
        while (i < dimension) {
            result = result + "[]";
            ++i;
        }
        return result;
    }

    private Procedure[] getIndexesMethods(int[] indexes) {
        Procedure[] procedures = new Procedure[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            procedures[i] = this.mProcedures[indexes[i]];
            ++i;
        }
        return procedures;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RefactoringObserver
    implements DevelopmentObjectObserver {
        private RefactoringObserver() {
        }

        public void update(MetamodelEvent event) {
            MetamodelEvent[] events = new MetamodelEvent[]{event};
            this.update(events);
        }

        public void update(MetamodelEvent[] events) {
            int i = 0;
            while (i < events.length) {
                if (events[i] instanceof ReferencedObjectRefactoredEvent) {
                    MethodsTableModel.this.fireTableDataChanged();
                    break;
                }
                ++i;
            }
        }
    }

    private class ControllerRefactorObserver
    implements DevelopmentObjectObserver {
        private ControllerRefactorObserver() {
        }

        public void update(MetamodelEvent event) {
            MetamodelEvent[] events = new MetamodelEvent[]{event};
            this.update(events);
        }

        public void update(MetamodelEvent[] events) {
            boolean updateNecessary = false;
            int i = 0;
            while (i < events.length) {
                int j = 0;
                while (j < MethodsTableModel.this.mProcedures.length) {
                    ControllerEventHandler eventHandler;
                    if (MethodsTableModel.this.mProcedures[j] instanceof ControllerEventHandler && (eventHandler = (ControllerEventHandler)MethodsTableModel.this.mProcedures[j]).getEventSource() instanceof ControllerUsage) {
                        ControllerUsage usage = (ControllerUsage)eventHandler.getEventSource();
                        if (events[i].getModifiedObject().equals(usage.getUsedController())) {
                            updateNecessary = true;
                            break;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (updateNecessary) {
                MethodsTableModel.this.fireTableDataChanged();
            }
        }
    }
}

