/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.methods;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.plugin.DictionaryRootManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.event.Event;
import com.sap.ide.webdynpro.checklayer.controller.ControllerChecker;
import com.sap.ide.webdynpro.controllereditor.EditUI;
import com.sap.ide.webdynpro.controllereditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.controllereditor.wizards.method.CreateMethodWizardData;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.eventhandler.EventhandlerService;
import com.sap.ide.webdynpro.service.controllereditor.method.MethodService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class MethodEditUI
extends EditUI {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String LINE_SEPERATOR = "line.separator";
    private Controller mController = null;
    private CreateMethodWizardData mData = null;
    private int mMode;
    private boolean mSupportsArrays = false;
    private Text mNameField = null;
    private Combo mReturnTypeField = null;
    private Label mArraySeparator = null;
    private Button mArrayButton = null;
    private Label mArrayDimensionLabel = null;
    private Text mArrayDimensionField = null;
    private Button mReturnTypeSelectionButton = null;
    private Label mEventHandlerSeparator = null;
    private Label mEventSourceLabel = null;
    private Combo mEventSourceField = null;
    private Label mSubscribedEventLabel = null;
    private Combo mSubscribedEventField = null;
    private Button mCreateParametersButton = null;
    private boolean mIsChangeMethodType = false;

    public MethodEditUI(CreateMethodWizardData data, int mode, Controller controller, IDisplayErrorListener displayErrorListener, boolean supportsArrays) {
        super(displayErrorListener);
        this.mData = data;
        this.mMode = mode;
        this.mController = controller;
        this.mSupportsArrays = supportsArrays;
    }

    public void initUI(IGridLayoutPane glp) {
        glp.addTextLabel(mTextPool.getText(134));
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, false);
        this.mNameField = glp.addTextField(this.mData.getName(), this.mMode == 1, gd);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        this.mNameField.setFocus();
        gd = glp.createGridLayoutData(4, 4, false, false);
        glp.addPlaceholder(gd);
        glp.addTextLabel(mTextPool.getText(137));
        gd = glp.createGridLayoutData(4, 4, true, false);
        this.mReturnTypeField = glp.addComboBox(this.mData.getReturnTypeNames(), this.mData.getSelectedReturnTypeName(), true, gd);
        this.mReturnTypeField.select(this.mData.getSelectedReturnTypeIndex());
        ReturnTypeModifyListener modifyListener = new ReturnTypeModifyListener();
        this.mReturnTypeField.addModifyListener((ModifyListener)modifyListener);
        gd = glp.createGridLayoutData(1, 4, false, false);
        this.mReturnTypeSelectionButton = glp.addPushButton("...", gd);
        this.mReturnTypeSelectionButton.addSelectionListener((SelectionListener)new ReturnTypeSelectionButtonListener(modifyListener));
        if (this.mData.getType() == 0) {
            this.mReturnTypeSelectionButton.setEnabled(false);
        }
        if (this.mSupportsArrays) {
            this.mArraySeparator = glp.addHorizontalSeparator();
            gd = glp.createGridLayoutData(4, 4, true, false, 2, 1);
            this.mArrayButton = glp.addCheckBox(mTextPool.getText(581), this.mData.isArray(), gd);
            if (!this.isArrayPossible()) {
                this.mArrayButton.setEnabled(false);
                this.mArrayButton.setSelection(false);
                this.mData.setArray(false);
            }
            this.mArrayButton.addSelectionListener((SelectionListener)new ArrayButtonSelectionListener());
            glp.addPlaceholder();
            this.mArrayDimensionLabel = glp.addTextLabel(mTextPool.getText(582));
            gd = glp.createGridLayoutData(1, 4, false, false);
            this.mArrayDimensionField = glp.addTextField(this.mData.getArrayDimensionString(), gd);
            if (!this.mData.isArray()) {
                this.mArrayDimensionField.setEnabled(false);
            }
            this.mArrayDimensionField.addModifyListener((ModifyListener)new ArrayDimensionModifyListener());
            glp.addPlaceholder();
        }
        if (this.mData.getType() == 0) {
            this.mEventHandlerSeparator = glp.addHorizontalSeparator();
            this.mEventSourceLabel = glp.addTextLabel(mTextPool.getText(138));
            gd = glp.createGridLayoutData(4, 4, true, false);
            this.mEventSourceField = glp.addComboBox(this.mData.getEventSourceNames(), this.mData.getSelectedEventSourceName(), true, gd);
            this.mEventSourceField.addModifyListener((ModifyListener)new EventSourceNameModifyListener());
            gd = glp.createGridLayoutData(4, 4, false, false);
            glp.addPlaceholder(gd);
            this.mSubscribedEventLabel = glp.addTextLabel(mTextPool.getText(139));
            gd = glp.createGridLayoutData(4, 4, true, false);
            this.mSubscribedEventField = glp.addComboBox(this.mData.getSubscribedEventNames(), this.mData.getSelectedSubscribedEventName(), true, gd);
            this.mSubscribedEventField.addModifyListener((ModifyListener)new SubscribedEventNameModifyListener());
            gd = glp.createGridLayoutData(4, 4, false, false);
            glp.addPlaceholder(gd);
            gd = glp.createGridLayoutData(4, 4, true, false, 3, 1);
            this.mCreateParametersButton = glp.addCheckBox(mTextPool.getText(561), this.mData.isCreateParameters(), gd);
            this.mCreateParametersButton.setEnabled(this.mData.getSelectedSubscribedEvent() != null);
            this.mCreateParametersButton.addSelectionListener((SelectionListener)new CreateParametersSelectionListener());
        }
        this.getDisplayErrorListener().setErrorMessage("");
    }

    private boolean validatePage() {
        String error = null;
        if (this.mMode != 1) {
            error = MethodService.isNewMethodNameValid((String)this.mNameField.getText(), (Controller)this.mController);
            this.getDisplayErrorListener().setErrorMessage(error);
            if (error != null) {
                return false;
            }
        }
        if (this.mEventSourceField != null) {
            error = EventhandlerService.isNewEventSourceNameValid((String)this.mEventSourceField.getText());
            this.getDisplayErrorListener().setErrorMessage(error);
            if (error != null) {
                return false;
            }
        }
        if (this.mSubscribedEventField != null) {
            boolean valid = true;
            Vector errors = new Vector();
            if (this.mData.getSelectedSubscribedEvent() == null) {
                valid = true;
            } else if (this.mController.getEventHandler(this.mData.getName()) != null) {
                errors = ControllerChecker.areEventAndEventHandlerParameterCompatible((Event)this.mData.getSelectedSubscribedEvent(), (EventHandler)this.mController.getEventHandler(this.mData.getName()));
                if (errors != null) {
                    valid = false;
                }
            } else {
                valid = true;
            }
            if (valid) {
                this.getDisplayErrorListener().setErrorMessage(null);
            } else {
                StringBuffer errorMessage = new StringBuffer(mTextPool.getText(1040));
                Iterator it = ((AbstractList)errors).iterator();
                while (it.hasNext()) {
                    errorMessage.append(System.getProperty(LINE_SEPERATOR));
                    Object object = it.next();
                    if (!(object instanceof Parameter)) continue;
                    Parameter parameter = (Parameter)object;
                    errorMessage.append(mTextPool.getText(1041, (Object)parameter.getName(), (Object)parameter.getType().getName()));
                }
                this.getDisplayErrorListener().setErrorMessage(errorMessage.toString());
            }
        }
        return true;
    }

    public void changeMethodType() {
        this.mIsChangeMethodType = true;
        try {
            boolean isEventHandler = this.mData.getType() == 0;
            this.setEventhandlerFieldsVisible(isEventHandler);
            this.mReturnTypeField.clearSelection();
            this.mReturnTypeField.setItems(this.mData.getReturnTypeNames());
            int itemCount = this.mReturnTypeField.getItemCount();
            int selectedIndex = this.mData.getSelectedReturnTypeIndex();
            if (itemCount == 1) {
                this.mReturnTypeField.select(0);
                this.mReturnTypeField.setEnabled(false);
            } else if (itemCount > 0) {
                this.mReturnTypeField.setEnabled(true);
                if (itemCount > selectedIndex) {
                    this.mReturnTypeField.select(selectedIndex);
                } else {
                    this.mReturnTypeField.select(0);
                }
            }
            boolean isMethod = this.mData.getType() == 3;
            MetamodelServices.CompoundType compoundType = this.mData.getSelectedReturnTypeAsCompoundType();
            if (compoundType == null && this.mData.getSelectedReturnType() != null) {
                compoundType = new MetamodelServices.CompoundType(this.mData.getSelectedReturnType());
            }
            boolean isJavaNativeType = compoundType != null && compoundType.isJavaNativeType();
            this.setArraySupportEnabled(isMethod && isJavaNativeType);
            Object var8_7 = null;
            this.mIsChangeMethodType = false;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.mIsChangeMethodType = false;
            throw throwable;
        }
    }

    private void setEventhandlerFieldsVisible(boolean visible) {
        if (this.mEventSourceLabel != null) {
            this.mEventSourceLabel.setVisible(visible);
        }
        if (this.mEventSourceField != null) {
            this.mEventSourceField.setVisible(visible);
        }
        if (this.mSubscribedEventLabel != null) {
            this.mSubscribedEventLabel.setVisible(visible);
        }
        if (this.mSubscribedEventField != null) {
            this.mSubscribedEventField.setVisible(visible);
        }
        if (this.mReturnTypeSelectionButton != null) {
            this.mReturnTypeSelectionButton.setEnabled(!visible);
        }
        if (this.mCreateParametersButton != null) {
            this.mCreateParametersButton.setVisible(visible);
        }
        if (this.mEventHandlerSeparator != null) {
            this.mEventHandlerSeparator.setVisible(visible);
        }
    }

    public void setVisible(boolean visible) {
        this.mNameField.setFocus();
    }

    private boolean isArrayPossible() {
        boolean isJavaType = false;
        if (this.mData.getSelectedReturnTypeAsCompoundType() != null && this.mData.getSelectedReturnTypeAsCompoundType().isJavaNativeType()) {
            isJavaType = true;
        }
        return isJavaType;
    }

    private void setArraySupportEnabled(boolean value) {
        if (this.mArrayButton != null) {
            this.mArrayButton.setEnabled(value);
            if (!value) {
                this.mArrayButton.setSelection(false);
            }
        }
        if (this.mArrayDimensionField != null) {
            boolean isEnabled = this.mData.isArray();
            this.mArrayDimensionField.setEditable(isEnabled);
            this.mArrayDimensionField.setEnabled(isEnabled);
            this.mArrayDimensionField.setText(this.mData.getArrayDimensionString());
        }
    }

    private class ArrayDimensionModifyListener
    implements ModifyListener {
        private ArrayDimensionModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (MethodEditUI.this.mData.isArray()) {
                int value = -1;
                try {
                    value = Integer.parseInt(MethodEditUI.this.mArrayDimensionField.getText());
                }
                catch (NumberFormatException e1) {
                    MethodEditUI.super.getDisplayErrorListener().setErrorMessage(mTextPool.getText(1045));
                    return;
                }
                if (value < 1) {
                    MethodEditUI.super.getDisplayErrorListener().setErrorMessage(mTextPool.getText(1045));
                    return;
                }
                MethodEditUI.this.mData.setArrayDimension(value);
            }
            if (!MethodEditUI.this.mIsChangeMethodType && MethodEditUI.this.validatePage()) {
                MethodEditUI.super.getDisplayErrorListener().setErrorMessage(null);
            }
        }
    }

    private class ArrayButtonSelectionListener
    implements SelectionListener {
        private ArrayButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            boolean isArray = MethodEditUI.this.mArrayButton.getSelection();
            MethodEditUI.this.mData.setArray(isArray);
            MethodEditUI.this.mArrayDimensionField.setEditable(isArray);
            MethodEditUI.this.mArrayDimensionField.setEnabled(true);
            MethodEditUI.this.mArrayDimensionField.setText(MethodEditUI.this.mData.getArrayDimensionString());
        }
    }

    private class CreateParametersSelectionListener
    implements SelectionListener {
        private CreateParametersSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            MethodEditUI.this.mData.setCreateParameters(MethodEditUI.this.mCreateParametersButton.getSelection());
        }
    }

    class SubscribedEventNameModifyListener
    implements ModifyListener {
        SubscribedEventNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            MethodEditUI.this.validatePage();
            MethodEditUI.this.mData.setSelectedSubscribedEvent(MethodEditUI.this.mSubscribedEventField.getSelectionIndex());
            boolean valid = true;
            Vector errors = new Vector();
            if (MethodEditUI.this.mData.getSelectedSubscribedEvent() == null) {
                MethodEditUI.this.mCreateParametersButton.setSelection(false);
                MethodEditUI.this.mData.setCreateParameters(false);
                MethodEditUI.this.mCreateParametersButton.setEnabled(false);
            } else {
                MethodEditUI.this.mCreateParametersButton.setSelection(true);
                MethodEditUI.this.mData.setCreateParameters(true);
                MethodEditUI.this.mCreateParametersButton.setEnabled(true);
            }
        }
    }

    class EventSourceNameModifyListener
    implements ModifyListener {
        EventSourceNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            MethodEditUI.this.validatePage();
            MethodEditUI.this.mData.setSelectedEventSource(MethodEditUI.this.mEventSourceField.getSelectionIndex());
            MethodEditUI.this.mSubscribedEventField.setItems(MethodEditUI.this.mData.getSubscribedEventNames());
            boolean createParametersAllowed = MethodEditUI.this.mEventSourceField.getText().length() > 0 && MethodEditUI.this.mSubscribedEventField.getText().length() > 0;
            MethodEditUI.this.mCreateParametersButton.setSelection(createParametersAllowed);
            MethodEditUI.this.mData.setCreateParameters(createParametersAllowed);
            MethodEditUI.this.mCreateParametersButton.setEnabled(createParametersAllowed);
        }
    }

    private class ReturnTypeSelectionButtonListener
    implements SelectionListener {
        private ModifyListener mModifyListener = null;

        public ReturnTypeSelectionButtonListener(ModifyListener modifyListener) {
            this.mModifyListener = modifyListener;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            DtDictionaryRoot ddicRoot = DictionaryRootManager.getDictionaryRoot((Metamodel)MethodEditUI.this.mController.getRoot().getMetamodel());
            MetamodelServices.CompoundType type = UIHelper.selectType((DtDictionaryRoot)ddicRoot, (DevelopmentObject)MethodEditUI.this.mData.getSelectedReturnType());
            if (type != null) {
                MethodEditUI.this.mData.setSelectedReturnType(type);
                MethodEditUI.this.mReturnTypeField.setItems(MethodEditUI.this.mData.getReturnTypeNames());
                MethodEditUI.this.mReturnTypeField.removeModifyListener(this.mModifyListener);
                MethodEditUI.this.mReturnTypeField.select(MethodEditUI.this.mData.getSelectedReturnTypeIndex());
                MethodEditUI.this.mReturnTypeField.addModifyListener(this.mModifyListener);
                if (!MethodEditUI.this.isArrayPossible()) {
                    MethodEditUI.this.mData.setArray(false);
                    MethodEditUI.this.mArrayButton.setSelection(false);
                    MethodEditUI.this.mArrayButton.setEnabled(false);
                    MethodEditUI.this.mArrayDimensionField.setText(MethodEditUI.this.mData.getArrayDimensionString());
                    MethodEditUI.this.mArrayDimensionField.setEditable(false);
                } else {
                    MethodEditUI.this.mArrayButton.setEnabled(true);
                    MethodEditUI.this.mArrayDimensionField.setText(MethodEditUI.this.mData.getArrayDimensionString());
                    MethodEditUI.this.mArrayDimensionField.setEditable(true);
                }
            }
        }
    }

    class ReturnTypeModifyListener
    implements ModifyListener {
        ReturnTypeModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            MethodEditUI.this.mData.setSelectedReturnTypeIndex(MethodEditUI.this.mReturnTypeField.getSelectionIndex());
            MethodEditUI.this.mReturnTypeField.removeModifyListener((ModifyListener)this);
            MethodEditUI.this.mReturnTypeField.setItems(MethodEditUI.this.mData.getReturnTypeNames());
            MethodEditUI.this.mReturnTypeField.select(MethodEditUI.this.mData.getSelectedReturnTypeIndex());
            MethodEditUI.this.mReturnTypeField.addModifyListener((ModifyListener)this);
            if (!MethodEditUI.this.isArrayPossible()) {
                MethodEditUI.this.mData.setArray(false);
                MethodEditUI.this.mArrayButton.setSelection(false);
                MethodEditUI.this.mArrayButton.setEnabled(false);
                MethodEditUI.this.mArrayDimensionField.setText(MethodEditUI.this.mData.getArrayDimensionString());
                MethodEditUI.this.mArrayDimensionField.setEditable(false);
            } else {
                MethodEditUI.this.mArrayButton.setEnabled(true);
                MethodEditUI.this.mArrayDimensionField.setText(MethodEditUI.this.mData.getArrayDimensionString());
                MethodEditUI.this.mArrayDimensionField.setEditable(true);
            }
        }
    }

    class NameModifyListener
    implements ModifyListener {
        NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            MethodEditUI.this.validatePage();
            MethodEditUI.this.mData.setName(MethodEditUI.this.mNameField.getText());
        }
    }
}

