/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.implementation;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.repository.ControllerRepositoryManager;
import com.sap.ide.tools.core.patternfwk.editor.ISourcePatternEditor;
import com.sap.ide.webdynpro.service.controllereditor.implementation.IJavaImplementationEditor;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.actions.OpenTypeAction;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.StatusLineContributionItem;

public class JavaImplementationEditor
extends CompilationUnitEditor
implements IJavaImplementationEditor,
ISelectionChangedListener,
ISourcePatternEditor {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final String JAVA_NATURE = "org.eclipse.jdt.core.javanature";
    public static final String IMPLEMENTATION_EDITOR_RULER_CONTEXT_MENU = "#ImplementationEditorRulerContextMenu";
    private Controller mController = null;
    private boolean mCurrentlyInJavaSelectionEvent = false;
    private ImplementationTextListener mTextListener = null;
    private ImplementationKeyListener mKeyListener = null;
    private boolean mNoControllerEditorStart = false;
    private boolean mNoUpdateOfMetadata = false;
    private StatusLineContributionItem mLineNumberStatusItem = null;
    private StatusLineManager mStatusLineManager = null;

    public JavaImplementationEditor() {
        this.mNoControllerEditorStart = true;
    }

    public JavaImplementationEditor(Controller controller) {
        this.mController = controller;
    }

    protected IStatusLineManager getStatusLineManager() {
        if (this.mStatusLineManager == null) {
            this.mStatusLineManager = new StatusLineManager();
        }
        return this.mStatusLineManager;
    }

    public String getEditorContent() {
        String content = null;
        if (this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null) {
            content = this.getSourceViewer().getTextWidget().getText();
        }
        return content;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (this.mNoControllerEditorStart) {
            throw new PartInitException("ERROR: Cannot create standalone java implementation editor. This editor mut be included within a controller editor.");
        }
        if (site instanceof MultiPageEditorSite) {
            IEditorSite parentEditorSite = ((MultiPageEditorSite)site).getMultiPageEditor().getEditorSite();
            super.init(parentEditorSite, input);
        } else {
            super.init(site, input);
        }
        this.addPropertyListener(new DirtyPropertyChangedListener());
        this.setRulerContextMenuId(IMPLEMENTATION_EDITOR_RULER_CONTEXT_MENU);
    }

    public void initializeListeners() {
        if (this.mTextListener == null) {
            this.mTextListener = new ImplementationTextListener();
            this.getSourceViewer().addTextListener((ITextListener)this.mTextListener);
        }
        if (this.mKeyListener == null) {
            this.mKeyListener = new ImplementationKeyListener();
            this.getSourceViewer().getTextWidget().addKeyListener((KeyListener)this.mKeyListener);
        }
    }

    public boolean isEditable() {
        return super.isEditable() && !this.mController.isReadOnly();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.mCurrentlyInJavaSelectionEvent && this.getSelectionProvider() != null) {
            this.doSelectionChanged(event);
        }
    }

    public void synchronizeOutlinePageSelection() {
        this.mCurrentlyInJavaSelectionEvent = true;
        super.synchronizeOutlinePageSelection();
        this.mCurrentlyInJavaSelectionEvent = false;
    }

    public DevelopmentObject getObjectToEdit() {
        return this.mController;
    }

    public boolean enableSourcePatternWizardAction() {
        return true;
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public void setNoUpdateOfMetadata(boolean value) {
        this.mNoUpdateOfMetadata = value;
    }

    public void dispose() {
        super.dispose();
        if (this.mTextListener != null && this.getSourceViewer() != null) {
            this.getSourceViewer().removeTextListener((ITextListener)this.mTextListener);
        }
        if (this.mKeyListener != null && this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null) {
            this.getSourceViewer().getTextWidget().removeKeyListener((KeyListener)this.mKeyListener);
        }
    }

    protected void createActions() {
        super.createActions();
        OpenTypeAction action = new OpenTypeAction();
        action.setActionDefinitionId("org.eclipse.jdt.ui.navigate.open.type");
        this.setAction("openType", (IAction)action);
    }

    public ICompilationUnit getCompilationUnit() {
        FileEditorInput fileEditorInput;
        IJavaElement javaElement;
        ICompilationUnit unit = null;
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput && (javaElement = JavaCore.create((IFile)(fileEditorInput = (FileEditorInput)editorInput).getFile())) instanceof ICompilationUnit) {
            unit = (ICompilationUnit)javaElement;
        }
        return unit;
    }

    public void setFocus() {
        this.updateState(this.getEditorInput());
        super.setFocus();
    }

    protected void handleEditorInputChanged() {
    }

    protected void handleExceptionOnSave(CoreException exception, IProgressMonitor progressMonitor) {
        this.performSaveOperation(this.createSaveOperation(true), progressMonitor);
    }

    private class ImplementationKeyListener
    implements KeyListener {
        private ImplementationKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            MMRepositoryObject[] repositoryObjects;
            if (JavaImplementationEditor.this.mController.isReadOnly() && (!Character.isISOControl(e.character) || e.character == '\r' || e.character == '\b') && RepositoryServices.checkWriteability((MMRepositoryObject[])(repositoryObjects = new MMRepositoryObject[]{ControllerRepositoryManager.getRepositioryObject((Controller)JavaImplementationEditor.this.mController, (boolean)false)}))) {
                JavaImplementationEditor.super.updateState(JavaImplementationEditor.this.getEditorInput());
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    private class ImplementationTextListener
    implements ITextListener {
        private ImplementationTextListener() {
        }

        public void textChanged(TextEvent event) {
            if (JavaImplementationEditor.this.mNoUpdateOfMetadata || JavaImplementationEditor.this.mController.isReadOnly()) {
                return;
            }
            String content = JavaImplementationEditor.this.getEditorContent();
            if (content != null) {
                JavaImplementationEditor.this.mController.setCodeBody(content);
            }
        }
    }

    private class DirtyPropertyChangedListener
    implements IPropertyListener {
        private DirtyPropertyChangedListener() {
        }

        public void propertyChanged(Object source, int propId) {
            String content;
            if (propId == 257 && JavaImplementationEditor.this.isDirty() && (content = JavaImplementationEditor.this.getEditorContent()) != null && !JavaImplementationEditor.this.mController.isReadOnly()) {
                JavaImplementationEditor.this.mController.setCodeBody(content);
            }
        }
    }
}

