/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.fieldgroups;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.base.Validator;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.FieldGroup;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableModel;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.fieldgroups.FieldEditDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.fieldgroup.CreateFieldWizardDialog;
import com.sap.ide.webdynpro.service.controllereditor.fieldgroup.FieldGroupService;
import com.sap.ide.webdynpro.service.core.UIHelper;

public class FieldsTableModel
extends AbstractControllerTableModel {
    private static final int NUMBER_OF_COLUMNS = 2;
    private static final String[] COLUMN_NAMES = new String[]{AbstractControllerTableModel.mTextPool.getText(44), AbstractControllerTableModel.mTextPool.getText(45)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = FieldsTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = FieldsTableModel.class$("java.lang.String")) : class$java$lang$String};
    private static final int COLUMN_CONTEXT_ATTRIBUTE = 0;
    private static final int COLUMN_PARAMETER = 1;
    private ContextAttribute[] mAttributes = null;
    private FieldGroup mSelectedParent = null;
    static /* synthetic */ Class class$java$lang$String;

    public FieldsTableModel(Controller controller) {
        super(controller);
        this.setNumberOfColumns(2);
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.updateDataTable();
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 | index > this.mAttributes.length) {
            return null;
        }
        return this.mAttributes[index];
    }

    protected void masterObjectChanged(DevelopmentObject newMasterObject) {
        if (newMasterObject instanceof FieldGroup) {
            this.mSelectedParent = (FieldGroup)newMasterObject;
            this.mSelectionIndexes = new int[0];
        } else {
            this.mSelectedParent = null;
            this.mSelectionIndexes = new int[0];
        }
        super.masterObjectChanged(newMasterObject);
    }

    protected void updateDataTable() {
        FieldGroup fieldGroup;
        this.mAttributes = this.mSelectedParent == null ? new ContextAttribute[0] : ((fieldGroup = this.mSelectedParent) == null ? new ContextAttribute[0] : fieldGroup.getAttributes());
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        if (this.mAttributes == null) {
            return 0;
        }
        return this.mAttributes.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mAttributes == null) {
            return AbstractControllerTableModel.ERROR;
        }
        if (rowIndex >= this.mAttributes.length) {
            return AbstractControllerTableModel.ERROR;
        }
        ContextAttribute attribute = this.mAttributes[rowIndex];
        if (attribute == null) {
            return AbstractControllerTableModel.ERROR;
        }
        switch (columnIndex) {
            case 0: {
                return attribute.getName();
            }
            case 1: {
                FieldGroup fieldGroup = this.mSelectedParent;
                if (fieldGroup == null) {
                    return AbstractControllerTableModel.ERROR;
                }
                Validator validator = fieldGroup.getValidator();
                if (validator == null) {
                    return AbstractControllerTableModel.ERROR;
                }
                Parameter[] parameters = validator.getParameters();
                if (rowIndex >= parameters.length) {
                    return AbstractControllerTableModel.ERROR;
                }
                return parameters[rowIndex].getName();
            }
        }
        return AbstractControllerTableModel.ERROR;
    }

    protected void doCopy(MetamodelClipboard clipboard, int[] indexes) {
    }

    protected void doPaste(MetamodelClipboard clipboard) {
    }

    protected boolean canPaste(MetamodelClipboard clipboard) {
        return false;
    }

    protected void doRename(int[] indexes) {
    }

    protected void doDelete(int[] indexes) {
        ContextAttribute[] fields = this.getIndexesFields(indexes);
        boolean userSaidDeleteAll = false;
        int result = -1;
        int i = 0;
        while (i < fields.length) {
            ContextAttribute field = fields[i];
            MMRepositoryObject[] repositoryObjects = FieldGroupService.getRepositoryObjectsAffectedByFieldDeletion((ContextAttribute)field);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            if (this.mSelectedParent == null) {
                return;
            }
            FieldGroup fieldGroup = this.mSelectedParent;
            if (!userSaidDeleteAll && (result = UIHelper.askUserToDeleteAll((String)field.getName(), (String)AbstractControllerTableModel.mTextPool.getText(15))) == 1) {
                userSaidDeleteAll = true;
                result = 0;
            }
            if (result == 0) {
                Validator validator = fieldGroup.getValidator();
                Parameter parameter = validator.getParameter(field.getName());
                try {
                    parameter.delete();
                }
                catch (DeleteException e) {
                    Plugin.internalError(this.getClass(), "doDelete(int)", e.getMessage(), e, false);
                    return;
                }
                fieldGroup.removeAttribute(field);
            }
            ++i;
        }
    }

    protected void doEdit(int[] indexes) {
        ContextAttribute[] fields = this.getIndexesFields(indexes);
        int i = 0;
        while (i < fields.length) {
            ContextAttribute attribute = fields[i];
            MMRepositoryObject[] repositoryObjects = FieldGroupService.getRepositoryObjectsAffectedByFieldModification((ContextAttribute)attribute);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            if (this.mSelectedParent == null) {
                return;
            }
            FieldGroup fieldGroup = this.mSelectedParent;
            Parameter parameter = FieldGroupService.getValidatorParameterForField((FieldGroup)fieldGroup, (ContextAttribute)attribute);
            FieldEditDialog dialog = new FieldEditDialog(attribute, parameter, 1, this.getController());
            if (dialog.open() == 0) {
                if (!attribute.equals(dialog.getNewContextAttribute())) {
                    // empty if block
                }
                if (!parameter.getName().equals(dialog.getNewParameterName())) {
                    // empty if block
                }
            }
            ++i;
        }
    }

    protected void doNew() {
        if (this.mSelectedParent == null) {
            return;
        }
        MMRepositoryObject[] repositoryObjects = FieldGroupService.getRepositoryObjectsAffectedByFieldCreation((FieldGroup)this.mSelectedParent);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        FieldGroup fieldGroup = this.mSelectedParent;
        CreateFieldWizardDialog dialog = new CreateFieldWizardDialog(fieldGroup, this.getController());
        dialog.open();
        dialog.close();
    }

    public boolean isCopyable(int[] indexes) {
        return false;
    }

    public boolean isEditable(int[] indexes) {
        return false;
    }

    protected boolean isReadOnly() {
        return this.getController().originatesInArchive() || !this.isModifiedParentObjectRelevant((DevelopmentObject)this.mSelectedParent);
    }

    protected boolean isEventRelevant(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof ContextAttribute) {
            switch (event.getEventId()) {
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 64: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    protected boolean isModifiedParentObjectRelevant(DevelopmentObject object) {
        return object instanceof FieldGroup;
    }

    private ContextAttribute[] getIndexesFields(int[] indexes) {
        ContextAttribute[] fields = new ContextAttribute[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            fields[i] = this.mAttributes[indexes[i]];
            ++i;
        }
        return fields;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

