/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.fieldgroups;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.FieldGroup;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableModel;
import com.sap.ide.webdynpro.controllereditor.wizards.fieldgroup.CreateFieldGroupWizardDialog;
import com.sap.ide.webdynpro.service.controllereditor.fieldgroup.FieldGroupService;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectNameComparator;
import com.sap.ide.webdynpro.service.core.UIHelper;
import java.util.Arrays;

public class FieldGroupsTableModel
extends AbstractControllerTableModel {
    private static final int NUMBER_OF_COLUMNS = 2;
    private static final String[] COLUMN_NAMES = new String[]{AbstractControllerTableModel.mTextPool.getText(42), AbstractControllerTableModel.mTextPool.getText(43)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = FieldGroupsTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = FieldGroupsTableModel.class$("java.lang.String")) : class$java$lang$String};
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_VALIDATOR = 1;
    private FieldGroup[] mFieldGroups = null;
    static /* synthetic */ Class class$java$lang$String;

    public FieldGroupsTableModel(Controller controller) {
        super(controller);
        this.setNumberOfColumns(2);
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.updateDataTable();
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 | index > this.mFieldGroups.length) {
            return null;
        }
        return this.mFieldGroups[index];
    }

    protected void masterObjectChanged(DevelopmentObject newMasterObject) {
        super.masterObjectChanged(newMasterObject);
    }

    protected void updateDataTable() {
        if (this.getController() != null) {
            this.mFieldGroups = this.getController().getFieldGroups();
            Arrays.sort(this.mFieldGroups, new DevelopmentObjectNameComparator());
        }
    }

    public int getRowCount() {
        if (this.mFieldGroups == null) {
            return 0;
        }
        return this.mFieldGroups.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mFieldGroups.length <= rowIndex) {
            return AbstractControllerTableModel.ERROR;
        }
        FieldGroup fieldGroup = this.mFieldGroups[rowIndex];
        if (fieldGroup == null) {
            return AbstractControllerTableModel.ERROR;
        }
        switch (columnIndex) {
            case 0: {
                return fieldGroup.getName();
            }
            case 1: {
                if (fieldGroup.getValidator() == null) {
                    return AbstractControllerTableModel.ERROR;
                }
                return fieldGroup.getValidator().getName();
            }
        }
        return AbstractControllerTableModel.ERROR;
    }

    protected void doCopy(MetamodelClipboard clipboard, int[] indexes) {
    }

    protected void doPaste(MetamodelClipboard clipboard) {
    }

    protected boolean canPaste(MetamodelClipboard clipboard) {
        return false;
    }

    protected void doRename(int[] indexes) {
    }

    protected void doDelete(int[] indexes) {
        FieldGroup[] fieldGroups = this.getIndexesFieldGroups(indexes);
        boolean userSaidDeleteAll = false;
        int result = -1;
        int i = 0;
        while (i < fieldGroups.length) {
            FieldGroup fieldGroup = fieldGroups[i];
            MMRepositoryObject[] repositoryObjects = FieldGroupService.getRepositoryObjectsAffectedByFieldGroupDeletion((FieldGroup)fieldGroup);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            if (!userSaidDeleteAll && (result = UIHelper.askUserToDeleteAll((String)fieldGroup.getName(), (String)AbstractControllerTableModel.mTextPool.getText(14))) == 1) {
                userSaidDeleteAll = true;
                result = 0;
            }
            if (result == 0) {
                FieldGroupService.deleteFieldGroup((FieldGroup)fieldGroup);
            }
            ++i;
        }
    }

    protected void doEdit(int[] indexes) {
    }

    protected void doNew() {
        MMRepositoryObject[] repositoryObjects = FieldGroupService.getRepositoryObjectsAffectedByFieldGroupCreation((Controller)this.getController());
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        CreateFieldGroupWizardDialog dialog = new CreateFieldGroupWizardDialog(this.getController());
        dialog.open();
        dialog.close();
    }

    public boolean isEditable(int[] indexes) {
        return false;
    }

    protected boolean isReadOnly() {
        return this.getController().originatesInArchive();
    }

    protected boolean isEventRelevant(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof FieldGroup) {
            switch (event.getEventId()) {
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 64: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private FieldGroup[] getIndexesFieldGroups(int[] indexes) {
        FieldGroup[] groups = new FieldGroup[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            groups[i] = this.mFieldGroups[indexes[i]];
            ++i;
        }
        return groups;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

