/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.fieldgroups;

import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.EditUI;
import com.sap.ide.webdynpro.controllereditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.controllereditor.wizards.fieldgroup.CreateFieldGroupWizardData;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.fieldgroup.FieldGroupService;
import com.sap.ide.webdynpro.service.controllereditor.method.MethodService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class FieldGroupEditUI
extends EditUI {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    private Controller mController = null;
    private CreateFieldGroupWizardData mData = null;
    private int mMode;
    private Text mNameField = null;
    private Text mValidatorNameField = null;

    public FieldGroupEditUI(CreateFieldGroupWizardData data, int mode, Controller controller, IDisplayErrorListener displayErrorListener) {
        super(displayErrorListener);
        this.mData = data;
        this.mMode = mode;
        this.mController = controller;
    }

    public void initUI(IGridLayoutPane glp) {
        glp.addTextLabel(mTextPool.getText(120));
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, false);
        this.mNameField = glp.addTextField(this.mData.getName(), this.mMode == 1, gd);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        this.mNameField.setFocus();
        glp.addTextLabel(mTextPool.getText(121));
        gd = glp.createGridLayoutData(4, 4, true, false);
        this.mValidatorNameField = glp.addTextField(this.mData.getValidatorName(), true, gd);
        this.mValidatorNameField.addModifyListener((ModifyListener)new ValidatorNameModifyListener());
        this.getDisplayErrorListener().setErrorMessage("");
    }

    public void setVisible(boolean visible) {
        this.mNameField.setFocus();
    }

    private boolean validatePage() {
        String error = null;
        boolean errorOccured = false;
        if (this.mMode != 1) {
            error = FieldGroupService.isNewFieldGroupNameValid((String)this.mNameField.getText(), (Controller)this.mController);
            this.getDisplayErrorListener().setErrorMessage(error);
            if (error != null) {
                errorOccured = true;
            }
        }
        error = MethodService.isNewValidatorNameValid((String)this.mValidatorNameField.getText(), (Controller)this.mController);
        this.getDisplayErrorListener().setErrorMessage(error);
        if (error == null) {
            errorOccured = true;
        }
        return errorOccured;
    }

    class ValidatorNameModifyListener
    implements ModifyListener {
        ValidatorNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            FieldGroupEditUI.this.validatePage();
            FieldGroupEditUI.this.mData.setValidatorName(FieldGroupEditUI.this.mValidatorNameField.getText());
        }
    }

    class NameModifyListener
    implements ModifyListener {
        NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            FieldGroupEditUI.this.validatePage();
            FieldGroupEditUI.this.mData.setName(FieldGroupEditUI.this.mNameField.getText());
            FieldGroupEditUI.this.mData.setValidatorName("validate" + FieldGroupEditUI.this.mNameField.getText());
            FieldGroupEditUI.this.mValidatorNameField.setText(FieldGroupEditUI.this.mData.getValidatorName());
        }
    }
}

