/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.fieldgroups;

import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.EditUI;
import com.sap.ide.webdynpro.controllereditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.controllereditor.wizards.fieldgroup.CreateFieldWizardData;
import com.sap.ide.webdynpro.service.controllereditor.ServiceWithUI;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import com.sap.ide.webdynpro.service.controllereditor.fieldgroup.FieldGroupService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionValidator;

public class FieldEditUI
extends EditUI {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    private Controller mController = null;
    private CreateFieldWizardData mData = null;
    private int mMode;
    private Text mContextAttributeNameField = null;
    private Text mParameterNameField = null;
    private Button mContextAttributeNameButton = null;

    public FieldEditUI(CreateFieldWizardData data, int mode, Controller controller, IDisplayErrorListener displayErrorListener) {
        super(displayErrorListener);
        this.mData = data;
        this.mMode = mode;
        this.mController = controller;
    }

    public void initUI(IGridLayoutPane glp) {
        glp.addTextLabel(mTextPool.getText(90));
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, false);
        this.mContextAttributeNameField = glp.addTextField(this.mData.getContextAttributeName(), true, gd);
        this.mContextAttributeNameButton = glp.addPushButton(mTextPool.getText(537));
        if (this.mMode == 1) {
            this.mContextAttributeNameButton.setEnabled(false);
        }
        this.mContextAttributeNameButton.addSelectionListener((SelectionListener)new ContextAttributeButtonSelectionListener());
        glp.addTextLabel(mTextPool.getText(91));
        gd = glp.createGridLayoutData(4, 4, true, false);
        this.mParameterNameField = glp.addTextField(this.mData.getParameterName(), false, gd);
        this.mParameterNameField.addModifyListener((ModifyListener)new ParameterNameModifyListener());
        this.mParameterNameField.setFocus();
        glp.addPlaceholder();
        this.getDisplayErrorListener().setErrorMessage("");
    }

    private boolean validatePage() {
        String error = null;
        if (this.mMode != 1) {
            error = FieldGroupService.isNewFieldNameValid((String)this.mParameterNameField.getText());
            this.getDisplayErrorListener().setErrorMessage(error);
        }
        return error == null;
    }

    public void setVisible(boolean visible) {
        this.mParameterNameField.setFocus();
    }

    private class ContextAttributeButtonSelectionListener
    implements SelectionListener {
        private ContextAttributeButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            ContextElement element = ServiceWithUI.selectContextElement((ContextNode)FieldEditUI.this.mController.getContext(), (ISelectionValidator)ContextService.FILTER_CONTEXT_ATTRIBUTES);
            if (element != null) {
                FieldEditUI.this.mData.setContextAttribute(element);
                FieldEditUI.this.mContextAttributeNameField.setText(element.getName());
                FieldEditUI.this.mData.setParameterName(element.getName());
                FieldEditUI.this.mParameterNameField.setText(element.getName());
            }
        }
    }

    class ParameterNameModifyListener
    implements ModifyListener {
        ParameterNameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            FieldEditUI.this.validatePage();
            FieldEditUI.this.mData.setParameterName(FieldEditUI.this.mParameterNameField.getText());
        }
    }
}

