/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.eventhandlers;

import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.base.Procedure;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.EditUI;
import com.sap.ide.webdynpro.controllereditor.IDialogWithButtonAccess;
import com.sap.ide.webdynpro.controllereditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.controllereditor.eventhandlers.EventHandlerSubObjectData;
import com.sap.ide.webdynpro.controllereditor.wizards.method.CreateMethodWizardDialog;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.eventhandler.EventhandlerService;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class EventHandlerSubObjectEditUI
extends EditUI {
    private static final TextPool mTextPool = TextPool.getInstance();
    private IDialogWithButtonAccess mDialog = null;
    private RadioButtonSelectionListener mRadioButtonSelectionListener = new RadioButtonSelectionListener();
    private Controller mController = null;
    private EventHandlerSubObjectData mData = null;
    private int mMode = -1;
    private Button mRadioButtonUseDefault = null;
    private Button mRadioButtonUseExisting = null;
    private Button mRadioButtonUseNone = null;
    private Text mDefaultEventHandlerNameField = null;
    private Combo mExistingEventHandlerNameCombo = null;
    private Button mCreateNewEventHandlerButton = null;
    private boolean mUseNoneIsPossible = true;

    public EventHandlerSubObjectEditUI(Controller controller, EventHandlerSubObjectData data, int mode, IDisplayErrorListener displayErrorListener, IDialogWithButtonAccess dialog) {
        this(controller, data, mode, displayErrorListener, true, dialog);
    }

    public EventHandlerSubObjectEditUI(Controller controller, EventHandlerSubObjectData data, int mode, IDisplayErrorListener displayErrorListener, boolean useNoneIsPossible, IDialogWithButtonAccess dialog) {
        super(displayErrorListener);
        this.mController = controller;
        this.mData = data;
        this.mMode = mode;
        this.mUseNoneIsPossible = useNoneIsPossible;
        this.mDialog = dialog;
    }

    public void initUI(IGridLayoutPane glp, int colSpan) {
        IGridLayoutData gd = glp.createGridLayoutData(4, 1, true, false, colSpan, 1);
        IGridLayoutPane pane = glp.addGridLayoutPane(mTextPool.getText(900), 3, gd);
        if (this.mMode != 1) {
            gd = glp.createGridLayoutData(1, 1, false, false);
            this.mRadioButtonUseDefault = pane.addRadioButton("", gd);
            this.mRadioButtonUseDefault.addSelectionListener((SelectionListener)this.mRadioButtonSelectionListener);
            this.mRadioButtonUseDefault.setSelection(true);
            gd = glp.createGridLayoutData(4, 1, true, false);
            pane.addTextLabel(mTextPool.getText(166), gd);
            pane.addPlaceholder();
            pane.addPlaceholder();
            gd = glp.createGridLayoutData(4, 1, true, false);
            this.mDefaultEventHandlerNameField = pane.addTextField(this.mData.getDefaultEventHandlerName(), true, gd);
            pane.addPlaceholder();
        }
        gd = glp.createGridLayoutData(1, 1, false, false);
        this.mRadioButtonUseExisting = pane.addRadioButton("", gd);
        this.mRadioButtonUseExisting.addSelectionListener((SelectionListener)this.mRadioButtonSelectionListener);
        if (this.mData.getSelectedEventHandler() != null) {
            this.mRadioButtonUseExisting.setSelection(true);
        }
        gd = glp.createGridLayoutData(4, 1, true, false);
        Label useExistingLabel = pane.addTextLabel(mTextPool.getText(167), gd);
        pane.addPlaceholder();
        pane.addPlaceholder();
        gd = glp.createGridLayoutData(4, 1, true, false);
        this.mExistingEventHandlerNameCombo = pane.addComboBox(this.mData.getEventHandlerNames(), this.mData.getSelectedEventHandlerName(), true, gd);
        this.mExistingEventHandlerNameCombo.addSelectionListener((SelectionListener)new ExistingEventHandlerComboSelectionListener());
        this.mCreateNewEventHandlerButton = pane.addPushButton(mTextPool.getText(0));
        this.mCreateNewEventHandlerButton.addSelectionListener((SelectionListener)new NewEventHandlerButtonSelectionListener());
        if (this.mMode == 1 && !this.mUseNoneIsPossible) {
            this.mRadioButtonUseExisting.setSelection(true);
            this.mRadioButtonUseExisting.setVisible(false);
            useExistingLabel.setVisible(false);
        }
        if (this.mUseNoneIsPossible) {
            gd = glp.createGridLayoutData(1, 1, false, false);
            this.mRadioButtonUseNone = pane.addRadioButton("", gd);
            this.mRadioButtonUseNone.addSelectionListener((SelectionListener)this.mRadioButtonSelectionListener);
            if (this.mMode == 1 && this.mData.getSelectedEventHandler() == null) {
                this.mRadioButtonUseNone.setSelection(true);
            }
            gd = glp.createGridLayoutData(4, 1, true, false);
            pane.addTextLabel(mTextPool.getText(168), gd);
            pane.addPlaceholder();
        }
        this.mExistingEventHandlerNameCombo.setEnabled(this.mRadioButtonUseExisting.getSelection());
        this.mCreateNewEventHandlerButton.setEnabled(this.mRadioButtonUseExisting.getSelection());
        if (this.mRadioButtonUseDefault != null && this.mRadioButtonUseDefault.getSelection()) {
            this.mData.setSelectionType(0);
        } else if (this.mRadioButtonUseExisting.getSelection()) {
            this.mData.setSelectionType(1);
        } else if (this.mRadioButtonUseNone != null && this.mRadioButtonUseNone.getSelection()) {
            this.mData.setSelectionType(2);
        }
    }

    public void setDefaultEventHandlerName(String name) {
        this.mDefaultEventHandlerNameField.setText(name);
        this.mData.setDefaultEventHandlerName(name);
    }

    public Combo getExistingEventHandlerCombo() {
        return this.mExistingEventHandlerNameCombo;
    }

    private class ExistingEventHandlerComboSelectionListener
    implements SelectionListener {
        private ExistingEventHandlerComboSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            EventHandlerSubObjectEditUI.this.mData.setSelectedEventHandler(EventHandlerSubObjectEditUI.this.mExistingEventHandlerNameCombo.getSelectionIndex());
        }
    }

    private class NewEventHandlerButtonSelectionListener
    implements SelectionListener {
        private NewEventHandlerButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Button) {
                CreateMethodWizardDialog dialog = new CreateMethodWizardDialog(EventHandlerSubObjectEditUI.this.mController);
                dialog.setMethodType(0);
                dialog.open();
                Procedure procedure = dialog.getNewProcedure();
                if (procedure instanceof EventHandler) {
                    EventHandler eventHandler = (EventHandler)procedure;
                    EventHandlerSubObjectEditUI.this.mData.setSelectedEventHandler(eventHandler);
                    EventHandlerSubObjectEditUI.this.mExistingEventHandlerNameCombo.setItems(EventHandlerSubObjectEditUI.this.mData.getEventHandlerNames());
                    EventHandlerSubObjectEditUI.this.mExistingEventHandlerNameCombo.select(EventHandlerSubObjectEditUI.this.mData.getSelectedEventHandlerIndex());
                    if (eventHandler != null) {
                        EventHandlerSubObjectEditUI.super.getDisplayErrorListener().setErrorMessage(null);
                    }
                    if (EventHandlerSubObjectEditUI.this.mDialog != null && EventHandlerSubObjectEditUI.this.mDialog.getFinishButton() != null) {
                        EventHandlerSubObjectEditUI.this.mDialog.getFinishButton().setFocus();
                    }
                }
                dialog.close();
            }
        }
    }

    private class RadioButtonSelectionListener
    implements SelectionListener {
        private RadioButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Button) {
                Button button = (Button)e.widget;
                if (button.equals(EventHandlerSubObjectEditUI.this.mRadioButtonUseDefault)) {
                    EventHandlerSubObjectEditUI.this.mExistingEventHandlerNameCombo.setEnabled(false);
                    EventHandlerSubObjectEditUI.this.mCreateNewEventHandlerButton.setEnabled(false);
                    EventHandlerSubObjectEditUI.this.mData.setSelectionType(0);
                    EventHandlerSubObjectEditUI.super.getDisplayErrorListener().setErrorMessage(EventhandlerService.isNewEventHandlerNameValid((String)EventHandlerSubObjectEditUI.this.mData.getEventHandlerName(), (Controller)EventHandlerSubObjectEditUI.this.mController));
                } else if (button.equals(EventHandlerSubObjectEditUI.this.mRadioButtonUseExisting)) {
                    EventHandlerSubObjectEditUI.this.mExistingEventHandlerNameCombo.setEnabled(true);
                    EventHandlerSubObjectEditUI.this.mCreateNewEventHandlerButton.setEnabled(true);
                    EventHandlerSubObjectEditUI.this.mData.setSelectionType(1);
                    if (EventHandlerSubObjectEditUI.this.mData.getSelectedEventHandlerIndex() == -1) {
                        if (EventHandlerSubObjectEditUI.this.mData.getEventHandlerNames().length > 0) {
                            EventHandlerSubObjectEditUI.this.mData.setSelectedEventHandler(0);
                            EventHandlerSubObjectEditUI.this.mExistingEventHandlerNameCombo.select(0);
                            EventHandlerSubObjectEditUI.super.getDisplayErrorListener().setErrorMessage(null);
                        } else {
                            EventHandlerSubObjectEditUI.super.getDisplayErrorListener().setErrorMessage(mTextPool.getText(1034));
                        }
                    }
                } else if (button.equals(EventHandlerSubObjectEditUI.this.mRadioButtonUseNone)) {
                    EventHandlerSubObjectEditUI.this.mExistingEventHandlerNameCombo.setEnabled(false);
                    EventHandlerSubObjectEditUI.this.mCreateNewEventHandlerButton.setEnabled(false);
                    EventHandlerSubObjectEditUI.this.mData.setSelectionType(2);
                }
            }
        }
    }
}

