/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.eventhandlers;

import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;

public class EventHandlerSubObjectData {
    public static final int SELECTION_TYPE_DEFAULT = 0;
    public static final int SELECTION_TYPE_SELECTED = 1;
    public static final int SELECTION_TYPE_NONE = 2;
    private Controller mController = null;
    private int mSelectedEventHandler = -1;
    private String mDefaultEventHandlerName = "";
    private int mSelectionType = 0;

    public EventHandlerSubObjectData(Controller controller) {
        this.mController = controller;
    }

    public void setSelectionType(int type) {
        this.mSelectionType = type;
        switch (type) {
            case 0: {
                this.setSelectedEventHandler(-1);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public String getDefaultEventHandlerName() {
        return this.mDefaultEventHandlerName;
    }

    public void setDefaultEventHandlerName(String eventHandlerName) {
        this.mDefaultEventHandlerName = eventHandlerName;
    }

    public String[] getEventHandlerNames() {
        EventHandler[] eventHandlers = this.mController.getEventHandlers();
        String[] names = new String[eventHandlers.length];
        int i = 0;
        while (i < names.length) {
            names[i] = eventHandlers[i].getName();
            ++i;
        }
        return names;
    }

    public String getSelectedEventHandlerName() {
        if (this.mSelectedEventHandler != -1) {
            return this.mController.getEventHandlers()[this.mSelectedEventHandler].getName();
        }
        return "";
    }

    public EventHandler getSelectedEventHandler() {
        if (this.mSelectedEventHandler != -1) {
            return this.mController.getEventHandlers()[this.mSelectedEventHandler];
        }
        return null;
    }

    public int getSelectedEventHandlerIndex() {
        return this.mSelectedEventHandler;
    }

    public String getEventHandlerName() {
        switch (this.mSelectionType) {
            case 0: {
                return this.getDefaultEventHandlerName();
            }
            case 1: {
                return this.getSelectedEventHandlerName();
            }
            case 2: {
                return null;
            }
        }
        return null;
    }

    public void setSelectedEventHandler(EventHandler eventHandler) {
        if (eventHandler == null) {
            this.mSelectedEventHandler = -1;
        } else {
            EventHandler[] eventHandlers = this.mController.getEventHandlers();
            int i = 0;
            while (i < eventHandlers.length) {
                if (eventHandler.equals(eventHandlers[i])) {
                    this.mSelectedEventHandler = i;
                    return;
                }
                ++i;
            }
            this.mSelectedEventHandler = -1;
        }
    }

    public void setSelectedEventHandler(int index) {
        this.mSelectedEventHandler = index;
    }
}

