/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.customevents;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectEnum;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.webdynpro.WebDynproDevelopmentObjectEnum;
import com.sap.ide.metamodel.webdynpro.base.CustomEvent;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.AbstractControllerTableModel;
import com.sap.ide.webdynpro.controllereditor.wizards.event.CreateEventWizardDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.event.RenameEventWizard;
import com.sap.ide.webdynpro.service.controllereditor.ControllerPasteManager;
import com.sap.ide.webdynpro.service.controllereditor.event.EventService;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectNameComparator;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardDialog;
import java.util.Arrays;

public class EventsTableModel
extends AbstractControllerTableModel {
    private static final int NUMBER_OF_COLUMNS = 1;
    private static final String[] COLUMN_NAMES = new String[]{AbstractControllerTableModel.mTextPool.getText(39)};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EventsTableModel.class$("java.lang.String")) : class$java$lang$String};
    private static final int COLUMN_NAME = 0;
    private CustomEvent[] mEvents = null;
    static /* synthetic */ Class class$java$lang$String;

    public EventsTableModel(Controller controller) {
        super(controller);
        this.setNumberOfColumns(1);
        this.setColumnNames(COLUMN_NAMES);
        this.setColumnClasses(COLUMN_CLASSES);
        this.updateDataTable();
    }

    public DevelopmentObject getDataTableEntry(int index) {
        if (index < 0 | index > this.mEvents.length) {
            return null;
        }
        return this.mEvents[index];
    }

    protected void masterObjectChanged(DevelopmentObject newMasterObject) {
        super.masterObjectChanged(newMasterObject);
    }

    protected void updateDataTable() {
        if (this.getController() != null) {
            this.mEvents = this.getController().getEvents();
            Arrays.sort(this.mEvents, new DevelopmentObjectNameComparator());
        }
    }

    public int getRowCount() {
        if (this.mEvents == null) {
            return 0;
        }
        return this.mEvents.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mEvents == null) {
            return AbstractControllerTableModel.ERROR;
        }
        CustomEvent event = this.mEvents[rowIndex];
        if (event == null) {
            return AbstractControllerTableModel.ERROR;
        }
        switch (columnIndex) {
            case 0: {
                return event.getName();
            }
        }
        return AbstractControllerTableModel.ERROR;
    }

    protected void doNew() {
        MMRepositoryObject[] repositoryObjects = EventService.getRepositoryObjectsAffectedByEventCreation((Controller)this.getController());
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        CreateEventWizardDialog dialog = new CreateEventWizardDialog(this.getController());
        dialog.open();
        dialog.close();
    }

    protected void doRename(int[] indexes) {
        CustomEvent[] events = this.getIndexesEvents(indexes);
        int i = 0;
        while (i < events.length) {
            CustomEvent event = events[i];
            MMRepositoryObject[] repositoryObjects = EventService.getRepositoryObjectsAffectedByEventModification((CustomEvent)event);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            RenameEventWizard renameWizard = new RenameEventWizard((DevelopmentObject)event);
            RenameWizardDialog wizardDialog = new RenameWizardDialog((RenameWizard)renameWizard);
            wizardDialog.open();
            wizardDialog.close();
            ++i;
        }
    }

    protected void doDelete(int[] indexes) {
        CustomEvent[] events = this.getIndexesEvents(indexes);
        boolean userSaidDeleteAll = false;
        int result = -1;
        int i = 0;
        while (i < events.length) {
            CustomEvent event = events[i];
            MMRepositoryObject[] repositoryObjects = EventService.getRepositoryObjectsAffectedByEventDeletion((CustomEvent)event);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            if (!userSaidDeleteAll && (result = UIHelper.askUserToDeleteAll((String)event.getName(), (String)AbstractControllerTableModel.mTextPool.getText(12))) == 1) {
                userSaidDeleteAll = true;
                result = 0;
            }
            if (result == 0) {
                EventService.deleteEvent((CustomEvent)event);
            }
            ++i;
        }
    }

    protected void doEdit(int[] indexes) {
    }

    protected void doCopy(MetamodelClipboard clipboard, int[] indexes) {
        CustomEvent[] events = this.getIndexesEvents(indexes);
        clipboard.copy((DevelopmentObject[])events);
    }

    protected void doPaste(MetamodelClipboard clipboard) {
        MMRepositoryObject[] repositoryObjects = EventService.getRepositoryObjectsAffectedByEventCreation((Controller)this.getController());
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        ControllerPasteManager controllerPasteManager = new ControllerPasteManager();
        controllerPasteManager.paste(clipboard, (MetamodelObject)this.getController());
    }

    protected boolean canPaste(MetamodelClipboard clipboard) {
        DevelopmentObjectEnum[] objects = clipboard.getContentTypes();
        int i = 0;
        while (i < objects.length) {
            if (!objects[i].equals(WebDynproDevelopmentObjectEnum.CUSTOMEVENT)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEditable(int[] indexes) {
        return false;
    }

    protected boolean isReadOnly() {
        return this.getController().originatesInArchive();
    }

    protected boolean isEventRelevant(MetamodelEvent event) {
        if (event.getModifiedObject() instanceof CustomEvent) {
            switch (event.getEventId()) {
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 64: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private CustomEvent[] getIndexesEvents(int[] indexes) {
        CustomEvent[] events = new CustomEvent[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            events[i] = this.mEvents[indexes[i]];
            ++i;
        }
        return events;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

