/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.customevents;

import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.controllereditor.EditUI;
import com.sap.ide.webdynpro.controllereditor.IDisplayErrorListener;
import com.sap.ide.webdynpro.controllereditor.wizards.event.CreateEventWizardData;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.event.EventService;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class EventEditUI
extends EditUI {
    private static final CoreTextPool mCoreTextPool = CoreTextPool.getInstance();
    private static final TextPool mTextPool = TextPool.getInstance();
    private Controller mController = null;
    private CreateEventWizardData mData = null;
    private int mMode;
    private Text mNameField = null;

    public EventEditUI(CreateEventWizardData data, int mode, Controller controller, IDisplayErrorListener displayErrorListener) {
        super(displayErrorListener);
        this.mData = data;
        this.mMode = mode;
        this.mController = controller;
    }

    public void initUI(IGridLayoutPane glp) {
        glp.addTextLabel(mTextPool.getText(39));
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, false);
        this.mNameField = glp.addTextField(this.mData.getName(), this.mMode == 1, gd);
        this.mNameField.addModifyListener((ModifyListener)new NameModifyListener());
        this.mNameField.setFocus();
        this.getDisplayErrorListener().setErrorMessage("");
    }

    public void setVisible(boolean visible) {
        this.mNameField.setFocus();
    }

    private boolean validatePage() {
        String error = null;
        if (this.mMode != 1) {
            error = EventService.isNewEventNameValid((String)this.mNameField.getText(), (Controller)this.mController);
            this.getDisplayErrorListener().setErrorMessage(error);
        }
        return error == null;
    }

    class NameModifyListener
    implements ModifyListener {
        NameModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            EventEditUI.this.validatePage();
            EventEditUI.this.mData.setName(EventEditUI.this.mNameField.getText());
        }
    }
}

