/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context.properties;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute;
import com.sap.ide.metamodel.webdynpro.repository.RepositoryUtilities;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.controllereditor.context.properties.AbstractComboBoxDialogCellEditor;
import com.sap.ide.webdynpro.controllereditor.context.properties.IComboBoxPropertyDescriptor;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.core.UIHelper;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class TypePropertyDescriptor
extends PropertyDescriptor
implements IComboBoxPropertyDescriptor {
    private ContextAttribute mElement;
    private DevelopmentObject mType;
    private DevelopmentObject[] mTypes;
    private DevelopmentObject[] mBuildInTypes;
    private boolean mReadOnly = true;
    private DtDictionaryRoot mDictionaryRoot;

    public TypePropertyDescriptor(Object id, String displayName, ContextValueAttribute element, boolean readOnly) {
        super(id, displayName);
        this.mReadOnly = readOnly;
        this.setLabelProvider((ILabelProvider)new TypeLabelProvider());
        this.mElement = element;
        this.mBuildInTypes = MetamodelServices.getBuiltInScalarTypes((String)element.getRoot().getMetamodel().getName());
        this.mDictionaryRoot = MetamodelServices.getDictionaryRoot((String)element.getRoot().getMetamodel().getName());
        this.mType = CheckLayerHelper.getType((ContextAttribute)element);
        this.updateTypes(this.mType, false);
    }

    public TypePropertyDescriptor(Object id, String displayName, ContextModelAttribute element, boolean readOnly) {
        super(id, displayName);
        this.mReadOnly = readOnly;
        this.mElement = element;
        this.mDictionaryRoot = MetamodelServices.getDictionaryRoot((String)element.getRoot().getMetamodel().getName());
        this.mType = CheckLayerHelper.getType((ContextAttribute)element);
        this.mTypes = this.mType != null ? new DevelopmentObject[]{this.mType} : new DevelopmentObject[0];
        this.setLabelProvider((ILabelProvider)new TypeLabelProvider());
    }

    public TypePropertyDescriptor(Object id, String displayName, DevelopmentObject type, Metamodel metamodel, boolean readOnly) {
        super(id, displayName);
        this.mReadOnly = readOnly;
        this.setLabelProvider((ILabelProvider)new TypeLabelProvider());
        this.mBuildInTypes = MetamodelServices.getBuiltInScalarTypes((String)metamodel.getName());
        this.mDictionaryRoot = MetamodelServices.getDictionaryRoot((String)metamodel.getName());
        if (this.mBuildInTypes.length > 0) {
            this.mDictionaryRoot = MetamodelServices.getDictionaryRoot((String)this.mBuildInTypes[0].getRoot().getMetamodel().getName());
        }
        this.mType = type;
        if (type != null) {
            this.updateTypes(type, false);
        }
    }

    public CellEditor createPropertyEditor(Composite parent) {
        if (!this.mReadOnly) {
            String[] values = new String[this.mTypes.length];
            int i = 0;
            while (i < this.mTypes.length) {
                values[i] = TypePropertyDescriptor.getTypeName(this.mTypes[i]);
                ++i;
            }
            return new TypeCellEditor(parent, values);
        }
        return null;
    }

    public Object getElement(Integer idx) {
        DevelopmentObject type = null;
        int i = idx;
        if (i >= 0 && i < this.mTypes.length) {
            type = this.mTypes[i];
        }
        return type;
    }

    public Integer indexOf(Object type) {
        if (type instanceof DevelopmentObject) {
            int i = 0;
            while (i < this.mTypes.length) {
                if (this.mTypes[i] == type) {
                    return new Integer(i);
                }
                ++i;
            }
        }
        return new Integer(-1);
    }

    private void updateTypes(DevelopmentObject newType, boolean append) {
        if (newType == null || newType instanceof DtSimpleType && ((DtSimpleType)newType).getPackage().equals("com.sap.dictionary")) {
            this.mTypes = this.mBuildInTypes;
        } else {
            this.mTypes = new DevelopmentObject[this.mBuildInTypes.length + 1];
            if (append) {
                System.arraycopy(this.mBuildInTypes, 0, this.mTypes, 0, this.mBuildInTypes.length);
                this.mTypes[this.mBuildInTypes.length] = newType;
            } else {
                this.mTypes[0] = newType;
                System.arraycopy(this.mBuildInTypes, 0, this.mTypes, 1, this.mBuildInTypes.length);
            }
        }
    }

    public static String getTypeName(DevelopmentObject type) {
        MetamodelServices.CompoundType compoundType = new MetamodelServices.CompoundType(type);
        if (compoundType.isBuiltInType()) {
            return type.getName();
        }
        return compoundType.getQualifiedName();
    }

    private class TypeLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (TypePropertyDescriptor.this.mType == null) {
                // empty if block
            }
            return null;
        }

        public String getText(Object element) {
            int idx;
            if (element instanceof Integer && (idx = ((Integer)element).intValue()) >= 0 && idx < TypePropertyDescriptor.this.mTypes.length) {
                return TypePropertyDescriptor.getTypeName(TypePropertyDescriptor.this.mTypes[idx]);
            }
            return "";
        }
    }

    protected class TypeCellEditor
    extends AbstractComboBoxDialogCellEditor {
        protected TypeCellEditor(Composite parent, String[] values) {
            super(parent, values, 8);
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            MetamodelServices.CompoundType type;
            if (!RepositoryUtilities.checkWriteability((MainDevelopmentObject[])new MainDevelopmentObject[]{TypePropertyDescriptor.this.mElement.getMDO()}, (boolean)true)) {
                return this.getValue();
            }
            if (TypePropertyDescriptor.this.mElement instanceof ContextValueAttribute && (type = UIHelper.selectType((DtDictionaryRoot)TypePropertyDescriptor.this.mDictionaryRoot, (DevelopmentObject)((ContextValueAttribute)TypePropertyDescriptor.this.mElement).getType())) != null) {
                ContextService.setType((ContextValueAttribute)((ContextValueAttribute)TypePropertyDescriptor.this.mElement), (MetamodelServices.CompoundType)type);
                TypePropertyDescriptor.this.updateTypes(((ContextValueAttribute)TypePropertyDescriptor.this.mElement).getType(), true);
                return TypePropertyDescriptor.this.indexOf(((ContextValueAttribute)TypePropertyDescriptor.this.mElement).getType());
            }
            return this.getValue();
        }
    }
}

