/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context.properties;

import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.repository.RepositoryUtilities;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.context.properties.SupplyFunctionCreateDialog;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.context.ServicesCreation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SupplyFunctionPropertyDescriptor
extends PropertyDescriptor {
    private ContextNode mNode;
    private Controller mController;
    private boolean mReadOnly = true;

    public SupplyFunctionPropertyDescriptor(Object id, String displayName, ContextNode node, boolean readOnly) {
        super(id, displayName);
        this.mNode = node;
        this.mController = (Controller)node.getMDO();
        this.mReadOnly = readOnly;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        if (!this.mReadOnly) {
            return new SupplyFunctionCellEditor(parent);
        }
        return null;
    }

    class SupplyFunctionCellEditor
    extends DialogCellEditor {
        protected SupplyFunctionCellEditor(Composite parent) {
            super(parent);
        }

        public boolean isDeleteEnabled() {
            return true;
        }

        public void performDelete() {
            if (!RepositoryUtilities.checkWriteability((MainDevelopmentObject[])new MainDevelopmentObject[]{SupplyFunctionPropertyDescriptor.this.mNode.getMDO()}, (boolean)true)) {
                return;
            }
            if (SupplyFunctionPropertyDescriptor.this.mNode.hasSupplyFunction()) {
                try {
                    SupplyFunctionPropertyDescriptor.this.mNode.getSupplyFunction().delete();
                }
                catch (DeleteException e) {
                    Plugin.internalError(((Object)((Object)this)).getClass(), "performDelete", "Failed to delete supply function", e, false);
                }
            }
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            if (!RepositoryUtilities.checkWriteability((MainDevelopmentObject[])new MainDevelopmentObject[]{SupplyFunctionPropertyDescriptor.this.mNode.getMDO()}, (boolean)true)) {
                return this.getValue();
            }
            if (SupplyFunctionPropertyDescriptor.this.mNode instanceof ContextModelNode && ((ContextModelNode)SupplyFunctionPropertyDescriptor.this.mNode).hasSupplyingRelationRole()) {
                boolean removeSupplyingRelationRole = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TextPool.getInstance().getText(2315), (String)TextPool.getInstance().getText(2016));
                if (removeSupplyingRelationRole) {
                    ((ContextModelNode)SupplyFunctionPropertyDescriptor.this.mNode).setSupplyingRelationRole(null);
                } else {
                    return this.getValue();
                }
            }
            SupplyFunctionCreateDialog dialog = new SupplyFunctionCreateDialog(TextPool.getInstance().getText(2315), TextPool.getInstance().getText(2512), SupplyFunctionPropertyDescriptor.this.mNode);
            int status = dialog.open();
            String supplyFunctionName = dialog.getSupplyFunctionName();
            if (status == 0) {
                if (supplyFunctionName != null && supplyFunctionName.length() > 0) {
                    ServicesCreation.createSupplyFunction((ContextNode)SupplyFunctionPropertyDescriptor.this.mNode, (String)supplyFunctionName);
                }
            } else if (status == 2 && SupplyFunctionPropertyDescriptor.this.mNode.hasSupplyFunction()) {
                try {
                    SupplyFunctionPropertyDescriptor.this.mNode.getSupplyFunction().delete();
                    supplyFunctionName = "";
                }
                catch (DeleteException e) {
                    Plugin.internalError(((Object)((Object)this)).getClass(), "performDelete", "Failed to delete supply function " + supplyFunctionName, e, false);
                }
            }
            return supplyFunctionName;
        }
    }
}

