/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context.properties;

import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SupplyFunctionCreateDialog
extends TitleAreaDialog {
    public static final int DELETE = 2;
    private Text mSupplyFunctionNameTextField;
    private String mTitle;
    private String mDescription;
    private ContextNode mContextNode;
    private String mSupplyFunctionName;

    public SupplyFunctionCreateDialog(String title, String description, ContextNode contextNode) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.mTitle = title;
        this.mDescription = description;
        this.mContextNode = contextNode;
        if (this.mContextNode.hasSupplyFunction()) {
            this.mSupplyFunctionName = this.mContextNode.getSupplyFunction().getName();
        } else {
            String nodeName = contextNode.getName();
            this.mSupplyFunctionName = "supply" + Character.toUpperCase(nodeName.charAt(0));
            this.mSupplyFunctionName = this.mSupplyFunctionName + (nodeName.length() > 1 ? nodeName.substring(1) : "");
        }
    }

    protected final Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(parentComposite, 0);
        contents.setLayout((Layout)new FillLayout());
        contents.setLayoutData((Object)new GridData(768));
        this.setTitle(this.mTitle);
        this.setMessage(this.mDescription);
        IGridLayoutPane glp = PaneFactory.createGridLayoutPane((Composite)contents, (int)2);
        IGridLayoutData gridData = glp.createGridLayoutData(1, 1, true, true);
        gridData.getGridData().horizontalIndent = 20;
        glp.setLayoutData((Object)gridData);
        glp.addTextLabel("Name", glp.createGridLayoutData(1, 1));
        this.mSupplyFunctionNameTextField = glp.addTextField(this.mSupplyFunctionName, false, glp.createGridLayoutData(4, 4, true, true));
        this.mSupplyFunctionNameTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SupplyFunctionCreateDialog.this.validateSupplyFunctionName(e);
            }
        });
        return contents;
    }

    private void validateSupplyFunctionName(ModifyEvent e) {
        String message = null;
        this.mSupplyFunctionName = this.mSupplyFunctionNameTextField.getText();
        if (this.mSupplyFunctionName.length() == 0) {
            message = CoreTextPool.getInstance().getText(3, (Object)this.mSupplyFunctionName);
        } else if (!CheckServices.isValidIdentifier((String)this.mSupplyFunctionName)) {
            message = CoreTextPool.getInstance().getText(2, (Object)this.mSupplyFunctionName);
        }
        if (((Controller)this.mContextNode.getMDO()).hasSupplyFunction(this.mSupplyFunctionName) && this.mContextNode.hasSupplyFunction() && !this.mContextNode.getSupplyFunction().getName().equals(this.mSupplyFunctionName)) {
            message = this.mSupplyFunctionName + " already defined.";
        }
        this.getButton(0).setEnabled(message == null);
        this.setErrorMessage(message);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 2, TextPool.getInstance().getText(3), false);
        this.getButton(2).setEnabled(this.mContextNode.hasSupplyFunction());
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2) {
            this.setReturnCode(2);
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public String getSupplyFunctionName() {
        return this.mSupplyFunctionName;
    }

    protected Point getInitialSize() {
        return new Point(350, 250);
    }
}

