/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context.properties;

import com.sap.ide.metamodel.general.metainfo.Property;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.context.properties.PropertyService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.jface.viewers.LabelProvider;

public class ContextEnumLabelProvider
extends LabelProvider {
    private String[] mValues;
    private Property mProperty;

    public ContextEnumLabelProvider(Property property) {
        this.mProperty = property;
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            Enumeration enumeration = PropertyService.getEnumeration(property);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    Method toString = e.getClass().getMethod("toString", null);
                    values.add(toString.invoke(e, null));
                }
            }
        }
        catch (Exception e) {
            Plugin.internalError(((Object)((Object)this)).getClass(), "ContextEnumLabelProvider()", "Failed to retrieve values of enumeration type for property " + property.getName(), e, false);
        }
        this.mValues = values.toArray(new String[values.size()]);
    }

    public ContextEnumLabelProvider(String[] values) {
        this.mValues = values == null ? new String[]{} : values;
    }

    public String getText(Object element) {
        int idx;
        if (element instanceof Integer && (idx = ((Integer)element).intValue()) >= 0 && idx < this.mValues.length) {
            return this.mValues[idx];
        }
        return "";
    }

    public String[] getValues() {
        return this.mValues;
    }
}

