/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context.properties;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractComboBoxDialogCellEditor
extends DialogCellEditor {
    private String[] items;
    private int selection;
    private CCombo comboBox;
    private ModifyListener modifyListener;
    private String buttonLabel;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;

    public AbstractComboBoxDialogCellEditor(Composite parent, String[] items, int style) {
        super(parent, style);
        this.items = items;
        this.selection = 0;
        this.populateComboBoxItems();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        layoutData.minimumWidth = Math.max(30, layoutData.minimumWidth);
        return layoutData;
    }

    protected Object doGetValue() {
        return new Integer(this.selection);
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    protected String[] getItems() {
        return this.items;
    }

    protected void setItems(String[] items) {
        if (items != null) {
            this.items = items;
        }
        this.populateComboBoxItems();
    }

    protected void doSetValue(Object value) {
        this.selection = (Integer)value;
        this.comboBox.select(this.selection);
    }

    protected Button createButton(Composite parent) {
        Button result = new Button(parent, 0);
        result.setText("...");
        return result;
    }

    protected Control createContents(Composite cell) {
        this.comboBox = new CCombo(cell, 0);
        this.comboBox.setFont(cell.getFont());
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                AbstractComboBoxDialogCellEditor.super.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                AbstractComboBoxDialogCellEditor.this.selection = AbstractComboBoxDialogCellEditor.this.comboBox.getSelectionIndex();
                Object newValue = AbstractComboBoxDialogCellEditor.this.doGetValue();
                boolean newValidState = AbstractComboBoxDialogCellEditor.super.isCorrect(newValue);
                if (newValidState) {
                    AbstractComboBoxDialogCellEditor.this.doSetValue(newValue);
                } else {
                    AbstractComboBoxDialogCellEditor.super.setErrorMessage(MessageFormat.format(AbstractComboBoxDialogCellEditor.this.getErrorMessage(), AbstractComboBoxDialogCellEditor.this.items[AbstractComboBoxDialogCellEditor.this.selection]));
                }
                AbstractComboBoxDialogCellEditor.super.fireApplyEditorValue();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        return this.comboBox;
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                this.comboBox.add(this.items[i], i);
                ++i;
            }
            this.setValueValid(true);
        }
    }
}

