/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context.model;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelTreeViewer;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionValidator;

public class ModelDialog
extends TitleAreaDialog {
    private Model mModel;
    private ModelTreeViewer mModelViewer;
    private DevelopmentObject mSelection;
    private String mTitle;
    private String mDescription;
    private int mFilter = 15;
    private ISelectionValidator mValidator;
    public static final int FILTER_TYPE_MODEL_CLASSES = 1;
    public static final int FILTER_TYPE_MODEL_PROPERTIES = 2;
    public static final int FILTER_TYPE_MODEL_RELATION_ROLES = 4;
    public static final int FILTER_TYPE_ALL = 15;

    public ModelDialog(String title, String description, Model model) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.mTitle = title;
        this.mDescription = description;
        this.mModel = model;
    }

    public void setFilter(int filter) {
        this.mFilter = filter;
    }

    public DevelopmentObject getSelection() {
        return this.mSelection;
    }

    public void setValidator(ISelectionValidator validator) {
        this.mValidator = validator;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.numColumns = 1;
        contents.setLayout((Layout)layout);
        contents.setLayoutData((Object)new GridData(1808));
        contents.setFont(parentComposite.getFont());
        this.setTitle(this.mTitle);
        this.setMessage(this.mDescription);
        this.mModelViewer = new ModelTreeViewer(contents, this.mModel);
        GridData data = new GridData(1040);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        this.mModelViewer.getViewer().getControl().setLayoutData((Object)data);
        this.mModelViewer.getViewer().expandToLevel(1);
        this.mModelViewer.getViewer().setSelection(null);
        this.mModelViewer.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    ModelDialog.this.mSelection = (DevelopmentObject)((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (ModelDialog.super.getButton(0) != null) {
                        if (ModelDialog.this.mSelection instanceof ModelClass) {
                            if ((ModelDialog.this.mFilter & 1) != 0 || ModelDialog.this.mFilter == 15) {
                                ModelDialog.super.getButton(0).setEnabled(ModelDialog.this.isSelectionValid());
                            } else {
                                ModelDialog.super.getButton(0).setEnabled(false);
                            }
                        } else if (ModelDialog.this.mSelection instanceof Property) {
                            if ((ModelDialog.this.mFilter & 2) != 0 || ModelDialog.this.mFilter == 15) {
                                ModelDialog.super.getButton(0).setEnabled(ModelDialog.this.isSelectionValid());
                            } else {
                                ModelDialog.super.getButton(0).setEnabled(false);
                            }
                        } else if (ModelDialog.this.mSelection instanceof ModelRelationRole) {
                            if ((ModelDialog.this.mFilter & 4) != 0 || ModelDialog.this.mFilter == 15) {
                                ModelDialog.super.getButton(0).setEnabled(ModelDialog.this.isSelectionValid());
                            } else {
                                ModelDialog.super.getButton(0).setEnabled(false);
                            }
                        }
                    }
                } else if (ModelDialog.super.getButton(0) != null) {
                    ModelDialog.super.getButton(0).setEnabled(false);
                }
            }
        });
        return contents;
    }

    protected boolean isSelectionValid() {
        String message = null;
        if (this.mValidator != null) {
            message = this.mValidator.isValid((Object)this.mSelection);
            this.setErrorMessage(message);
        }
        return message == null;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.y += 100;
        return size;
    }
}

