/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context.model;

import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.checklayer.model.ModelClassHelper;
import org.eclipse.ui.dialogs.ISelectionValidator;

public class ModelBindingValidator
implements ISelectionValidator {
    private ContextElement mSource;
    private ControllerUsage[] mControllerUsages;

    public ModelBindingValidator(ContextElement source, ControllerUsage[] controllerUsages) {
        this.mSource = source;
        this.mControllerUsages = controllerUsages;
    }

    public String isValid(Object value) {
        String message = null;
        if (this.mSource instanceof ContextModelNode) {
            if (value instanceof ModelRelationRole) {
                if (((ContextModelNode)this.mSource).getParent().getParent() instanceof Controller) {
                    message = "Model relations cannot be defined for context root nodes.";
                } else if (!CheckLayerHelper.isValidSupplyingRelationRole((ContextModelNode)((ContextModelNode)this.mSource), (ModelRelationRole)((ModelRelationRole)value))) {
                    message = "Invalid model relation. The corresponding model class does not match the model class associated with the parent context node.";
                }
            } else if (value instanceof Property) {
                message = "Context model nodes cannot be bound to model properties.";
            } else if (value instanceof Model) {
                message = "Context element cannot be bound to model layer.";
            }
        } else if (this.mSource instanceof ContextModelAttribute) {
            if (!(value instanceof Property)) {
                message = "Context model attributes cannot be bound to model classes or model relations.";
            } else {
                ModelClass modelClass;
                ContextElement parentNode = (ContextElement)this.mSource.getParent();
                if (parentNode instanceof ContextModelNode && !ModelClassHelper.hasModelClassProperty((ModelClass)(modelClass = CheckLayerHelper.getModelClass((ContextModelNode)((ContextModelNode)parentNode))), (Property)((ModelClassProperty)value))) {
                    message = "The model property is not a member of the model class the parent node is bound to.";
                }
            }
        } else {
            message = "Context element cannot be bound to model layer.";
        }
        return message;
    }
}

