/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.controllereditor.context.properties.ContextElementPropertySource;
import com.sap.ide.webdynpro.controllereditor.context.properties.ModelPropertySource;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class PropertySourceProvider
implements IPropertySourceProvider {
    private static Model[] EMPTY_MODELS = new Model[0];
    private Controller mController;
    private Component mComponent;
    private ComponentInterfaceDefinition mComponentInterfaceDefinition;
    private ComponentControllerUsage mComponentControllerUsage;

    public PropertySourceProvider(Controller controller, Component component) {
        this.mController = controller;
        this.mComponent = component;
    }

    public PropertySourceProvider(Controller controller, ComponentInterfaceDefinition definition) {
        this.mController = controller;
        this.mComponentInterfaceDefinition = definition;
    }

    public PropertySourceProvider(ComponentControllerUsage componentControllerUsage) {
        this.mComponentControllerUsage = componentControllerUsage;
    }

    public String getName() {
        if (this.mController != null) {
            return this.mController.getName();
        }
        return this.mComponentControllerUsage.getName();
    }

    public ControllerUsage[] getOutgoingControllerUsages() {
        if (this.mController != null) {
            return this.mController.getOutgoingControllerUsages();
        }
        return this.mComponentControllerUsage.getOutgoingControllerUsages();
    }

    public int getOutgoingControllerUsageCount() {
        if (this.mController != null) {
            return this.mController.getOutgoingControllerUsageCount();
        }
        return this.mComponentControllerUsage.getOutgoingControllerUsageCount();
    }

    public Model[] getUsedModels() {
        if (this.mComponent != null) {
            return this.mComponent.getUsedModels();
        }
        if (this.mComponentInterfaceDefinition != null) {
            return this.mComponentInterfaceDefinition.getUsedModels();
        }
        return EMPTY_MODELS;
    }

    public ContextValueNode getContext() {
        return this.getController().getContext();
    }

    public boolean isModified() {
        if (this.mController != null) {
            return this.mController.isModified();
        }
        return this.mComponentControllerUsage.isModified();
    }

    public boolean isReadOnly() {
        if (this.mController != null) {
            return this.mController.isReadOnly();
        }
        return this.mComponentControllerUsage.isReadOnly();
    }

    public boolean isDeleted() {
        if (this.mController != null) {
            return this.mController.isDeleted();
        }
        return this.mComponentControllerUsage.isDeleted();
    }

    public void attachControllerUsageObserver(DevelopmentObjectObserver observer) {
        if (this.mController != null) {
            this.mController.attachObserver(observer);
        } else {
            this.mComponentControllerUsage.attachObserver(observer);
        }
    }

    public void attachControllerUsageObserver(DevelopmentObjectObserver observer, int eventMask) {
        if (this.mController != null) {
            this.mController.attachObserver(observer, eventMask);
        } else {
            this.mComponentControllerUsage.attachObserver(observer, eventMask);
        }
    }

    public void detachControllerUsageObserver(DevelopmentObjectObserver observer) {
        if (this.mController != null) {
            this.mController.detachObserver(observer);
        } else {
            this.mComponentControllerUsage.detachObserver(observer);
        }
    }

    public void attachModelUsageObserver(DevelopmentObjectObserver observer) {
        if (this.mComponent != null) {
            this.mComponent.attachObserver(observer);
        } else if (this.mComponentInterfaceDefinition != null) {
            this.mComponentInterfaceDefinition.attachObserver(observer);
        }
    }

    public void attachModelUsageObserver(DevelopmentObjectObserver observer, int eventMask) {
        if (this.mComponent != null) {
            this.mComponent.attachObserver(observer, eventMask);
        } else if (this.mComponentInterfaceDefinition != null) {
            this.mComponentInterfaceDefinition.attachObserver(observer, eventMask);
        }
    }

    public void detachModelUsageObserver(DevelopmentObjectObserver observer) {
        if (this.mComponent != null) {
            this.mComponent.detachObserver(observer);
        } else if (this.mComponentInterfaceDefinition != null) {
            this.mComponentInterfaceDefinition.detachObserver(observer);
        }
    }

    public IPropertySource getPropertySource(Object object) {
        Object source = null;
        if (object != null) {
            if (object instanceof ContextElement) {
                boolean readOnly = !((ContextElement)object).getMDO().equals(this.getController()) || this.isReverseMappingMode() && !((ContextElement)object).getIsInputElement();
                ControllerUsage[] usages = null;
                usages = this.isReverseMappingMode() && ((ContextElement)object).getIsInputElement() ? this.getOutgoingControllerUsages() : CheckLayerHelper.getOutgoingControllerUsages((ContextElement)((ContextElement)object));
                source = new ContextElementPropertySource((ContextElement)object, usages, readOnly, this.isReverseMappingMode());
            } else if (object instanceof DevelopmentObject) {
                source = new ModelPropertySource((DevelopmentObject)object);
            }
        }
        return source;
    }

    public boolean isReverseMappingMode() {
        return this.mComponentControllerUsage != null;
    }

    public Component getEmbeddingComponent() {
        if (this.mComponentControllerUsage != null) {
            return (Component)this.mComponentControllerUsage.getMDO();
        }
        return null;
    }

    private Controller getController() {
        if (this.mController != null) {
            return this.mController;
        }
        return this.mComponentControllerUsage.getUsedComponentController();
    }
}

