/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context;

import com.sap.ide.webdynpro.controllereditor.context.IListBarItemListener;
import com.sap.ide.webdynpro.controllereditor.context.ListBarItem;
import com.sap.ide.webdynpro.controllereditor.context.ListBarItemEvent;
import com.sap.ide.webdynpro.controllereditor.context.SelectableListBarItem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ListBarViewer
implements ISelectionProvider {
    protected List mTrayItems;
    private ListBarItem mActiveTray;
    private Composite mComposite;
    private ListenerList mTrayItemSelectionListeners = new ListenerList();
    private ListenerList mSelectionChangedListeners = new ListenerList();
    private IListBarItemListener mTrayItemListener = new IListBarItemListener(){

        public void expanded(ListBarItemEvent e) {
            if (e.getSource() instanceof ListBarItem && ListBarViewer.this.mActiveTray != null && !ListBarViewer.this.mActiveTray.equals(e.getSource())) {
                ListBarViewer.this.aboutToExpand((ListBarItem)e.getSource());
                ListBarViewer.this.mActiveTray.isCollapsed(true);
                ListBarViewer.this.mActiveTray = (ListBarItem)e.getSource();
                ListBarViewer.this.mActiveTray.isCollapsed(false);
                ListBarViewer.this.mComposite.layout(true);
                ListBarViewer.this.expanded((ListBarItem)e.getSource());
            }
        }

        public void collapsed(ListBarItemEvent e) {
        }
    };
    private ISelectionChangedListener mSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ListBarViewer.this.fireSelectionChangedEvent(event);
        }
    };

    public ListBarViewer() {
        this(1);
    }

    public ListBarViewer(int hintTrayItemCount) {
        this.mTrayItems = new ArrayList(hintTrayItemCount);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.mSelectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.mSelectionChangedListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        ISelectionProvider provider;
        ListBarItem item = this.getActiveTrayItem();
        if (item != null && item instanceof SelectableListBarItem && (provider = ((SelectableListBarItem)item).getSelectionProvider()) != null) {
            return provider.getSelection();
        }
        return Selection.NOT_SELECTED;
    }

    public void setSelection(ISelection selection) {
        ISelectionProvider provider;
        ListBarItem item = this.getActiveTrayItem();
        if (item != null && item instanceof SelectableListBarItem && (provider = ((SelectableListBarItem)item).getSelectionProvider()) != null) {
            provider.setSelection(selection);
        }
    }

    public void init(Composite parent) {
        this.mComposite = new Composite(parent, 0);
        this.mComposite.setLayout((Layout)new ExpandableLayout());
        this.initClientArea(this.mComposite);
    }

    public void addTrayItem(ListBarItem trayItem, boolean update) {
        if (trayItem != null) {
            ISelectionProvider provider;
            this.mTrayItems.add(trayItem);
            if (this.mActiveTray != null) {
                this.mActiveTray.isCollapsed(true);
            }
            trayItem.init(this.mComposite);
            this.mActiveTray = trayItem;
            trayItem.isCollapsed(false);
            trayItem.addTrayItemListener(this.mTrayItemListener);
            if (trayItem instanceof SelectableListBarItem && (provider = ((SelectableListBarItem)trayItem).getSelectionProvider()) != null) {
                provider.addSelectionChangedListener(this.mSelectionChangedListener);
            }
        }
        if (update) {
            this.mComposite.layout(true);
        }
    }

    public ListBarItem removeTrayItem(int idx, boolean update) {
        ListBarItem item = null;
        if (idx >= 0 && idx < this.mTrayItems.size()) {
            item = (ListBarItem)this.mTrayItems.remove(idx);
            if (item != null) {
                ISelectionProvider provider;
                if (this.mActiveTray == item) {
                    if (this.mTrayItems.size() > 0) {
                        this.mActiveTray = (ListBarItem)this.mTrayItems.get(0);
                        this.mActiveTray.isCollapsed(false);
                    } else {
                        this.mActiveTray = null;
                    }
                }
                if (item instanceof SelectableListBarItem && (provider = ((SelectableListBarItem)item).getSelectionProvider()) != null) {
                    provider.removeSelectionChangedListener(this.mSelectionChangedListener);
                }
            }
            if (update) {
                if (this.mTrayItems.size() == 0) {
                    this.mComposite.pack(true);
                } else {
                    this.mComposite.layout(true);
                }
            }
        }
        return item;
    }

    public ListBarItem removeTrayItem(ListBarItem item, boolean update) {
        return this.removeTrayItem(this.mTrayItems.indexOf(item), update);
    }

    public ListBarItem getTray(int idx) {
        return (ListBarItem)this.mTrayItems.get(idx);
    }

    public int indexOf(ListBarItem tray) {
        return this.mTrayItems.indexOf(tray);
    }

    public ListBarItem getActiveTrayItem() {
        return this.mActiveTray;
    }

    public ListBarItem[] getTrayItems() {
        return this.mTrayItems.toArray(new ListBarItem[this.mTrayItems.size()]);
    }

    public void setActiveTrayItem(ListBarItem item) {
        if (item != null && !item.equals(this.mActiveTray) && this.mTrayItems.contains(item)) {
            if (this.mActiveTray != null) {
                this.mActiveTray.isCollapsed(true);
            }
            this.mActiveTray = item;
            item.isCollapsed(false);
            this.mComposite.layout(true);
        }
    }

    protected void initClientArea(Composite parent) {
    }

    protected void aboutToExpand(ListBarItem trayItem) {
        if (trayItem instanceof SelectableListBarItem) {
            ((SelectableListBarItem)trayItem).getSelectionProvider().setSelection((ISelection)Selection.SELECTED);
        }
    }

    protected void expanded(ListBarItem trayItem) {
    }

    public Composite getControl() {
        return this.mComposite;
    }

    protected void fireSelectionChangedEvent(SelectionChangedEvent event) {
        Object[] listeners = this.mSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
            ++i;
        }
    }

    static class Selection
    implements ISelection {
        static final Selection SELECTED = new Selection(true);
        static final Selection NOT_SELECTED = new Selection(false);
        private boolean mIsEmpty;

        public Selection(boolean isEmpty) {
            this.mIsEmpty = isEmpty;
        }

        public boolean isEmpty() {
            return this.mIsEmpty;
        }
    }

    class ExpandableLayout
    extends Layout {
        static final int MIN_EXPANSION_HEIGHT = 100;

        ExpandableLayout() {
        }

        protected void layout(Composite parent, boolean changed) {
            if (ListBarViewer.this.mTrayItems.size() > 0) {
                Rectangle rectParent = parent.getClientArea();
                Point buttonSize = ((ListBarItem)ListBarViewer.this.mTrayItems.get(0)).getButton().computeSize(rectParent.width, -1, changed);
                int y = 0;
                int i = 0;
                while (i < ListBarViewer.this.mTrayItems.size()) {
                    ListBarItem trayItem = (ListBarItem)ListBarViewer.this.mTrayItems.get(i);
                    trayItem.getButton().setBounds(0, y, buttonSize.x, buttonSize.y);
                    y += buttonSize.y;
                    if (trayItem.isCollapsed()) {
                        trayItem.getExpansion().setBounds(0, y, 0, 0);
                    } else {
                        int height = rectParent.height - ListBarViewer.this.mTrayItems.size() * buttonSize.y;
                        height = Math.max(height, 100);
                        trayItem.getExpansion().setBounds(0, y, buttonSize.x, height);
                        y += height;
                    }
                    ++i;
                }
            }
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean changed) {
            Point size = null;
            if (ListBarViewer.this.mTrayItems.size() > 0) {
                Point buttonSize = ((ListBarItem)ListBarViewer.this.mTrayItems.get(0)).getButton().computeSize(wHint, -1, changed);
                size = new Point(wHint, buttonSize.x * ListBarViewer.this.mTrayItems.size() + 100);
            } else {
                size = new Point(wHint, hHint);
            }
            return size;
        }
    }
}

