/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context;

import com.sap.ide.webdynpro.controllereditor.context.IListBarItemListener;
import com.sap.ide.webdynpro.controllereditor.context.ListBarItemEvent;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class ListBarItem {
    private String mLabel;
    private int mStyle;
    private Button mButton;
    private Composite mExpansion;
    private boolean mIsCollapsed = true;
    private boolean mIsToggle = false;
    private ListenerList mTrayItemListeners = new ListenerList();

    public ListBarItem(String label) {
        this(label, 0x800000);
    }

    public ListBarItem(String label, int style) {
        this.mLabel = label;
        this.mStyle = style;
    }

    public void init(Composite parent) {
        this.mButton = new Button(parent, this.mStyle);
        this.mButton.setText(this.mLabel);
        this.mButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ListBarItem.this.mIsToggle && ListBarItem.this.mIsCollapsed) {
                    ListBarItem.this.fireCollapsedEvent();
                } else {
                    ListBarItem.this.fireExpandedEvent();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ListBarItem.this.dispose();
            }
        });
        this.mExpansion = new Composite(parent, 0);
        this.mExpansion.setLayout((Layout)new FillLayout());
        this.initExpansion(this.mExpansion);
    }

    public void isCollapsed(boolean collapse) {
        this.mIsCollapsed = collapse;
        this.mExpansion.setVisible(!collapse);
    }

    public void setText(String text) {
        this.getButton().setText(text);
    }

    public void setAlignment(int alignment) {
        this.getButton().setAlignment(alignment);
    }

    public void setImage(Image image) {
        this.getButton().setImage(image);
    }

    public boolean isCollapsed() {
        return this.mIsCollapsed;
    }

    public String getText() {
        return this.getButton().getText();
    }

    public int getAlignment() {
        return this.getButton().getAlignment();
    }

    public Image getImage() {
        return this.getButton().getImage();
    }

    public void addTrayItemListener(IListBarItemListener listener) {
        if (listener != null) {
            this.mTrayItemListeners.add((Object)listener);
        }
    }

    public void removeTrayItemListener(IListBarItemListener listener) {
        if (listener != null) {
            this.mTrayItemListeners.remove((Object)listener);
        }
    }

    protected abstract void initExpansion(Composite var1);

    public Button getButton() {
        if (this.mButton != null) {
            return this.mButton;
        }
        throw new IllegalStateException("Initialization missing - init method has to be called first");
    }

    public Composite getExpansion() {
        if (this.mExpansion != null) {
            return this.mExpansion;
        }
        throw new IllegalStateException("Initialization missing - init method has to be called first");
    }

    public void dispose() {
    }

    protected void fireCollapsedEvent() {
        Object[] listeners = this.mTrayItemListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IListBarItemListener)listeners[i]).collapsed(new ListBarItemEvent(this));
            ++i;
        }
    }

    protected void fireExpandedEvent() {
        Object[] listeners = this.mTrayItemListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IListBarItemListener)listeners[i]).expanded(new ListBarItemEvent(this));
            ++i;
        }
    }

    class ExpandableLayout
    extends Layout {
        static final int MIN_EXPANSION_HEIGHT = 100;

        ExpandableLayout() {
        }

        protected void layout(Composite parent, boolean changed) {
            Rectangle clientArea = parent.getClientArea();
            Point size = ListBarItem.this.mButton.computeSize(clientArea.width, -1, changed);
            int y = 0;
            ListBarItem.this.mButton.setBounds(0, 0, size.x, size.y);
            y = size.y;
            size = ListBarItem.this.mExpansion.computeSize(clientArea.width, clientArea.height, changed);
            if (ListBarItem.this.mIsCollapsed) {
                ListBarItem.this.mExpansion.setBounds(0, y, 0, 0);
            } else {
                ListBarItem.this.mExpansion.setBounds(0, y, size.x, size.y);
            }
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean changed) {
            int width = 0;
            int height = 0;
            Point size = ListBarItem.this.mButton.computeSize(-1, -1, changed);
            width = size.x;
            height = size.y;
            if (!ListBarItem.this.mIsCollapsed) {
                size = ListBarItem.this.mExpansion.computeSize(wHint, 100, changed);
                width = Math.max(width, size.x);
                height += size.y;
            }
            return new Point(width, height);
        }
    }
}

