/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextRecursionNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.repository.RepositoryUtilities;
import com.sap.ide.services.metamodel.webdynpro.ChangeStatusEnum;
import com.sap.ide.services.metamodel.webdynpro.IChangeStatus;
import com.sap.ide.services.metamodel.webdynpro.view.ViewServices;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.context.ContextContentProvider;
import com.sap.ide.webdynpro.controllereditor.context.ContextDragListener;
import com.sap.ide.webdynpro.controllereditor.context.ContextDropListener;
import com.sap.ide.webdynpro.controllereditor.context.ContextElementSorter;
import com.sap.ide.webdynpro.controllereditor.context.ContextLabelProvider;
import com.sap.ide.webdynpro.controllereditor.context.IContextViewerContainer;
import com.sap.ide.webdynpro.controllereditor.context.IControllerUsageProvider;
import com.sap.ide.webdynpro.controllereditor.wizards.context.ContextWizardDialog;
import com.sap.ide.webdynpro.controllereditor.wizards.context.creation.ContextCreationWizard;
import com.sap.ide.webdynpro.controllereditor.wizards.context.mapping.ContextMappingWizard;
import com.sap.ide.webdynpro.controllereditor.wizards.context.modelbinding.ModelBindingWizard;
import com.sap.ide.webdynpro.controllereditor.wizards.context.refactoring.RenameContextElementWizard;
import com.sap.ide.webdynpro.controllereditor.wizards.context.structurebinding.StructureBindingWizard;
import com.sap.ide.webdynpro.service.controllereditor.TextPool;
import com.sap.ide.webdynpro.service.controllereditor.context.ServicesDeletion;
import com.sap.ide.webdynpro.service.controllereditor.context.paste.ServicesRefactoring;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizard;
import com.sap.ide.webdynpro.service.core.wizards.refactor.RenameWizardDialog;
import com.sap.ide.webdynpro.ui.dialog.wizard.WebDynproWizardDialog;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.sap.ide.webdynpro.ui.tree.TreeExpandListener;
import com.tssap.util.help.ContextHelp;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ContextTreeViewer
implements IControllerUsageProvider {
    private static String DEFAULT_TYPE;
    private Composite mParent;
    private IContextViewerContainer mContainer;
    private TreeViewer mTreeViewer;
    private ContextNode mRoot;
    private boolean mHasContextMenue;
    private boolean mIsReverseMappingMode;
    private boolean mIsHomogeneousSelection;
    private boolean mIsFlatSelection;
    private boolean mSingleSelection;
    private Map mGlobalActionsForId = new HashMap();
    private IAction mDeleteAction;
    private IAction mAddValueNodeAction;
    private IAction mAddValueAttributeAction;
    private IAction mAddModelNodeAction;
    private IAction mAddModelAttributeAction;
    private IAction mEditMappingAction;
    private IAction mDeleteMappingAction;
    private IAction mAddRecursionNodeAction;
    private IAction mEditModelBindingAction;
    private IAction mEditStructureBindingAction;
    private IAction mDeleteStructureBindingAction;
    private IAction mRenameAction;
    private IAction mExpandSubtreeAction;
    private IAction mShowHelpAction;
    private IAction mShowPropertiesAction;
    private Action mCopyAction;
    private IAction mPasteAction;
    private IAction mPasteSpecialAction;
    private IAction mCutAction;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueNode;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelNode;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextRecursionNode;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$component$controller$ContextAttribute;

    public ContextTreeViewer(Composite parent, ContextNode root, boolean hasContextMenue) {
        this(parent, root, null, hasContextMenue, false, false);
    }

    public ContextTreeViewer(Composite parent, ContextNode root, IContextViewerContainer container, boolean hasContextMenue, boolean enableMultiSelection, boolean isReverseMappingMode) {
        this.mParent = parent;
        this.mContainer = container;
        this.mIsReverseMappingMode = isReverseMappingMode;
        this.mRoot = root;
        this.mHasContextMenue = hasContextMenue;
        this.createTreeViewer(enableMultiSelection);
    }

    private void createTreeViewer(boolean enableMultiSelection) {
        ContextContentProvider.ContextRoot contextRoot = new ContextContentProvider.ContextRoot((ContextElement)this.mRoot);
        this.mTreeViewer = enableMultiSelection ? new TreeViewer(this.mParent) : new TreeViewer(this.mParent, 2820);
        if (this.mContainer != null) {
            this.mTreeViewer.setContentProvider((IContentProvider)new ContextContentProvider(contextRoot, this.mIsReverseMappingMode, this.mContainer.getEmbeddingComponent()));
        } else {
            this.mTreeViewer.setContentProvider((IContentProvider)new ContextContentProvider());
        }
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new ContextLabelProvider(this, this.mIsReverseMappingMode, false));
        this.mTreeViewer.setSorter((ViewerSorter)new ContextElementSorter());
        this.mTreeViewer.addTreeListener((ITreeViewerListener)new TreeExpandListener());
        this.mTreeViewer.setInput((Object)contextRoot);
        this.mTreeViewer.expandToLevel(2);
        if (this.mHasContextMenue) {
            this.createContextMenu();
            this.mTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new ContextTreeSelectionChangedListener());
            this.mTreeViewer.getTree().addKeyListener((KeyListener)new ContextTreeKeyListener());
        }
    }

    public ContextElement getContextRootNode() {
        return this.mRoot;
    }

    public TreeViewer getViewer() {
        return this.mTreeViewer;
    }

    public IAction getGlobalAction(String actionId) {
        if (this.mGlobalActionsForId.containsKey(actionId)) {
            return (IAction)this.mGlobalActionsForId.get(actionId);
        }
        return null;
    }

    public void updateSelection(ContextElement e) {
        this.mTreeViewer.setSelection(null);
        this.mTreeViewer.setSelection((ISelection)new StructuredSelection((Object)e));
    }

    public ControllerUsage[] getControllerUsages() {
        ArrayList<ControllerUsage> results = new ArrayList<ControllerUsage>();
        ControllerUsage[] usages = new ControllerUsage[]{};
        usages = this.mContainer != null ? this.mContainer.getControllerUsages() : ((Controller)this.mRoot.getMDO()).getOutgoingControllerUsages();
        int i = 0;
        while (i < usages.length) {
            ControllerUsage usage = usages[i];
            if (usage.hasUsedController()) {
                results.add(usage);
            }
            ++i;
        }
        return results.toArray(new ControllerUsage[results.size()]);
    }

    private void createContextMenu() {
        this.createActions();
        this.updateActions((ContextElement)this.mRoot);
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ContextTreeViewer.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.mTreeViewer.getControl());
        this.mTreeViewer.getControl().setMenu(menu);
    }

    private void createActions() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.mDeleteAction = new Action(CoreTextPool.getInstance().getText(156)){

            public void run() {
                ContextTreeViewer.this.delete();
            }
        };
        this.mDeleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.mDeleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.mDeleteAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.mDeleteAction.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_HOVER"));
        this.mGlobalActionsForId.put("delete", this.mDeleteAction);
        this.mExpandSubtreeAction = new Action(TextPool.getInstance().getText(2203)){

            public void run() {
                ContextTreeViewer.this.expandSubtree();
            }
        };
        this.mShowHelpAction = new Action(TextPool.getInstance().getText(2202)){

            public void run() {
                ContextTreeViewer.this.showHelp();
            }
        };
        this.mCopyAction = new Action(CoreTextPool.getInstance().getText(154)){

            public void run() {
                ContextTreeViewer.this.copy();
            }
        };
        this.mCopyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.mCopyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.mCopyAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.mCopyAction.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_HOVER"));
        this.mGlobalActionsForId.put("copy", this.mCopyAction);
        this.mPasteAction = new Action(CoreTextPool.getInstance().getText(159)){

            public void run() {
                ContextTreeViewer.this.paste();
            }
        };
        this.mPasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.mPasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.mPasteAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.mPasteAction.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_HOVER"));
        this.mGlobalActionsForId.put("paste", this.mPasteAction);
        this.mPasteSpecialAction = new Action(TextPool.getInstance().getText(2201)){

            public void run() {
                ContextTreeViewer.this.pasteSpecial();
            }
        };
        this.mCutAction = new Action(CoreTextPool.getInstance().getText(160)){

            public void run() {
                ContextTreeViewer.this.cut();
            }
        };
        this.mCutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.mCutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.mCutAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.mCutAction.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_HOVER"));
        this.mGlobalActionsForId.put("cut", this.mCutAction);
        this.mAddValueNodeAction = new Action(TextPool.getInstance().getText(2204)){

            public void run() {
                ContextTreeViewer.this.addValueNode();
            }

            public ImageDescriptor getImageDescriptor() {
                return SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.ICON_VALUE_NODE);
            }
        };
        this.mAddValueAttributeAction = new Action(TextPool.getInstance().getText(2205)){

            public void run() {
                ContextTreeViewer.this.addValueAttribute();
            }

            public ImageDescriptor getImageDescriptor() {
                return SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.ICON_VALUE_ATTRIBUTE);
            }
        };
        this.mAddModelNodeAction = new Action(TextPool.getInstance().getText(2206)){

            public void run() {
                ContextTreeViewer.this.addModelNode();
            }

            public ImageDescriptor getImageDescriptor() {
                return SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.ICON_MODEL_NODE);
            }
        };
        this.mAddRecursionNodeAction = new Action(TextPool.getInstance().getText(2208)){

            public void run() {
                ContextTreeViewer.this.addRecursionNode();
            }

            public ImageDescriptor getImageDescriptor() {
                return SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.ICON_RECURSION_NODE);
            }
        };
        this.mAddModelAttributeAction = new Action(TextPool.getInstance().getText(2207)){

            public void run() {
                ContextTreeViewer.this.addModelAttribute();
            }

            public ImageDescriptor getImageDescriptor() {
                return SapIdeUtilImages.getSapImageDescriptor((ISapImage)WebDynproImage.ICON_MODEL_ATTRIBUTE);
            }
        };
        this.mEditMappingAction = new Action(TextPool.getInstance().getText(2209)){

            public void run() {
                ContextTreeViewer.this.editContextMapping(ContextTreeViewer.this.mEditMappingAction.getText());
            }
        };
        this.mDeleteMappingAction = new Action(TextPool.getInstance().getText(2210)){

            public void run() {
                ContextTreeViewer.this.deleteContextMapping();
            }
        };
        this.mEditModelBindingAction = new Action(TextPool.getInstance().getText(2211)){

            public void run() {
                ContextTreeViewer.this.editModelBinding();
            }
        };
        this.mEditStructureBindingAction = new Action(TextPool.getInstance().getText(2217)){

            public void run() {
                ContextTreeViewer.this.editStructureBinding();
            }
        };
        this.mDeleteStructureBindingAction = new Action(TextPool.getInstance().getText(2218)){

            public void run() {
                ContextTreeViewer.this.deleteStructureBinding();
            }
        };
        this.mRenameAction = new Action(com.sap.ide.webdynpro.ui.service.TextPool.getInstance().getText(112)){

            public void run() {
                ContextTreeViewer.this.rename();
            }
        };
        this.mShowPropertiesAction = new Action(CoreTextPool.getInstance().getText(163)){

            public void run() {
                ContextTreeViewer.this.showProperties();
            }
        };
        this.mGlobalActionsForId.put("properties", this.mShowPropertiesAction);
    }

    private void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        if (selection != null && selection.size() >= 1) {
            ContextElement element = (ContextElement)selection.getFirstElement();
            if (!this.mIsHomogeneousSelection) {
                mgr.add((IAction)this.mCopyAction);
                mgr.add(this.mPasteAction);
                mgr.add(this.mPasteSpecialAction);
                mgr.add((IContributionItem)new Separator());
                mgr.add(this.mDeleteAction);
                mgr.add((IContributionItem)new Separator());
                mgr.add(this.mShowHelpAction);
                mgr.add((IContributionItem)new Separator());
                mgr.add(this.mShowPropertiesAction);
                this.updateActions(element);
                return;
            }
            if (this.mIsReverseMappingMode) {
                mgr.add(this.mEditMappingAction);
                mgr.add(this.mDeleteMappingAction);
                mgr.add((IContributionItem)new Separator());
                mgr.add((IAction)this.mCopyAction);
                mgr.add(this.mPasteAction);
                mgr.add(this.mPasteSpecialAction);
                mgr.add((IContributionItem)new Separator());
                mgr.add(this.mExpandSubtreeAction);
            } else if (element instanceof ContextNode) {
                NewMenuManager newSubMenuMgr = new NewMenuManager(CoreTextPool.getInstance().getText(152), selection);
                mgr.add((IContributionItem)newSubMenuMgr);
                if (element.getParent() instanceof Controller) {
                    newSubMenuMgr.add(this.mAddValueNodeAction);
                    newSubMenuMgr.add(this.mAddValueAttributeAction);
                    newSubMenuMgr.add(this.mAddModelNodeAction);
                    newSubMenuMgr.add(this.mAddModelAttributeAction);
                } else {
                    if (element instanceof ContextValueNode) {
                        newSubMenuMgr.add(this.mAddValueNodeAction);
                        newSubMenuMgr.add(this.mAddValueAttributeAction);
                        newSubMenuMgr.add(this.mAddModelNodeAction);
                        newSubMenuMgr.add(this.mAddRecursionNodeAction);
                    } else if (element instanceof ContextModelNode) {
                        newSubMenuMgr.add(this.mAddValueNodeAction);
                        newSubMenuMgr.add(this.mAddValueAttributeAction);
                        newSubMenuMgr.add(this.mAddModelNodeAction);
                        newSubMenuMgr.add(this.mAddModelAttributeAction);
                        newSubMenuMgr.add(this.mAddRecursionNodeAction);
                    }
                    mgr.add((IContributionItem)new Separator());
                    mgr.add(this.mEditMappingAction);
                    mgr.add(this.mDeleteMappingAction);
                    mgr.add((IContributionItem)new Separator());
                    if (element instanceof ContextModelNode) {
                        mgr.add(this.mEditModelBindingAction);
                        mgr.add((IContributionItem)new Separator());
                    } else if (element instanceof ContextValueNode) {
                        mgr.add(this.mEditStructureBindingAction);
                        mgr.add(this.mDeleteStructureBindingAction);
                        mgr.add((IContributionItem)new Separator());
                    }
                }
                mgr.add((IContributionItem)new Separator());
                mgr.add((IAction)this.mCopyAction);
                mgr.add(this.mPasteAction);
                mgr.add(this.mPasteSpecialAction);
                mgr.add((IContributionItem)new Separator());
                mgr.add(this.mDeleteAction);
                mgr.add(this.mRenameAction);
                mgr.add((IContributionItem)new Separator());
                mgr.add(this.mExpandSubtreeAction);
            } else {
                if (element instanceof ContextAttribute) {
                    mgr.add(this.mEditMappingAction);
                    mgr.add(this.mDeleteMappingAction);
                    mgr.add((IContributionItem)new Separator());
                }
                if (element instanceof ContextModelAttribute) {
                    mgr.add(this.mEditModelBindingAction);
                    mgr.add((IContributionItem)new Separator());
                }
                mgr.add((IContributionItem)new Separator());
                mgr.add((IAction)this.mCopyAction);
                mgr.add(this.mPasteAction);
                mgr.add(this.mPasteSpecialAction);
                mgr.add((IContributionItem)new Separator());
                mgr.add(this.mDeleteAction);
                mgr.add(this.mRenameAction);
                mgr.add((IContributionItem)new Separator());
            }
            mgr.add(this.mShowHelpAction);
            mgr.add((IContributionItem)new Separator());
            mgr.add(this.mShowPropertiesAction);
            this.updateActions(element);
        }
    }

    private boolean isMultiSelection(IStructuredSelection selection) {
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (i == 2) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updateActions(ContextElement element) {
        ContextValueNode valueNode;
        this.mPasteAction.setEnabled(!this.mIsReverseMappingMode && this.isPasteAllowed());
        this.mPasteSpecialAction.setEnabled(this.mPasteAction.isEnabled());
        this.mCopyAction.setEnabled(this.isCopyAllowed());
        this.mCutAction.setEnabled(this.isCutAllowed() && !(element.getParent() instanceof Controller) && !this.mIsReverseMappingMode);
        this.mRenameAction.setEnabled(!(element.getParent() instanceof Controller) && !this.mIsReverseMappingMode);
        this.mDeleteMappingAction.setEnabled(false);
        this.mEditMappingAction.setEnabled(false);
        this.mEditModelBindingAction.setEnabled(false);
        this.mEditStructureBindingAction.setEnabled(false);
        this.mDeleteStructureBindingAction.setEnabled(false);
        this.mDeleteAction.setEnabled(false);
        if (this.getControllerUsages().length > 0 && !(element instanceof ContextRecursionNode) && (this.mIsReverseMappingMode && element.getIsInputElement() || !this.mIsReverseMappingMode && !element.getIsInputElement())) {
            this.mEditMappingAction.setEnabled(true);
            if (CheckLayerHelper.getMapping((ContextElement)element, (ControllerUsage[])this.getControllerUsages()) != null) {
                this.mDeleteMappingAction.setEnabled(true);
            }
        }
        if (this.mContainer.getModels().length > 0 && (element instanceof ContextModelNode || element instanceof ContextModelAttribute)) {
            if (CheckLayerHelper.getMapping((ContextElement)element, (ControllerUsage[])this.getControllerUsages()) != null) {
                this.mEditModelBindingAction.setEnabled(false);
            } else {
                this.mEditModelBindingAction.setEnabled(true);
            }
        }
        if (element instanceof ContextValueNode && !element.getParent().isMDO()) {
            this.mEditStructureBindingAction.setEnabled(!this.mIsReverseMappingMode);
        }
        if (element instanceof ContextValueNode && (valueNode = (ContextValueNode)element).hasStructure()) {
            this.mDeleteStructureBindingAction.setEnabled(!this.mIsReverseMappingMode);
        }
        if (CheckLayerHelper.getMapping((ContextElement)element, (ControllerUsage[])this.getControllerUsages()) != null) {
            this.mEditStructureBindingAction.setEnabled(false);
            this.mDeleteStructureBindingAction.setEnabled(false);
        }
        this.mExpandSubtreeAction.setEnabled(true);
        this.updateActionsFromSelectionState(element);
    }

    private void updateActionsFromSelectionState(ContextElement element) {
        if (!this.mIsReverseMappingMode && this.mIsFlatSelection && !(element.getParent() instanceof Controller)) {
            this.mDeleteAction.setEnabled(true);
        }
        if (!this.mSingleSelection) {
            this.mEditMappingAction.setEnabled(false);
            this.mEditModelBindingAction.setEnabled(false);
            this.mExpandSubtreeAction.setEnabled(false);
            this.mRenameAction.setEnabled(false);
        }
        if (!this.mIsFlatSelection) {
            this.mDeleteMappingAction.setEnabled(false);
            this.mEditMappingAction.setEnabled(false);
            this.mEditModelBindingAction.setEnabled(false);
            this.mExpandSubtreeAction.setEnabled(false);
        }
    }

    private void initDragAndDrop() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        this.mTreeViewer.addDragSupport(ops, transfers, (DragSourceListener)new ContextDragListener(this));
        this.mTreeViewer.addDropSupport(ops, transfers, (DropTargetListener)new ContextDropListener(this));
    }

    private void delete() {
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        ContextElement selectedElement = (ContextElement)selection.getFirstElement();
        boolean toBeContinued = false;
        toBeContinued = selection.size() == 1 ? UIHelper.askUserToDelete((String)selectedElement.getName(), (String)TextPool.getInstance().getText(909)) : UIHelper.askUserToDeleteNumberOfObjects((int)selection.size());
        if (toBeContinued && this.checkWriteability(this.mDeleteAction)) {
            ContextNode parent = (ContextNode)selectedElement.getParent();
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                ContextElement element = (ContextElement)iterator.next();
                if (element == null || !element.getParent().equals(parent)) continue;
                ServicesDeletion.deleteElement((ContextElement)element, (ControllerUsage[])this.getControllerUsages());
            }
        }
    }

    private void addValueNode() {
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        this.openCreationWizard(selection, class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueNode == null ? (class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueNode = ContextTreeViewer.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode")) : class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueNode, this.mAddValueNodeAction);
    }

    private void addModelNode() {
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        this.openCreationWizard(selection, class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelNode == null ? (class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelNode = ContextTreeViewer.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode")) : class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelNode, this.mAddModelNodeAction);
    }

    private void addRecursionNode() {
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        this.openCreationWizard(selection, class$com$sap$ide$metamodel$webdynpro$component$controller$ContextRecursionNode == null ? (class$com$sap$ide$metamodel$webdynpro$component$controller$ContextRecursionNode = ContextTreeViewer.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextRecursionNode")) : class$com$sap$ide$metamodel$webdynpro$component$controller$ContextRecursionNode, this.mAddRecursionNodeAction);
    }

    private void addValueAttribute() {
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        this.openCreationWizard(selection, class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute == null ? (class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute = ContextTreeViewer.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute")) : class$com$sap$ide$metamodel$webdynpro$component$controller$ContextValueAttribute, this.mAddValueAttributeAction);
    }

    private void addModelAttribute() {
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        this.openCreationWizard(selection, class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute == null ? (class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute = ContextTreeViewer.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute")) : class$com$sap$ide$metamodel$webdynpro$component$controller$ContextModelAttribute, this.mAddModelAttributeAction);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void editContextMapping(String wizardTitle) {
        ContextElement element;
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        if (selection != null && !selection.isEmpty() && this.checkWriteability(this.mEditMappingAction) && (element = (ContextElement)selection.getFirstElement()) != null) {
            block6: {
                ContextMappingWizard wizard = new ContextMappingWizard(wizardTitle, element, this.mContainer.getControllerUsages(), this.mContainer.getDefaultControllerUsage(), this.mIsReverseMappingMode);
                ContextWizardDialog dialog = new ContextWizardDialog((IWizard)wizard);
                boolean wasAutoNotifyEnabled = this.mRoot.getMDO().getRoot().isAutoNotifyEnabled();
                try {
                    if (wasAutoNotifyEnabled) {
                        this.mRoot.getMDO().getRoot().disableAutoNotify();
                    }
                    if (dialog.open() == 0) {
                        this.mTreeViewer.refresh(true);
                    }
                    Object var8_7 = null;
                    if (!wasAutoNotifyEnabled) break block6;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (wasAutoNotifyEnabled) {
                        this.mRoot.getMDO().getRoot().enableAutoNotify();
                    }
                    throw throwable;
                }
                this.mRoot.getMDO().getRoot().enableAutoNotify();
            }
            this.mTreeViewer.setSelection((ISelection)selection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void editModelBinding() {
        IStructuredSelection selection;
        block4: {
            selection = (IStructuredSelection)this.mTreeViewer.getSelection();
            if (selection == null) return;
            if (selection.isEmpty()) return;
            if (!this.checkWriteability(this.mEditModelBindingAction)) return;
            ContextElement element = (ContextElement)selection.getFirstElement();
            if (element == null) return;
            if (element instanceof ContextModelAttribute && element.getParent().getParent().isMDO()) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Not supported", (String)"Context root attributes cannot be bound to model properties. \nOnly mapping is supported for root attributes.");
                return;
            }
            ModelBindingWizard wizard = new ModelBindingWizard(element, this.mContainer.getControllerUsages(), this.mContainer.getModels(), this.mContainer.getDefaultModel());
            ContextWizardDialog dialog = new ContextWizardDialog((IWizard)wizard);
            boolean wasAutoNotifyEnabled = this.mRoot.getMDO().getRoot().isAutoNotifyEnabled();
            try {
                if (wasAutoNotifyEnabled) {
                    this.mRoot.getMDO().getRoot().disableAutoNotify();
                }
                dialog.open();
                Object var7_6 = null;
                if (!wasAutoNotifyEnabled) break block4;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (!wasAutoNotifyEnabled) throw throwable;
                this.mRoot.getMDO().getRoot().enableAutoNotify();
                throw throwable;
            }
            this.mRoot.getMDO().getRoot().enableAutoNotify();
        }
        this.mTreeViewer.setSelection((ISelection)selection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void editStructureBinding() {
        ContextElement element;
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        if (selection != null && !selection.isEmpty() && this.checkWriteability(this.mEditStructureBindingAction) && (element = (ContextElement)selection.getFirstElement()) != null && element instanceof ContextValueNode) {
            block5: {
                StructureBindingWizard wizard = new StructureBindingWizard(element, this.mContainer.getControllerUsages(), this.mContainer.getDefaultControllerUsage());
                ContextWizardDialog dialog = new ContextWizardDialog((IWizard)wizard);
                boolean wasAutoNotifyEnabled = this.mRoot.getMDO().getRoot().isAutoNotifyEnabled();
                try {
                    if (wasAutoNotifyEnabled) {
                        this.mRoot.getMDO().getRoot().disableAutoNotify();
                    }
                    dialog.open();
                    Object var7_6 = null;
                    if (!wasAutoNotifyEnabled) break block5;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (wasAutoNotifyEnabled) {
                        this.mRoot.getMDO().getRoot().enableAutoNotify();
                    }
                    throw throwable;
                }
                this.mRoot.getMDO().getRoot().enableAutoNotify();
            }
            this.mTreeViewer.setSelection((ISelection)selection);
        }
    }

    private void deleteStructureBinding() {
        ContextElement selectedElement;
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        if (selection != null && !selection.isEmpty() && (selectedElement = (ContextElement)selection.getFirstElement()) instanceof ContextValueNode) {
            boolean toBeContinued;
            ContextValueNode node = (ContextValueNode)selectedElement;
            boolean bl = toBeContinued = node.getAttributeCount() == 0 || UIHelper.createMessageDialogToDecide((String)CoreTextPool.getInstance().getText(413), (String)TextPool.getInstance().getText(2515, (Object)node.getName()), (int)3, (int)0).open() == 0;
            if (toBeContinued && this.checkWriteability(this.mDeleteStructureBindingAction)) {
                ServicesDeletion.deleteStructureBinding((ContextValueNode)node);
                this.mTreeViewer.refresh((Object)node);
                this.mTreeViewer.setSelection(this.mTreeViewer.getSelection());
            }
        }
    }

    private void deleteContextMapping() {
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        if (selection != null && !selection.isEmpty() && this.checkWriteability(this.mDeleteMappingAction)) {
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                ContextElement element = (ContextElement)iter.next();
                ServicesDeletion.deleteMapping((ContextElement)element, (ControllerUsage[])this.getControllerUsages(), (!this.mIsReverseMappingMode ? 1 : 0) != 0, (boolean)true);
            }
            ContextElement selectedElement = (ContextElement)selection.getFirstElement();
            if (selection.size() > 1) {
                selectedElement = (ContextElement)selectedElement.getParent();
            }
            this.mTreeViewer.refresh((Object)selectedElement);
            this.mTreeViewer.setSelection(this.mTreeViewer.getSelection());
        }
    }

    private void showHelp() {
        ContextHelp.show((String)"com.sap.devmanual.doc.user", (String)"WDCONTEXT");
    }

    private void copy() {
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object[] objects = selection.toArray();
            ContextElement[] elements = Arrays.asList(objects).toArray(new ContextElement[objects.length]);
            ServicesRefactoring.copyElements((ContextElement[])elements);
            this.mTreeViewer.setSelection((ISelection)selection);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void paste() {
        ContextElement newParent;
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        if (selection == null || selection.isEmpty() || !this.checkWriteability(this.mPasteAction) || !((newParent = (ContextElement)selection.getFirstElement()) instanceof ContextNode)) return;
        boolean wasAutoNotifyEnabled = this.mRoot.getMDO().getRoot().isAutoNotifyEnabled();
        try {
            if (wasAutoNotifyEnabled) {
                this.mRoot.getMDO().getRoot().disableAutoNotify();
            }
            ServicesRefactoring.pasteElements((ContextNode)((ContextNode)newParent), (ControllerUsage[])this.mContainer.getControllerUsages());
            Object var5_4 = null;
            if (!wasAutoNotifyEnabled) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!wasAutoNotifyEnabled) throw throwable;
            this.mRoot.getMDO().getRoot().enableAutoNotify();
            throw throwable;
        }
        this.mRoot.getMDO().getRoot().enableAutoNotify();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pasteSpecial() {
        ContextElement newParent;
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        if (selection != null && !selection.isEmpty() && this.checkWriteability(this.mPasteSpecialAction) && (newParent = (ContextElement)selection.getFirstElement()) instanceof ContextNode) {
            block5: {
                boolean wasAutoNotifyEnabled = this.mRoot.getMDO().getRoot().isAutoNotifyEnabled();
                try {
                    if (wasAutoNotifyEnabled) {
                        this.mRoot.getMDO().getRoot().disableAutoNotify();
                    }
                    ServicesRefactoring.pasteElementsSpecial((ContextNode)((ContextNode)selection.getFirstElement()), (MetamodelClipboard)Metamodel.getClipboard(), (ControllerUsage[])this.mContainer.getControllerUsages());
                    Object var5_4 = null;
                    if (!wasAutoNotifyEnabled) break block5;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (wasAutoNotifyEnabled) {
                        this.mRoot.getMDO().getRoot().enableAutoNotify();
                    }
                    throw throwable;
                }
                this.mRoot.getMDO().getRoot().enableAutoNotify();
            }
            this.mTreeViewer.setSelection((ISelection)selection);
        }
    }

    private void cut() {
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        if (selection != null && !selection.isEmpty() && this.checkWriteability(this.mCutAction)) {
            Object[] objects = selection.toArray();
            ContextElement[] elements = Arrays.asList(objects).toArray(new ContextElement[objects.length]);
            ServicesRefactoring.cutElements((ContextElement[])elements, (ControllerUsage[])this.getControllerUsages());
        }
    }

    private void refreshWithSelectionReset() {
        this.mTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.mRoot));
        this.mTreeViewer.refresh((Object)this.mRoot, true);
    }

    private void openCreationWizard(IStructuredSelection selection, Class contextElementType, IAction action) {
        ContextElement selectedElement;
        if (selection != null && selection.size() == 1 && (selectedElement = (ContextElement)selection.getFirstElement()) instanceof ContextNode) {
            if ((class$com$sap$ide$metamodel$webdynpro$component$controller$ContextAttribute == null ? (class$com$sap$ide$metamodel$webdynpro$component$controller$ContextAttribute = ContextTreeViewer.class$("com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute")) : class$com$sap$ide$metamodel$webdynpro$component$controller$ContextAttribute).isAssignableFrom(contextElementType) && CheckLayerHelper.hasStructureBinding((ContextElement)selectedElement)) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TextPool.getInstance().getText(2325), (String)TextPool.getInstance().getText(2023));
                return;
            }
            if (this.checkWriteability(action)) {
                ContextElement newElement;
                ContextCreationWizard wizard = new ContextCreationWizard((ContextNode)selectedElement, contextElementType);
                WebDynproWizardDialog dialog = new WebDynproWizardDialog((IWizard)wizard, true);
                dialog.setPageSize(200, 350);
                if (dialog.open() == 0 && (newElement = wizard.getNewContextElement()) != null) {
                    this.mTreeViewer.refresh((Object)newElement.getParent());
                    this.mTreeViewer.setSelection((ISelection)new StructuredSelection((Object)newElement));
                }
            }
        }
    }

    private void rename() {
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        ContextElement element = (ContextElement)selection.getFirstElement();
        RenameContextElementWizard renameWizard = new RenameContextElementWizard((DevelopmentObject)element, element.getName());
        RenameWizardDialog wizardDialog = new RenameWizardDialog((RenameWizard)renameWizard);
        if (wizardDialog.open() == 0) {
            this.mTreeViewer.refresh();
        }
    }

    private void showProperties() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet");
            this.mTreeViewer.setSelection(this.mTreeViewer.getSelection());
        }
        catch (PartInitException e) {
            Plugin.internalError(this.getClass(), "showProperties()", e.getMessage(), e, true);
        }
    }

    private boolean isPasteAllowed() {
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        ContextElement element = (ContextElement)selection.getFirstElement();
        MetamodelClipboard clipboard = Metamodel.getClipboard();
        return this.mSingleSelection && ServicesRefactoring.isPasteAllowed((MetamodelClipboard)clipboard, (ContextElement)element);
    }

    private boolean isCopyAllowed() {
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        ContextElement element = (ContextElement)selection.getFirstElement();
        return !element.equals(this.mRoot) && this.isFlatSelection(selection);
    }

    private boolean isCutAllowed() {
        return false;
    }

    private boolean isFlatSelection(IStructuredSelection selection) {
        if (selection != null && selection.size() > 0) {
            DevelopmentObject parent = ((ContextElement)selection.getFirstElement()).getParent();
            Object[] elements = selection.toArray();
            int i = 0;
            while (i < elements.length) {
                if (!((ContextElement)elements[i]).getParent().equals(parent)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean isHomogeneousSelection(IStructuredSelection selection) {
        if (selection != null && selection.size() > 0) {
            ContextElement element = (ContextElement)selection.getFirstElement();
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (element == null || next == null || element.getClass().equals(next.getClass())) continue;
                return false;
            }
        }
        return true;
    }

    private void expandSubtree() {
        IStructuredSelection selection = (IStructuredSelection)this.mTreeViewer.getSelection();
        if (selection != null && !selection.isEmpty()) {
            this.mTreeViewer.expandToLevel(selection.getFirstElement(), -1);
        }
    }

    private boolean checkWriteability(IAction action) {
        return this.checkWriteability(action, (IStructuredSelection)this.mTreeViewer.getSelection());
    }

    private boolean checkWriteability(IAction action, IStructuredSelection selection) {
        ArrayList<Object> mdoToCheck = new ArrayList<Object>();
        if (this.mIsReverseMappingMode) {
            ControllerUsage[] usages = this.mContainer.getControllerUsages();
            if (usages.length > 0 && usages[0].getParent() instanceof ComponentControllerUsage) {
                ComponentControllerUsage compContrUsage = (ComponentControllerUsage)usages[0].getParent();
                mdoToCheck.add(compContrUsage.getComponentUsage().getUsingComponent());
            }
        } else {
            if (action.equals(this.mDeleteAction) && ((Controller)this.mRoot.getMDO()).hasView()) {
                ViewServices viewService = ViewServices.getInstance();
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    IChangeStatus status;
                    Object element = iter.next();
                    if (!(element instanceof ContextElement) || (status = viewService.checkDeleteContextBinding((ContextElement)element)) == null || !ChangeStatusEnum.POSSIBLE.equals(status.getCode())) continue;
                    mdoToCheck.addAll(Arrays.asList(viewService.getAffectedMDOsForDeleteContextBinding((ContextElement)element)));
                    break;
                }
            }
            mdoToCheck.add(this.mRoot.getMDO());
        }
        return RepositoryUtilities.checkWriteability((MainDevelopmentObject[])mdoToCheck.toArray(new MainDevelopmentObject[mdoToCheck.size()]), (boolean)false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class NewMenuManager
    extends MenuManager {
        IStructuredSelection mSelection;

        private NewMenuManager(String text, IStructuredSelection selection) {
            super(text);
            this.mSelection = selection;
        }

        public boolean isVisible() {
            return this.mSelection.size() == 1 && this.mSelection.getFirstElement() instanceof ContextNode;
        }
    }

    private final class ContextTreeKeyListener
    extends KeyAdapter {
        private ContextTreeKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.stateMask == 0 && e.keyCode == 127 && ContextTreeViewer.this.mDeleteAction != null && ContextTreeViewer.this.mDeleteAction.isEnabled()) {
                ContextTreeViewer.this.mDeleteAction.run();
            }
        }
    }

    private final class ContextTreeSelectionChangedListener
    implements ISelectionChangedListener {
        private ContextTreeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)((TreeViewer)event.getSource()).getSelection();
            ContextElement element = (ContextElement)selection.getFirstElement();
            if (element != null) {
                ContextTreeViewer.this.mIsHomogeneousSelection = ContextTreeViewer.this.isHomogeneousSelection(selection);
                ContextTreeViewer.this.mIsFlatSelection = ContextTreeViewer.this.isFlatSelection(selection);
                ContextTreeViewer.this.mSingleSelection = selection.size() == 1;
                ContextTreeViewer.this.updateActions(element);
            }
        }
    }
}

