/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElementMapping;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.checklayer.model.ModelClassHelper;
import com.sap.ide.webdynpro.service.controllereditor.context.ContextService;
import org.eclipse.ui.dialogs.ISelectionValidator;

public final class ContextMappingValidator
implements ISelectionValidator {
    private ContextElement mSource;
    private ControllerUsage[] mControllerUsages;
    private boolean mIsReverseMappingMode = false;

    public ContextMappingValidator(ContextElement source, ControllerUsage[] controllerUsages) {
        this.mSource = source;
        this.mControllerUsages = controllerUsages;
    }

    public ContextMappingValidator(ContextElement source, ControllerUsage[] controllerUsages, boolean isReverseMappingMode) {
        this.mSource = source;
        this.mControllerUsages = controllerUsages;
        this.mIsReverseMappingMode = isReverseMappingMode;
    }

    public String isValid(Object value) {
        String path;
        ContextNode mappedElement;
        ContextElementMapping mapping;
        ContextNode targetParentNode;
        ContextNode sourceParentNode;
        String message = null;
        if (!(value instanceof ContextElement)) {
            return "Invalid element type";
        }
        if (((ContextElement)value).getParent().isMDO() || this.mSource.getParent().isMDO()) {
            return "Context root nodes cannot be mapped";
        }
        if (this.isRecursion(this.mSource, (ContextElement)value)) {
            return "Recursive context mappings are not allowed";
        }
        if (this.mSource.getIsInputElement() && ((ContextElement)value).getIsInputElement()) {
            return "Element must not be an input element";
        }
        if (this.mSource instanceof ContextAttribute) {
            if (value instanceof ContextAttribute && this.mSource instanceof ContextModelAttribute && value instanceof ContextModelAttribute || this.mSource instanceof ContextValueAttribute && value instanceof ContextValueAttribute) {
                sourceParentNode = (ContextNode)this.mSource.getParent();
                targetParentNode = (ContextNode)((ContextAttribute)value).getParent();
                if (!sourceParentNode.getParent().isMDO()) {
                    mapping = CheckLayerHelper.getMapping((ContextElement)sourceParentNode, (ControllerUsage[])this.mControllerUsages);
                    if (mapping != null && mapping.hasMappedElement()) {
                        mappedElement = (ContextNode)mapping.getMappedElement();
                        if (!mappedElement.equals(targetParentNode) && !this.isChildNode(targetParentNode, mappedElement)) {
                            path = ContextService.getAbsoluteContextElementPath((ContextElement)mappedElement);
                            message = "Invalid mapping path. The selected attribute does not match the mapping path '" + path + "...'";
                        }
                    } else {
                        message = "Mapping of origin parent context node missing.";
                    }
                } else if (this.mIsReverseMappingMode) {
                    message = "Context root attributes of interface or configuration controllers cannot be mapped in this version";
                }
            } else {
                message = "Incompatible context element type";
            }
        } else if (this.mSource instanceof ContextNode) {
            if (value instanceof ContextNode) {
                sourceParentNode = (ContextNode)this.mSource.getParent();
                targetParentNode = (ContextNode)((ContextNode)value).getParent();
                if (!sourceParentNode.getParent().isMDO()) {
                    mapping = CheckLayerHelper.getMapping((ContextElement)sourceParentNode, (ControllerUsage[])this.mControllerUsages);
                    if (mapping != null && mapping.hasMappedElement()) {
                        mappedElement = (ContextNode)mapping.getMappedElement();
                        if (!mappedElement.equals(targetParentNode)) {
                            path = ContextService.getAbsoluteContextElementPath((ContextElement)mappedElement);
                            message = "The parent of the origin context node is mapped to a different context node: " + path;
                        }
                    } else {
                        message = "Mapping of origin parent context node missing";
                    }
                }
            } else {
                message = "Incompatible context element types";
            }
        }
        if (message != null) {
            return message;
        }
        if (this.mSource instanceof ContextModelNode) {
            if (!(value instanceof ContextModelNode)) {
                message = "Incompatible context element types";
            } else if (this.mSource.getIsInputElement()) {
                ModelClass sourceModelClass = CheckLayerHelper.getModelClass((ContextModelNode)((ContextModelNode)this.mSource));
                ModelClass targetModelClass = CheckLayerHelper.getModelClass((ContextModelNode)((ContextModelNode)value));
                if (sourceModelClass != null && targetModelClass != null) {
                    if (!ModelClassHelper.isAssignableFrom((ModelClass)sourceModelClass, (ModelClass)targetModelClass)) {
                        message = "Incompatible model class types";
                    }
                } else {
                    message = "Both context nodes have to be bound to a model class";
                }
            }
        } else if (this.mSource instanceof ContextValueAttribute) {
            if (!(value instanceof ContextValueAttribute)) {
                message = "Incompatible context element types";
            } else if (this.mSource.getIsInputElement()) {
                message = CheckLayerHelper.isValidType((DevelopmentObject)CheckLayerHelper.getType((ContextAttribute)((ContextAttribute)this.mSource)), (DevelopmentObject)CheckLayerHelper.getType((ContextAttribute)((ContextAttribute)value)));
            }
        } else if (this.mSource instanceof ContextValueNode) {
            if (!(value instanceof ContextValueNode)) {
                message = "Incompatible context element types";
            }
        } else if (this.mSource instanceof ContextModelAttribute) {
            if (value instanceof ContextModelAttribute) {
                ContextModelNode sourceNodeParent;
                ModelClass sourceModelClass;
                ContextModelAttribute attribute = (ContextModelAttribute)value;
                if (this.mSource.getParent() instanceof ContextModelNode && attribute.getParent() instanceof ContextModelNode && (sourceModelClass = CheckLayerHelper.getModelClass((ContextModelNode)(sourceNodeParent = (ContextModelNode)this.mSource.getParent()))) != null && !ModelClassHelper.hasModelClassProperty((ModelClass)sourceModelClass, (Property)CheckLayerHelper.getReferencedProperty((ContextModelAttribute)((ContextModelAttribute)value)))) {
                    ContextModelNode targetNodeParent = (ContextModelNode)attribute.getParent();
                    ModelClass targetModelClass = CheckLayerHelper.getModelClass((ContextModelNode)targetNodeParent);
                    ContextElementMapping mapping2 = CheckLayerHelper.getMapping((ContextElement)sourceNodeParent, (ControllerUsage[])this.mControllerUsages);
                    if (mapping2 != null && mapping2.getMappedElement() != null && !this.isChildNode((ContextNode)targetNodeParent, (ContextNode)mapping2.getMappedElement())) {
                        message = "Incompatible model class types";
                    }
                }
                if (this.mSource.getIsInputElement()) {
                    ModelClassProperty sourceProperty = CheckLayerHelper.getReferencedProperty((ContextModelAttribute)((ContextModelAttribute)this.mSource));
                    ModelClassProperty targetProperty = CheckLayerHelper.getReferencedProperty((ContextModelAttribute)((ContextModelAttribute)value));
                    if (sourceProperty != null && targetProperty != null) {
                        if (!sourceProperty.equals(targetProperty)) {
                            message = "Both context attributes have to be bound to the same model class property";
                        }
                    } else {
                        message = "Both context attributes have to be bound to a model class property";
                    }
                }
            } else {
                message = "Incompatible context element types";
            }
        } else {
            message = "Context element type not supported";
        }
        return message;
    }

    private boolean isChildNode(ContextNode node, ContextNode parentNode) {
        ContextNode curNode = node;
        while (curNode != null && !curNode.getParent().isMDO()) {
            if (parentNode == curNode) {
                return true;
            }
            curNode = (ContextElement)curNode.getParent();
        }
        return false;
    }

    private boolean isRecursion(ContextElement source, ContextElement target) {
        Object element = target;
        while (element != null) {
            if (element == source) {
                return true;
            }
            ContextElementMapping mapping = CheckLayerHelper.getMapping((ContextElement)element, (ControllerUsage[])((Controller)element.getMDO()).getOutgoingControllerUsages());
            element = mapping != null ? mapping.getMappedElement() : null;
        }
        return false;
    }
}

