/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context;

import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.controllereditor.context.ContextElementSelection;
import com.sap.ide.webdynpro.controllereditor.context.ContextListBarItem;
import com.sap.ide.webdynpro.controllereditor.context.ListBarItem;
import com.sap.ide.webdynpro.controllereditor.context.ListBarViewer;
import com.sap.ide.webdynpro.controllereditor.context.PropertySourceProvider;
import com.sap.ide.webdynpro.controllereditor.context.SelectableListBarItem;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelListBarItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public class ContextListBarViewer
extends ListBarViewer {
    private PropertySourceProvider mPropertySourceProvider;
    private ControllerUsage[] mControllerUsages;
    private Model[] mModels;

    public ContextListBarViewer(PropertySourceProvider provider) {
        super(provider.getOutgoingControllerUsageCount());
        this.mPropertySourceProvider = provider;
    }

    public ContextListBarViewer(ControllerUsage[] controllerUsages) {
        super(controllerUsages.length);
        this.mControllerUsages = controllerUsages;
    }

    public ContextListBarViewer(Model[] models) {
        this.mModels = models;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSelection(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) return;
        Object element = ((StructuredSelection)selection).getFirstElement();
        ListBarItem[] listbarItems = this.getTrayItems();
        SelectableListBarItem selectedListBarItem = null;
        if (element instanceof ContextElement) {
            if (!(selection instanceof ContextElementSelection)) throw new IllegalStateException("Selection must be a ContextElementSelection" + selection);
            ContextElementSelection contextSelection = (ContextElementSelection)selection;
            ControllerUsage usage = contextSelection.getControllerUsage();
            int i = 0;
            while (i < listbarItems.length) {
                if (listbarItems[i] instanceof ContextListBarItem && ((ContextListBarItem)listbarItems[i]).getControllerUsage().equals(usage)) {
                    selectedListBarItem = (SelectableListBarItem)listbarItems[i];
                    break;
                }
                ++i;
            }
        } else if (element instanceof Model || element instanceof ModelClass || element instanceof ModelRelationRole || element instanceof ModelClassProperty) {
            Model model = null;
            if (!(element instanceof Model)) {
                ModelRelation modelRelation;
                if (element instanceof ModelClass) {
                    model = ((ModelClass)element).getModel();
                } else if (element instanceof ModelClassProperty) {
                    model = ((ModelClass)((ModelClassProperty)element).getParent()).getModel();
                } else if (element instanceof ModelRelationRole && (modelRelation = ((ModelRelationRole)element).getModelRelation()) != null) {
                    model = modelRelation.getModel();
                }
            }
            if (model != null) {
                int i = 0;
                while (i < listbarItems.length) {
                    if (listbarItems[i] instanceof ModelListBarItem && model.equals(((ModelListBarItem)listbarItems[i]).getModel())) {
                        selectedListBarItem = (SelectableListBarItem)listbarItems[i];
                        break;
                    }
                    ++i;
                }
            }
        }
        if (selectedListBarItem == null) return;
        this.setActiveTrayItem(selectedListBarItem);
        ISelectionProvider provider = selectedListBarItem.getSelectionProvider();
        if (provider == null) return;
        provider.setSelection(selection);
        if (!(provider instanceof TreeViewer)) return;
        TreeViewer contextTree = (TreeViewer)provider;
        if (element instanceof ModelRelationRole) {
            contextTree.expandToLevel(element, 2);
            return;
        } else {
            contextTree.expandToLevel(element, 1);
        }
    }

    protected void initClientArea(Composite parent) {
        int i;
        SelectableListBarItem trayItem = null;
        ControllerUsage[] usages = this.getControllerUsages();
        Model[] models = this.getModels();
        if (usages != null) {
            i = 0;
            while (i < usages.length) {
                Controller usedController = usages[i].getUsedController();
                if (usedController != null) {
                    trayItem = new ContextListBarItem(usages[i]);
                    this.addTrayItem(trayItem, false);
                }
                ++i;
            }
        }
        if (models != null) {
            i = 0;
            while (i < models.length) {
                trayItem = new ModelListBarItem(models[i]);
                this.addTrayItem(trayItem, false);
                ++i;
            }
        }
        this.registerConrollerUsageObserver(parent);
        this.registerModelUsageObserver(parent);
    }

    protected void fireSelectionChangedEvent(SelectionChangedEvent event) {
        ListBarItem activeItem = this.getActiveTrayItem();
        if (activeItem instanceof ContextListBarItem) {
            ControllerUsage usage = ((ContextListBarItem)activeItem).getControllerUsage();
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                ContextElementSelection contextSelection = new ContextElementSelection(sel, usage);
                event = new SelectionChangedEvent(event.getSelectionProvider(), (ISelection)contextSelection);
            }
        }
        super.fireSelectionChangedEvent(event);
    }

    private ControllerUsage[] getControllerUsages() {
        if (this.mPropertySourceProvider != null) {
            return this.mPropertySourceProvider.getOutgoingControllerUsages();
        }
        return this.mControllerUsages;
    }

    private Model[] getModels() {
        if (this.mPropertySourceProvider != null) {
            return this.mPropertySourceProvider.getUsedModels();
        }
        return this.mModels;
    }

    private void registerConrollerUsageObserver(Composite composite) {
        if (this.mPropertySourceProvider != null) {
            final ControllerUsageObserver observer = new ControllerUsageObserver();
            this.mPropertySourceProvider.attachControllerUsageObserver(observer, 24);
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ContextListBarViewer.this.mPropertySourceProvider.detachControllerUsageObserver(observer);
                }
            });
        }
    }

    private void registerModelUsageObserver(Composite composite) {
        if (this.mPropertySourceProvider != null) {
            final ModelUsageObserver observer = new ModelUsageObserver();
            this.mPropertySourceProvider.attachModelUsageObserver(observer, 768);
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ContextListBarViewer.this.mPropertySourceProvider.detachModelUsageObserver(observer);
                }
            });
        }
    }

    private class ModelUsageObserver
    implements DevelopmentObjectObserver {
        private ModelUsageObserver() {
        }

        public void update(MetamodelEvent event) {
            block9: {
                Model[] models;
                block10: {
                    if (!(event.getModifiedObject() instanceof Component) && !(event.getModifiedObject() instanceof ComponentInterfaceDefinition)) break block9;
                    models = ContextListBarViewer.this.getModels();
                    if (event.getEventId() != 256) break block10;
                    int i = 0;
                    while (i < models.length) {
                        boolean found = false;
                        int j = 0;
                        while (j < ContextListBarViewer.this.mTrayItems.size()) {
                            ListBarItem item = (ListBarItem)ContextListBarViewer.this.mTrayItems.get(j);
                            if (item instanceof ModelListBarItem && ((ModelListBarItem)item).getModel() == models[i]) {
                                found = true;
                                break;
                            }
                            ++j;
                        }
                        if (!found || ContextListBarViewer.this.mTrayItems.size() == 0) {
                            ModelListBarItem trayItem = new ModelListBarItem(models[i]);
                            ContextListBarViewer.this.addTrayItem(trayItem, true);
                            break block9;
                        }
                        ++i;
                    }
                    break block9;
                }
                if (event.getEventId() != 512) break block9;
                int i = 0;
                while (i < ContextListBarViewer.this.mTrayItems.size()) {
                    ListBarItem item = (ListBarItem)ContextListBarViewer.this.mTrayItems.get(i);
                    boolean found = false;
                    if (item instanceof ModelListBarItem) {
                        int j = 0;
                        while (j < models.length) {
                            if (((ModelListBarItem)item).getModel() == models[j]) {
                                found = true;
                            }
                            ++j;
                        }
                        if (!found) {
                            ContextListBarViewer.this.removeTrayItem(i, true);
                            break;
                        }
                    }
                    ++i;
                }
            }
        }

        public void update(MetamodelEvent[] events) {
            int i = 0;
            while (i < events.length) {
                this.update(events[i]);
                ++i;
            }
        }
    }

    private class ControllerUsageObserver
    implements DevelopmentObjectObserver {
        private ControllerUsageObserver() {
        }

        public void update(MetamodelEvent event) {
            block10: {
                ControllerUsage[] usages;
                block11: {
                    if (!(event.getModifiedObject() instanceof Controller) && !(event.getModifiedObject() instanceof ComponentControllerUsage)) break block10;
                    usages = ContextListBarViewer.this.getControllerUsages();
                    if (event.getEventId() != 8) break block11;
                    int i = 0;
                    while (i < usages.length) {
                        boolean found = false;
                        if (usages[i].getUsedController() != null) {
                            int j = 0;
                            while (j < ContextListBarViewer.this.mTrayItems.size()) {
                                ListBarItem item = (ListBarItem)ContextListBarViewer.this.mTrayItems.get(j);
                                if (item instanceof ContextListBarItem && usages[i] != null && ((ContextListBarItem)item).getControllerUsage() == usages[i]) {
                                    found = true;
                                    break;
                                }
                                ++j;
                            }
                            if (!(found && ContextListBarViewer.this.mTrayItems.size() != 0 || usages[i] == null)) {
                                ContextListBarItem trayItem = new ContextListBarItem(usages[i]);
                                ContextListBarViewer.this.addTrayItem(trayItem, true);
                                break block10;
                            }
                        }
                        ++i;
                    }
                    break block10;
                }
                if (event.getEventId() != 16) break block10;
                int i = 0;
                while (i < ContextListBarViewer.this.mTrayItems.size()) {
                    ListBarItem item = (ListBarItem)ContextListBarViewer.this.mTrayItems.get(i);
                    boolean found = false;
                    if (item instanceof ContextListBarItem) {
                        int j = 0;
                        while (j < usages.length) {
                            if (usages[j] != null && ((ContextListBarItem)item).getControllerUsage() == usages[j]) {
                                found = true;
                            }
                            ++j;
                        }
                        if (!found) {
                            ContextListBarViewer.this.removeTrayItem(i, true);
                            break;
                        }
                    }
                    ++i;
                }
            }
        }

        public void update(MetamodelEvent[] events) {
            int i = 0;
            while (i < events.length) {
                this.update(events[i]);
                ++i;
            }
        }
    }
}

