/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context;

import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.webdynpro.controllereditor.context.ContextTreeViewer;
import com.sap.ide.webdynpro.controllereditor.context.SelectableListBarItem;
import com.sap.ide.webdynpro.service.controllereditor.usage.ControllerUsageService;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;

public class ContextListBarItem
extends SelectableListBarItem {
    private ContextNode mContext;
    private ControllerUsage mControllerUsage;
    private ContextTreeViewer mContextViewer;
    private DevelopmentObjectObserver mRefactorObserver;

    public ContextListBarItem(ContextNode context) {
        this(context.getName(), context);
    }

    public ContextListBarItem(ControllerUsage usage) {
        this(ContextListBarItem.getLabel(usage), usage);
    }

    public ContextListBarItem(String label, ContextNode context) {
        super(label);
        this.mContext = context;
        this.mRefactorObserver = new RefactorObserver();
        context.getMDO().attachObserver(this.mRefactorObserver, 8256);
    }

    public ContextListBarItem(String label, ControllerUsage usage) {
        super(label);
        this.mContext = usage.getUsedController().getContext();
        this.mControllerUsage = usage;
        this.mRefactorObserver = new RefactorObserver();
        this.mContext.getMDO().attachObserver(this.mRefactorObserver, 8256);
    }

    protected void initExpansion(Composite expansion) {
        this.mContextViewer = new ContextTreeViewer(expansion, this.mContext, false);
    }

    public ContextElement getContextElement() {
        return this.mContext;
    }

    public ControllerUsage getControllerUsage() {
        return this.mControllerUsage;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.mContextViewer.getViewer();
    }

    public void dispose() {
        this.mContext.getMDO().detachObserver(this.mRefactorObserver);
        super.dispose();
    }

    private static String getLabel(ControllerUsage usage) {
        return ControllerUsageService.getComponentUsageDisplayName((ControllerUsage)usage);
    }

    private Controller getController(ControllerUsage usage) {
        if (usage.getUsedController() != null) {
            return usage.getUsedController();
        }
        return null;
    }

    private class RefactorObserver
    implements DevelopmentObjectObserver {
        private RefactorObserver() {
        }

        public void update(MetamodelEvent event) {
            ContextListBarItem.this.setText(ContextListBarItem.getLabel(ContextListBarItem.this.mControllerUsage));
        }

        public void update(MetamodelEvent[] events) {
            if (events.length > 0) {
                this.update(events[0]);
            }
        }
    }
}

