/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context;

import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.webdynpro.controllereditor.context.ContextListBarItem;
import com.sap.ide.webdynpro.controllereditor.context.ContextListBarViewer;
import com.sap.ide.webdynpro.controllereditor.context.ContextTreeViewer;
import com.sap.ide.webdynpro.controllereditor.context.IContextViewerContainer;
import com.sap.ide.webdynpro.controllereditor.context.ListBarItem;
import com.sap.ide.webdynpro.controllereditor.context.PropertySourceProvider;
import com.sap.ide.webdynpro.controllereditor.context.SelectableListBarItem;
import com.sap.ide.webdynpro.controllereditor.context.model.ModelListBarItem;
import com.sap.ide.webdynpro.service.core.ServiceCorePlugin;
import com.tssap.util.ui.glpc.form.AbstractForm;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.pane.ISimplePane;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class ContextEditorForm
extends AbstractForm
implements ISelectionProvider,
IContextViewerContainer {
    private ISashPane mPane;
    private ContextTreeViewer mContextViewer;
    private ContextListBarViewer mContextListBarViewer;
    private PropertySourceProvider mPropertySourceProvider;

    public ContextEditorForm(PropertySourceProvider controllerWrapper) {
        super(ServiceCorePlugin.WIDGET_FACTORY, 1, "Context");
        this.mPropertySourceProvider = controllerWrapper;
    }

    public void initForm(IGridLayoutPane glp) {
        this.mPane = glp.addHorizontalSashPane(glp.createGridLayoutData(4, 4, true, true));
        ISimplePane sp = this.mPane.addSimplePane();
        this.mContextViewer = new ContextTreeViewer(sp.getComposite(), (ContextNode)this.mPropertySourceProvider.getContext(), this, true, true, this.mPropertySourceProvider.isReverseMappingMode());
        sp = this.mPane.addSimplePane();
        this.mContextListBarViewer = new ContextListBarViewer(this.mPropertySourceProvider);
        this.mContextListBarViewer.init(sp.getComposite());
        this.mContextListBarViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event != null && !event.getSelection().isEmpty() && !ContextEditorForm.this.mContextViewer.getViewer().getSelection().isEmpty()) {
                    ContextEditorForm.this.mContextViewer.getViewer().setSelection((ISelection)new StructuredSelection());
                }
            }
        });
        this.mContextViewer.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelectionProvider selectionProvider;
                ListBarItem trayItem;
                if (!event.getSelection().isEmpty() && (trayItem = ContextEditorForm.this.mContextListBarViewer.getActiveTrayItem()) != null && trayItem instanceof SelectableListBarItem && (selectionProvider = ((SelectableListBarItem)trayItem).getSelectionProvider()) != null && !selectionProvider.getSelection().isEmpty()) {
                    selectionProvider.setSelection((ISelection)new StructuredSelection());
                }
            }
        });
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.mContextViewer.getViewer().addSelectionChangedListener(listener);
        this.mContextListBarViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.mContextViewer.getViewer().removeSelectionChangedListener(listener);
        this.mContextListBarViewer.removeSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider != null) {
            return selectionProvider.getSelection();
        }
        return new StructuredSelection();
    }

    public void setSelection(ISelection selection) {
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.setSelection(selection);
        }
    }

    public void setFocus() {
        this.setSelection(this.getSelection());
        this.mContextViewer.getViewer().refresh(true);
    }

    private ISelectionProvider getSelectionProvider() {
        ISelection selection;
        ISelectionProvider selectionProvider;
        ListBarItem trayItem = this.mContextListBarViewer.getActiveTrayItem();
        if (trayItem != null && trayItem instanceof SelectableListBarItem && (selectionProvider = ((SelectableListBarItem)trayItem).getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) != null && !selection.isEmpty()) {
            return selectionProvider;
        }
        return this.mContextViewer.getViewer();
    }

    public ControllerUsage[] getControllerUsages() {
        return this.mPropertySourceProvider.getOutgoingControllerUsages();
    }

    public ControllerUsage getDefaultControllerUsage() {
        ListBarItem item = this.mContextListBarViewer.getActiveTrayItem();
        if (item != null && item instanceof ContextListBarItem) {
            return ((ContextListBarItem)item).getControllerUsage();
        }
        return null;
    }

    public Model getDefaultModel() {
        ListBarItem item = this.mContextListBarViewer.getActiveTrayItem();
        if (item != null && item instanceof ModelListBarItem) {
            return ((ModelListBarItem)item).getModel();
        }
        return null;
    }

    public Model[] getModels() {
        return this.mPropertySourceProvider.getUsedModels();
    }

    public Component getEmbeddingComponent() {
        return this.mPropertySourceProvider.getEmbeddingComponent();
    }

    public IAction getAction(String actionId) {
        return this.mContextViewer.getGlobalAction(actionId);
    }
}

