/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context;

import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.context.ContextTreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;

public class ContextDropListener
implements DropTargetListener {
    protected static final long HOVER_TRESHHOLD = 1200L;
    protected long mHoverStart = 0L;
    private ContextElement mCurrentTarget;
    private ContextTreeViewer mContextViewer;

    public ContextDropListener(ContextTreeViewer viewer) {
        this.mContextViewer = viewer;
    }

    public void dragEnter(DropTargetEvent event) {
        this.mCurrentTarget = this.determineTarget(event);
        this.mHoverStart = System.currentTimeMillis();
        if (!TextTransfer.getInstance().isSupportedType(event.dataTypes[0]) || event.item.getData() instanceof ContextValueNode) {
            // empty if block
        }
        System.out.println("dragEnter");
    }

    public void dragLeave(DropTargetEvent event) {
        System.out.println("dragLeave");
    }

    public void dragOperationChanged(DropTargetEvent event) {
        System.out.println("dragOperationChanged");
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback |= 0x18;
    }

    public void drop(DropTargetEvent event) {
        if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
            if (event.item.getData() instanceof ContextValueNode && ((ContextValueNode)event.item.getData()).getName().compareTo(event.data) != 0) {
                try {
                    ((ContextValueNode)event.item.getData()).createChildNodeAsContextValueNode((String)event.data);
                }
                catch (CreateException e) {
                    Plugin.internalError(this.getClass(), "drop()", "Failed to create context element", e, false);
                }
            } else {
                event.detail = 0;
            }
        }
        System.out.println("drop");
    }

    public void dropAccept(DropTargetEvent event) {
        System.out.println("dropAccept");
    }

    protected ContextElement determineTarget(DropTargetEvent event) {
        ContextElement target = null;
        if (event.item != null) {
            target = (ContextElement)event.item.getData();
        }
        return target;
    }
}

