/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context;

import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.webdynpro.controllereditor.Plugin;
import com.sap.ide.webdynpro.controllereditor.context.ContextTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;

public class ContextDragListener
implements DragSourceListener {
    ContextTreeViewer mContextViewer;
    ContextElement mData;

    public ContextDragListener(ContextTreeViewer viewer) {
        this.mContextViewer = viewer;
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.mContextViewer.getViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            this.mData = (ContextElement)((IStructuredSelection)selection).getFirstElement();
        } else {
            event.doit = false;
        }
        System.out.println("dragStart");
    }

    public void dragSetData(DragSourceEvent event) {
        if (TextTransfer.getInstance().isSupportedType(event.dataType) && this.mData != null) {
            event.data = this.mData.getName();
        }
        System.out.println("dragSetData");
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.doit && event.detail == 2 && this.mData != null && !this.mData.isMDO()) {
            try {
                this.mData.delete();
            }
            catch (DeleteException e) {
                Plugin.internalError(this.getClass(), "dragFinished()", "Failed to delete source context element", e, false);
            }
            this.mData = null;
        }
        System.out.println("dragFinished");
    }
}

