/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context;

import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.controllereditor.context.ContextTreeViewer;
import com.sap.ide.webdynpro.controllereditor.context.ContextValidationLabelProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionValidator;

public class ContextDialog
extends TitleAreaDialog {
    private ContextNode mContext;
    private ContextTreeViewer mContextViewer;
    private ContextElement mSelection;
    private String mWindowTitle;
    private String mTitle;
    private String mDescription;
    private ISelectionValidator mValidator;
    private ContextValidationLabelProvider mLabelProvider;

    public ContextDialog(String title, String description, ContextNode contextRoot) {
        this(title, title, description, contextRoot, null);
    }

    public ContextDialog(String windowTitle, String title, String description, ContextNode contextRoot, ContextElement selection) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.mWindowTitle = windowTitle;
        this.mTitle = title;
        this.mDescription = description;
        this.mContext = contextRoot;
        this.mSelection = selection;
    }

    public ContextElement getSelection() {
        return this.mSelection;
    }

    public void setValidator(ISelectionValidator validator) {
        this.mValidator = validator;
        if (this.mLabelProvider != null) {
            this.mLabelProvider.setValidator(validator);
        }
    }

    protected final Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.numColumns = 1;
        contents.setLayout((Layout)layout);
        contents.setLayoutData((Object)new GridData(1808));
        contents.setFont(parentComposite.getFont());
        this.setTitle(this.mTitle);
        this.setMessage(this.mDescription);
        this.getShell().setText(this.mWindowTitle);
        this.mContextViewer = new ContextTreeViewer(contents, this.mContext, false);
        this.mContextViewer.getViewer().setLabelProvider((IBaseLabelProvider)new ContextValidationLabelProvider(CheckLayerHelper.getOutgoingControllerUsages((ContextElement)this.mContext), this.mValidator));
        GridData data = new GridData(1040);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        this.mContextViewer.getViewer().getControl().setLayoutData((Object)data);
        if (this.mContext.getChildNodeCount() > 0 && this.mValidator != null && this.mValidator.isValid((Object)this.mContext.getChildNode(0)) == null) {
            this.mContextViewer.getViewer().expandToLevel(2);
        } else {
            this.mContextViewer.getViewer().expandToLevel(3);
        }
        if (this.mSelection != null) {
            this.mContextViewer.getViewer().setSelection((ISelection)new StructuredSelection((Object)this.mSelection));
        } else {
            this.mContextViewer.getViewer().setSelection((ISelection)new StructuredSelection((Object)this.mContext));
            this.mContextViewer.getViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        }
        this.mContextViewer.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    ContextDialog.this.mSelection = (ContextElement)((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (ContextDialog.super.getButton(0) != null) {
                        ContextDialog.super.getButton(0).setEnabled(ContextDialog.this.isSelectionValid());
                    }
                } else if (ContextDialog.super.getButton(0) != null) {
                    ContextDialog.super.getButton(0).setEnabled(false);
                }
            }
        });
        this.mContextViewer.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ContextDialog.this.isSelectionValid()) {
                    ContextDialog.this.close();
                }
            }
        });
        return contents;
    }

    protected boolean isSelectionValid() {
        String message = null;
        if (this.mValidator != null) {
            message = this.mValidator.isValid((Object)this.mSelection);
            this.setErrorMessage(message);
        }
        return message == null;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.y += 300;
        return size;
    }
}

