/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.controllereditor.context;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElementMapping;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class ContextContentProvider
implements ITreeContentProvider,
DevelopmentObjectObserver,
Runnable {
    private static Object[] EMPTY_ARRAY = new Object[0];
    private static ControllerUsage[] EMPTY_USAGES = new ControllerUsage[0];
    private TreeViewer mViewer;
    private boolean mIsReverseMappingMode = false;
    private ContextElement mRoot;
    private MainDevelopmentObject mMDOToRegister;
    private boolean mPendingRefresh = false;
    private DevelopmentObject mModifiedObject;

    public ContextContentProvider() {
        this(null);
    }

    public ContextContentProvider(ContextRoot contextRoot) {
        if (contextRoot != null) {
            this.mRoot = contextRoot.getRoot();
            this.mMDOToRegister = this.mRoot.getMDO();
        }
    }

    public ContextContentProvider(ContextRoot contextRoot, boolean isReverseMapping, Component embeddingComponent) {
        if (contextRoot != null) {
            this.mRoot = contextRoot.getRoot();
        }
        this.mIsReverseMappingMode = isReverseMapping;
        if (this.mIsReverseMappingMode) {
            this.mMDOToRegister = embeddingComponent;
        }
    }

    public Object[] getChildren(Object element) {
        Object[] children = EMPTY_ARRAY;
        if (element instanceof ContextNode && !((ContextNode)element).isDeleted()) {
            ContextAttribute[] attributes = ((ContextNode)element).getAttributes();
            AbstractContextNode[] nodes = ((ContextNode)element).getChildNodes();
            children = new Object[attributes.length + nodes.length];
            System.arraycopy(attributes, 0, children, 0, attributes.length);
            System.arraycopy(nodes, 0, children, attributes.length, nodes.length);
            return children;
        }
        return children;
    }

    public Object getParent(Object element) {
        ContextElement contextElement;
        if (element instanceof ContextElement && !(contextElement = (ContextElement)element).isDeleted() && !(((ContextElement)element).getParent() instanceof Controller)) {
            return contextElement.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ContextNode && !((ContextNode)element).isDeleted()) {
            return ((ContextNode)element).getAttributeCount() > 0 || ((ContextNode)element).getChildNodeCount() > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        Object[] children = EMPTY_ARRAY;
        if (inputElement instanceof ContextRoot) {
            if (this.mRoot != null) {
                children = new Object[]{this.mRoot};
            } else {
                return EMPTY_ARRAY;
            }
        }
        return children;
    }

    public void dispose() {
        if (this.mMDOToRegister != null) {
            this.mMDOToRegister.detachChildrenObserver((DevelopmentObjectObserver)this);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.mViewer = (TreeViewer)viewer;
        if (!this.mIsReverseMappingMode) {
            if (this.mMDOToRegister != null) {
                this.mMDOToRegister.detachChildrenObserver((DevelopmentObjectObserver)this);
                this.mMDOToRegister = null;
            }
            if (newInput != null && newInput instanceof ContextRoot) {
                this.mRoot = ((ContextRoot)newInput).getRoot();
                this.mMDOToRegister = this.mRoot.getMDO();
            }
        }
        if (this.mMDOToRegister != null) {
            this.mMDOToRegister.attachChildrenObserver((DevelopmentObjectObserver)this, 65535);
        }
    }

    public void update(MetamodelEvent event) {
        if (!this.mPendingRefresh) {
            int evtId = event.getEventId();
            DevelopmentObject modifiedObject = event.getModifiedObject();
            if (evtId != 8192 && evtId != 2 && evtId != 16) {
                if (modifiedObject instanceof ContextElementMapping) {
                    this.mModifiedObject = this.mRoot;
                } else if (modifiedObject instanceof ContextElement) {
                    this.mModifiedObject = event.getModifiedObject();
                }
            }
            Display.getDefault().asyncExec((Runnable)this);
            this.mPendingRefresh = true;
        }
    }

    public void update(MetamodelEvent[] events) {
        int i = 0;
        while (i < events.length) {
            if (events[i].getModifiedObject() instanceof ContextElement) {
                this.mViewer.refresh(true);
                break;
            }
            ++i;
        }
    }

    public void run() {
        this.refreshTree();
    }

    private void refreshTree() {
        try {
            if (!this.mViewer.getTree().isDisposed()) {
                if (this.mModifiedObject != null) {
                    this.mViewer.refresh((Object)this.mModifiedObject, true);
                    this.mModifiedObject = null;
                } else {
                    this.mViewer.refresh(true);
                }
            }
            Object var2_1 = null;
            this.mPendingRefresh = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mPendingRefresh = false;
            throw throwable;
        }
    }

    public static class ContextRoot {
        private ContextElement mRoot;

        public ContextRoot(ContextElement root) {
            this.mRoot = root;
        }

        public ContextElement getRoot() {
            return this.mRoot;
        }
    }
}

